/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.jga.util.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookAheadIterator<T>
implements Iterator<T>,
Iterable<T> {
    private Iterator<? extends T> _base;
    private Object[] _buffer;
    private int _readptr = 0;
    private int _writeptr = 0;
    private int _cnt = 0;
    private int _size;

    public LookAheadIterator(Iterator<? extends T> base) {
        this(base, 1);
    }

    public LookAheadIterator(Iterator<? extends T> base, int max) {
        if (max <= 0) {
            throw new IllegalArgumentException();
        }
        this._base = base != null ? base : new EmptyIterator();
        this._size = max;
        this._buffer = new Object[this._size];
    }

    public boolean hasNextPlus(int n) {
        if (n < 0 || n > this._size) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this.hasNext();
        }
        return this.readAhead(n);
    }

    public T peek(int n) {
        if (n < 0 || n > this._size) {
            throw new IllegalArgumentException();
        }
        if (!this.readAhead(n)) {
            throw new NoSuchElementException();
        }
        int offset = (this._readptr + n - 1) % this._size;
        return (T)this._buffer[offset];
    }

    public int getMaxPeekSize() {
        return this._size;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this._cnt > 0) {
            return true;
        }
        return this._base.hasNext();
    }

    @Override
    public T next() {
        if (this._cnt == 0) {
            return this._base.next();
        }
        Object value = this._buffer[this._readptr];
        this._readptr = this.advance(this._readptr);
        --this._cnt;
        return (T)value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean readAhead(int n) {
        if (n <= this._cnt) {
            return true;
        }
        while (n > this._cnt && this._base.hasNext()) {
            this._buffer[this._writeptr] = this._base.next();
            ++this._cnt;
            this._writeptr = this.advance(this._writeptr);
        }
        return n == this._cnt;
    }

    private int advance(int n) {
        return ++n % this._size;
    }
}

