/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.comparison.LessEqual;
import net.sf.jga.util.LookAheadIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeIterator<T>
implements Iterator<T>,
Iterable<T> {
    private LookAheadIterator<? extends T> _base1;
    private LookAheadIterator<? extends T> _base2;
    private BinaryFunctor<T, T, Boolean> _pred;

    public MergeIterator(Iterator<? extends T> base1, Iterator<? extends T> base2, Comparator<T> comp) {
        this(base1, base2, new LessEqual<T>(comp));
    }

    public MergeIterator(Iterator<? extends T> base1, Iterator<? extends T> base2, BinaryFunctor<T, T, Boolean> pred) {
        if (base1 == null || base2 == null) {
            String msg = "two base iterators are required";
            throw new IllegalArgumentException(msg);
        }
        if (pred == null) {
            String msg = "functor is required";
            throw new IllegalArgumentException(msg);
        }
        this._base1 = new LookAheadIterator<T>(base1, 1);
        this._base2 = new LookAheadIterator<T>(base2, 1);
        this._pred = pred;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this._base1.hasNextPlus(1) || this._base2.hasNextPlus(1);
    }

    @Override
    public T next() {
        if (this._base1.hasNextPlus(1)) {
            if (this._base2.hasNextPlus(1)) {
                if (this._pred.fn(this._base1.peek(1), this._base2.peek(1)).booleanValue()) {
                    return this._base1.next();
                }
                return this._base2.next();
            }
            return this._base1.next();
        }
        if (this._base2.hasNextPlus(1)) {
            return this._base2.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

