/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.util;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonIterator<T>
implements ListIterator<T>,
Iterable<T> {
    private T _value;
    private boolean _beforeValue = true;
    private boolean _canSetValue = false;

    public SingletonIterator(T value) {
        this._value = value;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this._beforeValue;
    }

    @Override
    public T next() {
        if (!this._beforeValue) {
            throw new NoSuchElementException();
        }
        this._beforeValue = false;
        this._canSetValue = true;
        return this._value;
    }

    @Override
    public boolean hasPrevious() {
        return !this._beforeValue;
    }

    @Override
    public T previous() {
        if (this._beforeValue) {
            throw new NoSuchElementException();
        }
        this._beforeValue = true;
        this._canSetValue = true;
        return this._value;
    }

    @Override
    public int nextIndex() {
        return this._beforeValue ? 0 : 1;
    }

    @Override
    public int previousIndex() {
        return this._beforeValue ? -1 : 0;
    }

    @Override
    public void add(T arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T value) {
        if (!this._canSetValue) {
            throw new IllegalStateException();
        }
        this._value = value;
        this._canSetValue = false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

