/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jga.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.comparison.EqualTo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueIterator<T>
implements Iterator<T>,
Iterable<T> {
    private Iterator<? extends T> _base;
    private BinaryFunctor<T, T, Boolean> _eq;
    private Boolean _testedNext;
    private boolean _hasNext;
    private T _lastValue;
    private T _nextValue;

    public UniqueIterator(Iterator<? extends T> base) {
        this(base, new EqualTo());
    }

    public UniqueIterator(Iterator<? extends T> base, BinaryFunctor<T, T, Boolean> eq) {
        if (base == null) {
            throw new IllegalArgumentException("base iterator is required");
        }
        if (eq == null) {
            throw new IllegalArgumentException("functor is required");
        }
        this._base = base;
        this._eq = eq;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this._testedNext != null) {
            if (!this._testedNext.booleanValue()) {
                this._testedNext = Boolean.TRUE;
                this._hasNext = false;
                while (this._base.hasNext()) {
                    this._nextValue = this._base.next();
                    if (this._eq.fn(this._lastValue, this._nextValue).booleanValue()) continue;
                    this._hasNext = true;
                    break;
                }
            }
        } else {
            this._testedNext = Boolean.TRUE;
            this._hasNext = this._base.hasNext();
            if (this._hasNext) {
                this._nextValue = this._base.next();
            }
        }
        return this._hasNext;
    }

    @Override
    public T next() {
        if (this._testedNext == null || !this._testedNext.booleanValue()) {
            this.hasNext();
        }
        if (!this._hasNext) {
            throw new NoSuchElementException();
        }
        this._testedNext = Boolean.FALSE;
        this._lastValue = this._nextValue;
        return this._nextValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

