/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Element;
import nu.xom.IllegalNameException;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Verifier;

public class Attribute
extends Node {
    private String localName;
    private String prefix;
    private String URI;
    private String value = "";
    private Type type;

    public Attribute(String string, String string2) {
        this(string, "", string2, Type.UNDECLARED);
    }

    public Attribute(String string, String string2, Type type) {
        this(string, "", string2, type);
    }

    public Attribute(String string, String string2, String string3) {
        this(string, string2, string3, Type.UNDECLARED);
    }

    public Attribute(String string, String string2, String string3, Type type) {
        this.prefix = "";
        String string4 = string;
        if (string.indexOf(58) > 0) {
            this.prefix = string.substring(0, string.indexOf(58));
            string4 = string.substring(string.indexOf(58) + 1);
        }
        try {
            this._setLocalName(string4);
        }
        catch (IllegalNameException illegalNameException) {
            illegalNameException.setData(string);
            throw illegalNameException;
        }
        this._setNamespace(this.prefix, string2);
        this._setValue(string3);
        this._setType(type);
    }

    public Attribute(Attribute attribute2) {
        this.localName = attribute2.localName;
        this.prefix = attribute2.prefix;
        this.URI = attribute2.URI;
        this.value = attribute2.value;
        this.type = attribute2.type;
    }

    private Attribute() {
    }

    static Attribute build(String string, String string2, String string3, Type type) {
        Attribute attribute2 = new Attribute();
        String string4 = "";
        String string5 = string;
        if (string.indexOf(58) >= 0) {
            string4 = string.substring(0, string.indexOf(58));
            string5 = string.substring(string.indexOf(58) + 1);
        }
        attribute2.localName = string5;
        attribute2.prefix = string4;
        attribute2.type = type;
        attribute2.URI = string2;
        attribute2.value = string3;
        return attribute2;
    }

    public final Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this._setType(type);
    }

    private void _setType(Type type) {
        this.type = type;
    }

    public final String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this._setValue(string);
    }

    private void _setValue(String string) {
        Verifier.checkPCDATA(string);
        this.value = string;
    }

    public final String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String string) {
        this._setLocalName(string);
    }

    private void _setLocalName(String string) {
        Verifier.checkNCName(string);
        if (string.equals("xmlns")) {
            throw new IllegalNameException("The Attribute class is not used for namespace declaration attributes.");
        }
        this.localName = string;
    }

    public final String getQualifiedName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public final String getNamespaceURI() {
        return this.URI;
    }

    public final String getNamespacePrefix() {
        return this.prefix;
    }

    public void setNamespace(String string, String string2) {
        this._setNamespace(string, string2);
    }

    private void _setNamespace(String string, String string2) {
        Element element;
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            string = "";
        }
        if (string.equals("xmlns")) {
            throw new IllegalNameException("Attribute objects are not used to represent  namespace declarations");
        }
        if (string.equals("xml") && !string2.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new NamespaceConflictException("Wrong namespace URI for xml prefix: " + string2);
        }
        if (string2.equals("http://www.w3.org/XML/1998/namespace") && !string.equals("xml")) {
            throw new NamespaceConflictException("Wrong prefix for the XML namespace: " + string);
        }
        if (string.length() == 0) {
            if (string2.length() == 0) {
                this.prefix = "";
                this.URI = "";
                return;
            }
            throw new NamespaceConflictException("Unprefixed attribute " + this.localName + " cannot be in default namespace " + string2);
        }
        if (string2.length() == 0) {
            throw new NamespaceConflictException("Attribute prefixes must be declared.");
        }
        ParentNode parentNode = this.getParent();
        if (parentNode != null && (string3 = (element = (Element)parentNode).getLocalNamespaceURI(string)) != null && !string3.equals(string2)) {
            throw new NamespaceConflictException("New prefix " + string + "conflicts with existing namespace declaration");
        }
        Verifier.checkAbsoluteURIReference(string2);
        Verifier.checkNCName(string);
        this.URI = string2;
        this.prefix = string;
    }

    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("Attributes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public Node copy() {
        return new Attribute(this);
    }

    public final String toXML() {
        return this.getQualifiedName() + "=\"" + Attribute.escapeText(this.value) + "\"";
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.getQualifiedName() + "=\"" + this.getValue() + "\"]";
    }

    private static String escapeText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            Attribute.escapeChar(stringBuffer, string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static void escapeChar(StringBuffer stringBuffer, char c) {
        switch (c) {
            case '<': {
                stringBuffer.append("&lt;");
                break;
            }
            case '>': {
                stringBuffer.append("&gt;");
                break;
            }
            case '&': {
                stringBuffer.append("&amp;");
                break;
            }
            case '\"': {
                stringBuffer.append("&quot;");
                break;
            }
            case '\'': {
                stringBuffer.append("&apos;");
                break;
            }
            case '\n': {
                stringBuffer.append("&#x0A;");
                break;
            }
            case '\r': {
                stringBuffer.append("&#x0D;");
                break;
            }
            case '\t': {
                stringBuffer.append("&#x09;");
                break;
            }
            default: {
                stringBuffer.append(c);
            }
        }
    }

    boolean isAttribute() {
        return true;
    }

    public static final class Type {
        public static final Type CDATA = new Type(1);
        public static final Type ID = new Type(2);
        public static final Type IDREF = new Type(3);
        public static final Type IDREFS = new Type(4);
        public static final Type NMTOKEN = new Type(5);
        public static final Type NMTOKENS = new Type(6);
        public static final Type NOTATION = new Type(7);
        public static final Type ENTITY = new Type(8);
        public static final Type ENTITIES = new Type(9);
        public static final Type ENUMERATION = new Type(10);
        public static final Type UNDECLARED = new Type(0);
        private int type;

        public String getName() {
            switch (this.type) {
                case 0: {
                    return "UNDECLARED";
                }
                case 1: {
                    return "CDATA";
                }
                case 2: {
                    return "ID";
                }
                case 3: {
                    return "IDREF";
                }
                case 4: {
                    return "IDREFS";
                }
                case 5: {
                    return "NMTOKEN";
                }
                case 6: {
                    return "NMTOKENS";
                }
                case 7: {
                    return "NOTATION";
                }
                case 8: {
                    return "ENTITY";
                }
                case 9: {
                    return "ENTITIES";
                }
                case 10: {
                    return "ENUMERATION";
                }
            }
            throw new RuntimeException("Bug in XOM: unexpected attribute type: " + this.type);
        }

        private Type(int n) {
            this.type = n;
        }

        public int hashCode() {
            return this.type;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.hashCode() != object.hashCode()) {
                return false;
            }
            return object.getClass().getName().equals("nu.xom.Attribute.Type");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[Attribute.Type: ");
            stringBuffer.append(this.getName());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

