/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.ArrayList;
import java.util.Iterator;
import nu.xom.Attribute;
import nu.xom.NamespaceConflictException;
import nu.xom.NoSuchAttributeException;

final class Attributes {
    private ArrayList attributes = new ArrayList(1);

    Attributes() {
    }

    int size() {
        return this.attributes.size();
    }

    Attribute get(int n) {
        return (Attribute)this.attributes.get(n);
    }

    void add(Attribute attribute2) {
        this.checkPrefixConflict(attribute2);
        Attribute attribute3 = this.get(attribute2.getLocalName(), attribute2.getNamespaceURI());
        if (attribute3 != null) {
            this.remove(attribute3);
        }
        this.attributes.add(attribute2);
    }

    void checkPrefixConflict(Attribute attribute2) {
        String string = attribute2.getNamespacePrefix();
        String string2 = attribute2.getNamespaceURI();
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute3 = (Attribute)iterator.next();
            if (!attribute3.getNamespacePrefix().equals(string) || attribute3.getNamespaceURI().equals(string2)) continue;
            throw new NamespaceConflictException("Prefix of " + attribute2.getQualifiedName() + " conflicts with " + attribute3.getQualifiedName());
        }
    }

    void remove(Attribute attribute2) {
        if (attribute2 == null) {
            throw new NullPointerException("Tried to remove null attribute");
        }
        boolean bl = this.attributes.remove(attribute2);
        if (!bl) {
            throw new NoSuchAttributeException("Tried to remove attribute " + attribute2.getQualifiedName() + " from non-parent element");
        }
    }

    Attribute get(String string, String string2) {
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute2 = (Attribute)iterator.next();
            if (!attribute2.getLocalName().equals(string) || !attribute2.getNamespaceURI().equals(string2)) continue;
            return attribute2;
        }
        return null;
    }

    Attributes copy() {
        Attributes attributes = new Attributes();
        attributes.attributes.ensureCapacity(this.size());
        for (int i = 0; i < this.attributes.size(); ++i) {
            attributes.attributes.add(this.get(i).copy());
        }
        return attributes;
    }
}

