/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import nu.xom.Attribute;
import nu.xom.Attributes;
import nu.xom.CycleException;
import nu.xom.Elements;
import nu.xom.IllegalAddException;
import nu.xom.IllegalNameException;
import nu.xom.MalformedURIException;
import nu.xom.MultipleParentException;
import nu.xom.NamespaceConflictException;
import nu.xom.Namespaces;
import nu.xom.NoSuchAttributeException;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import nu.xom.URIUtil;
import nu.xom.Verifier;

public class Element
extends ParentNode {
    private String localName;
    private String prefix;
    private String URI;
    private Attributes attributes = null;
    private Namespaces namespaces = null;

    public Element(String string) {
        this(string, "");
    }

    public Element(String string, String string2) {
        String string3 = "";
        String string4 = string;
        int n = string.indexOf(58);
        if (n > 0) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        this._setNamespacePrefix(string3);
        this._setNamespaceURI(string2);
        try {
            this._setLocalName(string4);
        }
        catch (IllegalNameException illegalNameException) {
            illegalNameException.setData(string);
            throw illegalNameException;
        }
    }

    private Element() {
    }

    static Element build(String string, String string2) {
        Element element = new Element();
        String string3 = "";
        String string4 = string;
        int n = string.indexOf(58);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        element.prefix = string3;
        element.localName = string4;
        element.setNamespaceURI(string2);
        return element;
    }

    public Element(Element element) {
        this.prefix = element.prefix;
        this.localName = element.localName;
        this.URI = element.URI;
        if (element.namespaces != null) {
            this.namespaces = element.namespaces.copy();
        }
        if (element.attributes != null) {
            this.attributes = element.attributes.copy();
        }
        this.actualBaseURI = element.findActualBaseURI();
        Element.nonrecursiveCopy(element, this);
    }

    private static Element copyTag(Element element) {
        Element element2 = element.shallowCopy();
        if (element.namespaces != null) {
            element2.namespaces = element.namespaces.copy();
        }
        if (element.attributes != null) {
            element2.attributes = element.attributes.copy();
        }
        element2.actualBaseURI = element.findActualBaseURI();
        return element2;
    }

    private static Element nonrecursiveCopy(Element element, Element element2) {
        ParentNode parentNode = element.getParent();
        Node node = element2;
        Node node2 = element;
        int n = 0;
        boolean bl = false;
        while (true) {
            Node node3;
            if (!bl && node2.getChildCount() > 0) {
                node2 = node2.getChild(0);
                n = 0;
            } else {
                bl = false;
                node3 = node2.getParent();
                if (node3 == parentNode) break;
                if (((ParentNode)node3).getChildCount() - 1 == n) {
                    node2 = node3;
                    if (node2 == element) break;
                    node = (Element)node.getParent();
                    n = node2.getParent().indexOf(node2);
                    bl = true;
                    continue;
                }
                node2 = ((ParentNode)node3).getChild(++n);
            }
            if (node2.isElement()) {
                node3 = Element.copyTag((Element)node2);
                node.appendChild(node3);
                if (node2.getChildCount() <= 0) continue;
                node = node3;
                continue;
            }
            node3 = node2.copy();
            node.appendChild(node3);
        }
        return element2;
    }

    public final Elements getChildElements(String string) {
        return this.getChildElements(string, "");
    }

    public final Elements getChildElements(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            string = "";
        }
        Elements elements = new Elements();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Element element;
            Node node = this.getChild(i);
            if (!node.isElement() || !string.equals((element = (Element)node).getLocalName()) && string.length() != 0 || !string2.equals(element.getNamespaceURI())) continue;
            elements.add(element);
        }
        return elements;
    }

    public final Elements getChildElements() {
        Elements elements = new Elements();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node node = this.getChild(i);
            if (!node.isElement()) continue;
            Element element = (Element)node;
            elements.add(element);
        }
        return elements;
    }

    public final Element getFirstChildElement(String string) {
        return this.getFirstChildElement(string, "");
    }

    public final Element getFirstChildElement(String string, String string2) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Element element;
            Node node = this.getChild(i);
            if (!node.isElement() || !string.equals((element = (Element)node).getLocalName()) || !string2.equals(element.getNamespaceURI())) continue;
            return element;
        }
        return null;
    }

    public void addAttribute(Attribute attribute2) {
        if (attribute2.getParent() != null) {
            throw new MultipleParentException("Attribute already has a parent");
        }
        String string = attribute2.getNamespacePrefix();
        if (string.length() != 0 && !"xml".equals(string)) {
            String string2;
            if (this.prefix.equals(attribute2.getNamespacePrefix()) && !this.getNamespaceURI().equals(attribute2.getNamespaceURI())) {
                throw new NamespaceConflictException("Prefix of " + attribute2.getQualifiedName() + " conflicts with element prefix " + this.prefix);
            }
            if (this.namespaces != null && (string2 = this.namespaces.getURI(attribute2.getNamespacePrefix())) != null && !string2.equals(attribute2.getNamespaceURI())) {
                throw new NamespaceConflictException("Attribute prefix  " + string + " conflicts with namespace declaration.");
            }
        }
        this.fastAddAttribute(attribute2);
    }

    void fastAddAttribute(Attribute attribute2) {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.add(attribute2);
        attribute2.setParent(this);
    }

    public Attribute removeAttribute(Attribute attribute2) {
        if (this.attributes == null) {
            throw new NoSuchAttributeException("Tried to remove attribute " + attribute2.getQualifiedName() + " from non-parent element");
        }
        this.attributes.remove(attribute2);
        attribute2.setParent(null);
        return attribute2;
    }

    public final Attribute getAttribute(String string) {
        return this.getAttribute(string, "");
    }

    public final Attribute getAttribute(String string, String string2) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string, string2);
    }

    public final String getAttributeValue(String string) {
        return this.getAttributeValue(string, "");
    }

    public final int getAttributeCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public final Attribute getAttribute(int n) {
        if (this.attributes == null) {
            throw new IndexOutOfBoundsException("Element does not have any attributes");
        }
        return this.attributes.get(n);
    }

    public final String getAttributeValue(String string, String string2) {
        if (this.attributes == null) {
            return null;
        }
        Attribute attribute2 = this.attributes.get(string, string2);
        if (attribute2 == null) {
            return null;
        }
        return attribute2.getValue();
    }

    public final String getLocalName() {
        return this.localName;
    }

    public final String getQualifiedName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public final String getNamespacePrefix() {
        return this.prefix;
    }

    public final String getNamespaceURI() {
        return this.URI;
    }

    public final String getNamespaceURI(String string) {
        ParentNode parentNode;
        Element element = this;
        String string2 = this.getLocalNamespaceURI(string);
        while (string2 == null && (parentNode = element.getParent()) != null && !parentNode.isDocument()) {
            element = (Element)parentNode;
            string2 = element.getLocalNamespaceURI(string);
        }
        if (string2 == null && "".equals(string)) {
            string2 = "";
        }
        return string2;
    }

    String getLocalNamespaceURI(String string) {
        String string2;
        if (string.equals(this.prefix)) {
            return this.URI;
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(string)) {
            return "";
        }
        if (this.namespaces != null && (string2 = this.namespaces.getURI(string)) != null) {
            return string2;
        }
        if (string.length() != 0 && this.attributes != null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                Attribute attribute2 = this.attributes.get(i);
                if (!attribute2.getNamespacePrefix().equals(string)) continue;
                return attribute2.getNamespaceURI();
            }
        }
        return null;
    }

    public void setLocalName(String string) {
        this._setLocalName(string);
    }

    private void _setLocalName(String string) {
        Verifier.checkNCName(string);
        this.localName = string;
    }

    public void setNamespaceURI(String string) {
        this._setNamespaceURI(string);
    }

    private void _setNamespaceURI(String string) {
        String string2;
        if (string == null) {
            string = "";
        }
        if (string.equals(this.URI)) {
            return;
        }
        if (string.length() == 0) {
            if (this.prefix.length() != 0) {
                throw new NamespaceConflictException("Prefixed elements must have namespace URIs.");
            }
        } else {
            Verifier.checkAbsoluteURIReference(string);
        }
        if (this.namespaces != null && (string2 = this.namespaces.getURI(this.prefix)) != null) {
            throw new NamespaceConflictException("new URI conflicts with existing prefix");
        }
        if (string.length() > 0 && this.attributes != null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                Attribute attribute2 = this.attributes.get(i);
                String string3 = attribute2.getNamespacePrefix();
                if (string3.length() == 0 || !attribute2.getNamespacePrefix().equals(this.prefix)) continue;
                throw new NamespaceConflictException("new element URI " + string + " conflicts with attribute " + attribute2.getQualifiedName());
            }
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string) && !"xml".equals(this.prefix)) {
            throw new NamespaceConflictException("Wrong prefix " + this.prefix + " for the http://www.w3.org/XML/1998/namespace namespace URI");
        }
        if ("xml".equals(this.prefix) && !"http://www.w3.org/XML/1998/namespace".equals(string)) {
            throw new NamespaceConflictException("Wrong namespace URI " + string + " for the xml prefix");
        }
        this.URI = string;
    }

    public void setNamespacePrefix(String string) {
        this._setNamespacePrefix(string);
    }

    private void _setNamespacePrefix(String string) {
        String string2;
        if (string == null) {
            string = "";
        }
        if (string.length() != 0) {
            Verifier.checkNCName(string);
        }
        if ((string2 = this.getLocalNamespaceURI(string)) != null) {
            if (!string2.equals(this.URI) && !"xml".equals(string)) {
                throw new NamespaceConflictException(string + " conflicts with existing prefix");
            }
        } else if ("".equals(this.URI) && !"".equals(string)) {
            throw new NamespaceConflictException("Cannot assign prefix to element in no namespace");
        }
        this.prefix = string;
    }

    void insertionAllowed(Node node, int n) {
        if (node == null) {
            throw new NullPointerException("Tried to insert a null child in the tree");
        }
        if (node.getParent() != null) {
            throw new MultipleParentException(node.toString() + " child already has a parent.");
        }
        if (node.isElement()) {
            if (node == this) {
                throw new CycleException("Cannot add a node to itself");
            }
            if (node.getChildCount() > 0 && Element.isCycle(node, this)) {
                throw new CycleException("Cannot add an ancestor as a child");
            }
            return;
        }
        if (node.isText() || node.isProcessingInstruction() || node.isComment()) {
            return;
        }
        throw new IllegalAddException("Cannot add a " + node.getClass().getName() + " to an Element.");
    }

    private static boolean isCycle(Node node, ParentNode parentNode) {
        while (parentNode != null) {
            if (parentNode == node) {
                return true;
            }
            parentNode = parentNode.getParent();
        }
        return false;
    }

    public void insertChild(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Inserted null string");
        }
        super.insertChild(new Text(string), n);
    }

    public void appendChild(String string) {
        this.insertChild(new Text(string), this.getChildCount());
    }

    public Nodes removeChildren() {
        int n = this.getChildCount();
        Nodes nodes = new Nodes();
        for (int i = 0; i < n; ++i) {
            Node node = this.getChild(i);
            if (node.isElement()) {
                this.fillInBaseURI((Element)node);
            }
            node.setParent(null);
            nodes.append(node);
        }
        this.children = null;
        return nodes;
    }

    public void addNamespaceDeclaration(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string.length() != 0) {
            Verifier.checkNCName(string);
            Verifier.checkAbsoluteURIReference(string2);
        } else if (string2.length() != 0) {
            Verifier.checkAbsoluteURIReference(string2);
        }
        if (string.equals("xmlns")) {
            throw new NamespaceConflictException("The xmlns prefix cannot bound to any URI");
        }
        if (string.equals("xml")) {
            if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
                return;
            }
            throw new NamespaceConflictException("Wrong namespace URI for xml prefix: " + string2);
        }
        if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new NamespaceConflictException("Wrong prefix for http://www.w3.org/XML/1998/namespace namespace: " + string);
        }
        String string3 = this.getLocalNamespaceURI(string);
        if (string3 != null && !string3.equals(string2)) {
            throw new NamespaceConflictException("Additional namespace " + string2 + " conflicts with existing namespace binding.");
        }
        if (this.namespaces == null) {
            this.namespaces = new Namespaces();
        }
        this.namespaces.put(string, string2);
    }

    public void removeNamespaceDeclaration(String string) {
        if (this.namespaces != null) {
            this.namespaces.remove(string);
        }
    }

    public final int getNamespaceDeclarationCount() {
        HashSet<String> hashSet = this.namespaces != null ? new HashSet(this.namespaces.getPrefixes()) : new HashSet<String>(3);
        if (!"xml".equals(this.prefix)) {
            hashSet.add(this.prefix);
        }
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            Attribute attribute2 = this.getAttribute(i);
            String string = attribute2.getNamespacePrefix();
            if (string.length() == 0 || "xml".equals(string)) continue;
            hashSet.add(string);
        }
        return hashSet.size();
    }

    public final String getNamespacePrefix(int n) {
        TreeSet<String> treeSet = this.namespaces != null ? new TreeSet(this.namespaces.getPrefixes()) : new TreeSet<String>();
        if (!"xml".equals(this.prefix)) {
            treeSet.add(this.prefix);
        }
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            Attribute attribute2 = this.getAttribute(i);
            String string = attribute2.getNamespacePrefix();
            if (string.length() == 0 || "xml".equals(string)) continue;
            treeSet.add(string);
        }
        Iterator iterator = treeSet.iterator();
        try {
            for (int i = 0; i < n; ++i) {
                iterator.next();
            }
            return (String)iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("No " + n + "th namespace");
        }
    }

    public void setBaseURI(String string) {
        this.setActualBaseURI(string);
    }

    public String getBaseURI() {
        String string;
        block7: {
            String string2;
            string = "";
            String string3 = this.getActualBaseURI();
            ParentNode parentNode = this;
            do {
                string2 = parentNode.getActualBaseURI();
                if (string3.length() != 0 && !string3.equals(string2)) {
                    string = URIUtil.absolutize(string3, string);
                    break block7;
                }
                if (parentNode.isDocument()) {
                    string = URIUtil.absolutize(string2, string);
                    break block7;
                }
                Attribute attribute2 = parentNode.getAttribute("base", "http://www.w3.org/XML/1998/namespace");
                if (attribute2 == null) continue;
                String string4 = attribute2.getValue();
                String string5 = URIUtil.toURI(string4);
                if ("".equals(string5)) {
                    string = this.getEntityURI();
                    break block7;
                }
                if (!this.legalURI(string5)) continue;
                if ("".equals(string)) {
                    string = string5;
                } else {
                    if (URIUtil.isOpaque(string5)) break block7;
                    string = URIUtil.absolutize(string5, string);
                }
                if (URIUtil.isAbsolute(string5)) break block7;
            } while ((parentNode = parentNode.getParent()) != null);
            string = URIUtil.absolutize(string2, string);
        }
        if (URIUtil.isAbsolute(string)) {
            return string;
        }
        return "";
    }

    private String getEntityURI() {
        for (ParentNode parentNode = this; parentNode != null; parentNode = parentNode.getParent()) {
            if (parentNode.actualBaseURI == null || parentNode.actualBaseURI.length() == 0) continue;
            return parentNode.actualBaseURI;
        }
        return "";
    }

    private boolean legalURI(String string) {
        try {
            Verifier.checkURIReference(string);
            return true;
        }
        catch (MalformedURIException malformedURIException) {
            return false;
        }
    }

    public final String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        Node node = this;
        boolean bl = false;
        int n = -1;
        while (true) {
            if (!bl && node.getChildCount() > 0) {
                Element.writeStartTag((Element)node, stringBuffer);
                node = node.getChild(0);
                n = 0;
                continue;
            }
            if (bl) {
                Element.writeEndTag((Element)node, stringBuffer);
                if (node == this) {
                    break;
                }
            } else if (node.isElement()) {
                Element.writeStartTag((Element)node, stringBuffer);
                if (node == this) {
                    break;
                }
            } else {
                stringBuffer.append(node.toXML());
            }
            bl = false;
            ParentNode parentNode = node.getParent();
            if (parentNode.getChildCount() - 1 == n) {
                node = parentNode;
                if (node != this) {
                    parentNode = node.getParent();
                    n = parentNode.indexOf(node);
                }
                bl = true;
                continue;
            }
            node = parentNode.getChild(++n);
        }
        return stringBuffer.toString();
    }

    private static void writeStartTag(Element element, StringBuffer stringBuffer) {
        Object object;
        int n;
        stringBuffer.append("<");
        stringBuffer.append(element.getQualifiedName());
        ParentNode parentNode = element.getParent();
        for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
            Element element2;
            object = element.getNamespacePrefix(n);
            String string = element.getNamespaceURI((String)object);
            if (parentNode != null && parentNode.isElement() ? string.equals((element2 = (Element)parentNode).getNamespaceURI((String)object)) : string.length() == 0) continue;
            stringBuffer.append(" xmlns");
            if (((String)object).length() > 0) {
                stringBuffer.append(':');
                stringBuffer.append((String)object);
            }
            stringBuffer.append("=\"");
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
        if (element.attributes != null) {
            for (n = 0; n < element.attributes.size(); ++n) {
                object = element.attributes.get(n);
                stringBuffer.append(' ');
                stringBuffer.append(((Attribute)object).toXML());
            }
        }
        if (element.getChildCount() > 0) {
            stringBuffer.append('>');
        } else {
            stringBuffer.append(" />");
        }
    }

    private static void writeEndTag(Element element, StringBuffer stringBuffer) {
        stringBuffer.append("</");
        stringBuffer.append(element.getQualifiedName());
        stringBuffer.append(">");
    }

    public final String getValue() {
        if (this.getChildCount() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Node node = this.getChild(0);
        int n = 0;
        boolean bl = false;
        while (true) {
            ParentNode parentNode;
            if (!bl && node.getChildCount() > 0) {
                node = node.getChild(0);
                n = 0;
                continue;
            }
            bl = false;
            if (node.isText()) {
                stringBuffer.append(node.getValue());
            }
            if ((parentNode = node.getParent()).getChildCount() - 1 == n) {
                node = parentNode;
                if (node == this) break;
                n = node.getParent().indexOf(node);
                bl = true;
                continue;
            }
            node = parentNode.getChild(++n);
        }
        return stringBuffer.toString();
    }

    public Node copy() {
        Element element = Element.copyTag(this);
        return Element.nonrecursiveCopy(this, element);
    }

    protected Element shallowCopy() {
        return new Element(this.getQualifiedName(), this.getNamespaceURI());
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.getQualifiedName() + "]";
    }

    boolean isElement() {
        return true;
    }
}

