/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.EBCDICWriter;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.TextWriter;
import nu.xom.TextWriterFactory;
import nu.xom.UnicodeWriter;
import nu.xom.XMLException;

public class Serializer {
    private TextWriter escaper;
    private boolean preserveBaseURI = false;

    public Serializer(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("Null OutputStream");
        }
        try {
            Writer writer = new OutputStreamWriter(outputStream, "UTF8");
            writer = new BufferedWriter(writer);
            this.escaper = TextWriterFactory.getTextWriter(writer, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("The VM is broken. It does not understand UTF-8.");
        }
    }

    public Serializer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (outputStream == null) {
            throw new NullPointerException("Null OutputStream");
        }
        if (string == null) {
            throw new NullPointerException("Null encoding");
        }
        this.setOutputStream(outputStream, string);
    }

    public void setOutputStream(OutputStream outputStream) throws IOException {
        this.flush();
        int n = this.getMaxLength();
        int n2 = this.getIndent();
        String string = this.getLineSeparator();
        boolean bl = this.getUnicodeNormalizationFormC();
        String string2 = this.escaper.getEncoding();
        this.setOutputStream(outputStream, string2);
        this.setIndent(n2);
        this.setMaxLength(n);
        this.setUnicodeNormalizationFormC(bl);
        this.setLineSeparator(string);
    }

    private void setOutputStream(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        String string2 = string.toUpperCase();
        Writer writer = string2.equals("IBM037") || string2.equals("CP037") || string2.equals("EBCDIC-CP-US") || string2.equals("EBCDIC-CP-CA") || string2.equals("EBCDIC-CP-WA") || string2.equals("EBCDIC-CP-NL") || string2.equals("CSIBM037") ? new EBCDICWriter(outputStream) : (string2.equals("UTF-16") || string2.equals("ISO-10646-UCS-2") ? new OutputStreamWriter(outputStream, "UnicodeBig") : (string2.equals("ISO-8859-11") || string2.equals("TIS-620") ? new OutputStreamWriter(outputStream, "TIS620") : new OutputStreamWriter(outputStream, string)));
        writer = new BufferedWriter(writer);
        this.escaper = TextWriterFactory.getTextWriter(writer, string);
    }

    public void write(Document document) throws IOException {
        this.escaper.reset();
        this.writeXMLDeclaration();
        for (int i = 0; i < document.getChildCount(); ++i) {
            this.writeChild(document.getChild(i));
            this.escaper.breakLine();
        }
        this.escaper.flush();
    }

    protected void writeXMLDeclaration() throws IOException {
        this.escaper.writeMarkup("<?xml version=\"1.0\" encoding=\"");
        this.escaper.writeMarkup(this.escaper.getEncoding());
        this.escaper.writeMarkup("\"?>");
        this.escaper.breakLine();
    }

    protected void write(Element element) throws IOException {
        Object object;
        int n;
        if (this.escaper.isIndenting() && !this.escaper.isPreserveSpace() && !this.escaper.justBroke()) {
            this.escaper.breakLine();
        }
        boolean bl = false;
        for (n = 0; n < element.getChildCount(); n += 1) {
            object = element.getChild(n);
            if (((Node)object).isText() && "".equals(((Node)object).getValue())) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.writeStartTag(element);
            n = this.escaper.isPreserveSpace() ? 1 : 0;
            object = element.getAttributeValue("space", "http://www.w3.org/XML/1998/namespace");
            if (object != null) {
                if ("preserve".equals(object)) {
                    this.escaper.setPreserveSpace(true);
                } else if ("default".equals(object)) {
                    this.escaper.setPreserveSpace(false);
                }
            }
            this.escaper.incrementIndent();
            for (int i = 0; i < element.getChildCount(); ++i) {
                this.writeChild(element.getChild(i));
            }
            this.escaper.decrementIndent();
            if (this.escaper.getIndent() > 0 && !this.escaper.isPreserveSpace() && this.hasNonTextChildren(element)) {
                this.escaper.breakLine();
            }
            this.writeEndTag(element);
            if (object != null) {
                this.escaper.setPreserveSpace(n != 0);
            }
        } else {
            this.writeEmptyElementTag(element);
        }
        this.escaper.flush();
    }

    private boolean hasNonTextChildren(Element element) {
        for (int i = 0; i < element.getChildCount(); ++i) {
            if (element.getChild(i).isText()) continue;
            return true;
        }
        return false;
    }

    protected void writeEndTag(Element element) throws IOException {
        this.escaper.writeMarkup("</");
        this.escaper.writeMarkup(element.getQualifiedName());
        this.escaper.writeMarkup(">");
    }

    protected void writeStartTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.writeMarkup('>');
    }

    protected void writeEmptyElementTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.writeMarkup("/>");
    }

    private void writeTagBeginning(Element element) throws IOException {
        this.escaper.writeMarkup('<');
        this.escaper.writeMarkup(element.getQualifiedName());
        this.writeAttributes(element);
        this.writeNamespaceDeclarations(element);
    }

    protected void writeAttributes(Element element) throws IOException {
        Object object;
        if (this.preserveBaseURI) {
            ParentNode parentNode = element.getParent();
            if (element.getAttribute("base", "http://www.w3.org/XML/1998/namespace") == null) {
                object = element.getBaseURI();
                if (parentNode == null || parentNode.isDocument() || !element.getBaseURI().equals(parentNode.getBaseURI())) {
                    this.escaper.writeMarkup(' ');
                    Attribute attribute2 = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", (String)object);
                    this.write(attribute2);
                }
            }
        }
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            object = element.getAttribute(i);
            this.escaper.writeMarkup(' ');
            this.write((Attribute)object);
        }
    }

    protected void writeNamespaceDeclarations(Element element) throws IOException {
        ParentNode parentNode = element.getParent();
        for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            Element element2;
            String string = element.getNamespacePrefix(i);
            String string2 = element.getNamespaceURI(string);
            if (parentNode.isElement() ? string2.equals((element2 = (Element)parentNode).getNamespaceURI(string)) : string2.equals("")) continue;
            this.escaper.writeMarkup(' ');
            this.writeNamespaceDeclaration(string, string2);
        }
    }

    protected void writeNamespaceDeclaration(String string, String string2) throws IOException {
        if ("".equals(string)) {
            this.escaper.writeMarkup("xmlns");
        } else {
            this.escaper.writeMarkup("xmlns:");
            this.escaper.writeMarkup(string);
        }
        this.escaper.writeMarkup("=\"");
        this.escaper.writePCDATA(string2);
        this.escaper.writeMarkup('\"');
    }

    protected void write(Attribute attribute2) throws IOException {
        this.escaper.writeMarkup(attribute2.getQualifiedName());
        this.escaper.writeMarkup("=\"");
        this.escaper.writeAttributeValue(attribute2.getValue());
        this.escaper.writeMarkup("\"");
    }

    protected void write(Comment comment) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeMarkup("<!--");
        this.escaper.writeMarkup(comment.getValue());
        this.escaper.writeMarkup("-->");
    }

    protected void write(ProcessingInstruction processingInstruction) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeMarkup("<?");
        this.escaper.writeMarkup(processingInstruction.getTarget());
        String string = processingInstruction.getValue();
        if (!"".equals(string)) {
            this.escaper.writeMarkup(' ');
            this.escaper.writeMarkup(string);
        }
        this.escaper.writeMarkup("?>");
    }

    protected void write(Text text) throws IOException {
        String string = text.getValue();
        if (text.isCDATASection() && text.getValue().indexOf("]]>") == -1) {
            if (!(this.escaper instanceof UnicodeWriter)) {
                for (int i = 0; i < string.length(); ++i) {
                    if (!this.escaper.needsEscaping(string.charAt(i))) continue;
                    this.escaper.writePCDATA(string);
                    return;
                }
            }
            this.escaper.writeMarkup("<![CDATA[");
            this.escaper.writeMarkup(string);
            this.escaper.writeMarkup("]]>");
        } else {
            if (this.isBoundaryWhitespace(text)) {
                return;
            }
            this.escaper.writePCDATA(string);
        }
    }

    private boolean isBoundaryWhitespace(Text text) {
        if (this.getIndent() <= 0) {
            return false;
        }
        if (!"".equals(text.getValue().trim())) {
            return false;
        }
        ParentNode parentNode = text.getParent();
        int n = parentNode.indexOf(text);
        if (n == 0) {
            return false;
        }
        Node node = null;
        Node node2 = null;
        node = parentNode.getChild(n - 1);
        if (n != parentNode.getChildCount() - 1) {
            node2 = parentNode.getChild(n + 1);
        }
        return !(node != null && node.isText() || node2 != null && node2.isText());
    }

    protected void write(DocType docType) throws IOException {
        this.escaper.writeMarkup("<!DOCTYPE ");
        this.escaper.writeMarkup(docType.getRootElementName());
        if (docType.getPublicID() != null) {
            this.escaper.writeMarkup(" PUBLIC \"" + docType.getPublicID() + "\" \"" + docType.getSystemID() + "\"");
        } else if (docType.getSystemID() != null) {
            this.escaper.writeMarkup(" SYSTEM \"" + docType.getSystemID() + "\"");
        }
        String string = docType.getInternalDTDSubset();
        if (!string.equals("")) {
            this.escaper.writeMarkup(" [");
            this.escaper.breakLine();
            this.escaper.writeMarkup(string);
            this.escaper.breakLine();
            this.escaper.writeMarkup("]");
        }
        this.escaper.writeMarkup(">");
    }

    protected void writeChild(Node node) throws IOException {
        if (node.isElement()) {
            this.write((Element)node);
        } else if (node.isText()) {
            this.write((Text)node);
        } else if (node.isComment()) {
            this.write((Comment)node);
        } else if (node.isProcessingInstruction()) {
            this.write((ProcessingInstruction)node);
        } else if (node.isDocType()) {
            this.write((DocType)node);
        } else {
            throw new XMLException("Cannot write a " + node.getClass().getName() + " from the writeChildNode() method");
        }
    }

    protected final void writeEscaped(String string) throws IOException {
        this.escaper.writePCDATA(string);
    }

    protected final void writeAttributeValue(String string) throws IOException {
        this.escaper.writeAttributeValue(string);
    }

    protected final void writeRaw(String string) throws IOException {
        this.escaper.writeMarkup(string);
    }

    protected final void breakLine() throws IOException {
        this.escaper.breakLine();
    }

    public void flush() throws IOException {
        this.escaper.flush();
    }

    public int getIndent() {
        return this.escaper.getIndent();
    }

    public void setIndent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Indent cannot be negative");
        }
        this.escaper.setIndent(n);
    }

    public String getLineSeparator() {
        return this.escaper.getLineSeparator();
    }

    public void setLineSeparator(String string) {
        this.escaper.setLineSeparator(string);
    }

    public int getMaxLength() {
        return this.escaper.getMaxLength();
    }

    public void setMaxLength(int n) {
        this.escaper.setMaxLength(n);
    }

    public boolean getPreserveBaseURI() {
        return this.preserveBaseURI;
    }

    public void setPreserveBaseURI(boolean bl) {
        this.preserveBaseURI = bl;
    }

    public String getEncoding() {
        return this.escaper.getEncoding();
    }

    public void setUnicodeNormalizationFormC(boolean bl) {
        this.escaper.setNFC(bl);
    }

    public boolean getUnicodeNormalizationFormC() {
        return this.escaper.getNFC();
    }

    protected final int getColumnNumber() {
        return this.escaper.getColumnNumber();
    }
}

