/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalNameException;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XMLException;
import nu.xom.xinclude.XPointerResourceException;
import nu.xom.xinclude.XPointerSyntaxException;

class XPointer {
    private XPointer() {
    }

    public static Nodes query(Document document, String string) throws XPointerSyntaxException, XPointerResourceException {
        Nodes nodes = new Nodes();
        boolean bl = false;
        string = XPointer.decode(string);
        try {
            new Element(string, "http://www.example.com");
            Element element = XPointer.findByID(document.getRootElement(), string);
            if (element != null) {
                nodes.append(element);
                return nodes;
            }
        }
        catch (IllegalNameException illegalNameException) {
            List list = XPointer.findElementSchemeData(string);
            if (list.size() == 0) {
                throw new XPointerSyntaxException("No supported XPointer schemes found");
            }
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                int[] nArray = new int[]{};
                ParentNode parentNode = document;
                if (string2.indexOf(47) == -1) {
                    try {
                        new Element(string2);
                    }
                    catch (IllegalNameException illegalNameException2) {
                        throw new XPointerSyntaxException("bad element scheme data " + list, illegalNameException2);
                    }
                    Element element = XPointer.findByID(document.getRootElement(), string2);
                    if (element != null) {
                        if (!bl) {
                            nodes.append(element);
                        }
                        bl = true;
                    }
                } else if (!string2.startsWith("/")) {
                    String string3 = string2.substring(0, string2.indexOf(47));
                    try {
                        new Element(string3);
                    }
                    catch (XMLException xMLException) {
                        throw new XPointerSyntaxException(string3 + " is not a non-colonized name", xMLException);
                    }
                    parentNode = XPointer.findByID(document.getRootElement(), string3);
                    nArray = XPointer.split(string2.substring(string2.indexOf(47)));
                    if (parentNode == null) {
                        continue;
                    }
                } else {
                    nArray = XPointer.split(string2);
                }
                for (int j = 0; j < nArray.length && (parentNode = XPointer.findNthChildElement(parentNode, nArray[j])) != null; ++j) {
                }
                if (parentNode == document || parentNode == null) continue;
                if (!bl) {
                    nodes.append(parentNode);
                }
                bl = true;
            }
        }
        if (bl) {
            return nodes;
        }
        throw new XPointerResourceException("XPointer " + string + " did not locate any nodes in the document " + document.getBaseURI());
    }

    private static Element findNthChildElement(ParentNode parentNode, int n) {
        int n2 = 1;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            Node node = parentNode.getChild(i);
            if (!(node instanceof Element)) continue;
            if (n2 == n) {
                return (Element)node;
            }
            ++n2;
        }
        return null;
    }

    private static int[] split(String string) throws XPointerSyntaxException {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '/') continue;
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(3);
        try {
            for (int i = 1; i < string.length(); ++i) {
                if (string.charAt(i) == '/') {
                    nArray[n2] = Integer.parseInt(stringBuffer.toString());
                    ++n2;
                    stringBuffer = new StringBuffer(3);
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
            nArray[nArray.length - 1] = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            XPointerSyntaxException xPointerSyntaxException = new XPointerSyntaxException(string + " is not syntactically correct", numberFormatException);
            throw xPointerSyntaxException;
        }
        return nArray;
    }

    private static List findElementSchemeData(String string) throws XPointerSyntaxException {
        int n;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n2 = 0; n2 < stringBuffer.length() && (n = stringBuffer.charAt(n2)) != 40; ++n2) {
            stringBuffer2.append((char)n);
        }
        try {
            new Element(stringBuffer2.toString(), "http://www.example.com/");
        }
        catch (IllegalNameException illegalNameException) {
            throw new XPointerSyntaxException(illegalNameException.getMessage());
        }
        n = 1;
        ++n2;
        StringBuffer stringBuffer3 = new StringBuffer();
        try {
            while (n > 0) {
                char c = stringBuffer.charAt(n2);
                if (c == '^') {
                    c = stringBuffer.charAt(n2 + 1);
                    stringBuffer3.append(c);
                    if (c != '^' && c != '(' && c != ')') {
                        throw new XPointerSyntaxException("Illegal XPointer escape sequence");
                    }
                    ++n2;
                } else if (c == '(') {
                    stringBuffer3.append(c);
                    ++n;
                } else if (c == ')') {
                    if (--n > 0) {
                        stringBuffer3.append(c);
                    }
                } else {
                    stringBuffer3.append(c);
                }
                ++n2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new XPointerSyntaxException("Unbalanced parentheses");
        }
        if (stringBuffer2.toString().equals("element")) {
            arrayList.add(stringBuffer3.toString());
        }
        if (n2 + 1 < stringBuffer.length()) {
            arrayList.addAll(XPointer.findElementSchemeData(stringBuffer.substring(n2)));
        }
        return arrayList;
    }

    public static Element findByID(Element element, String string) {
        Node node = element;
        boolean bl = false;
        int n = -1;
        while (true) {
            ParentNode parentNode;
            if (node instanceof Element) {
                parentNode = node;
                for (int i = 0; i < ((Element)parentNode).getAttributeCount(); ++i) {
                    Attribute attribute2 = ((Element)parentNode).getAttribute(i);
                    if (attribute2.getType() != Attribute.Type.ID || !attribute2.getValue().trim().equals(string)) continue;
                    return parentNode;
                }
            }
            if (!bl && node.getChildCount() > 0) {
                node = node.getChild(0);
                n = 0;
                continue;
            }
            if (bl && node == element) break;
            bl = false;
            parentNode = node.getParent();
            if (parentNode.getChildCount() - 1 == n) {
                node = parentNode;
                if (node != element) {
                    parentNode = node.getParent();
                    n = parentNode.indexOf(node);
                }
                bl = true;
                continue;
            }
            node = parentNode.getChild(++n);
        }
        return null;
    }

    private static String decode(String string) throws XPointerSyntaxException {
        StringBuffer stringBuffer = new StringBuffer(string);
        try {
            for (int i = 0; i < stringBuffer.length(); ++i) {
                Object object;
                char c = stringBuffer.charAt(i);
                if (c != '%') continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while (c == '%') {
                    stringBuffer.deleteCharAt(i);
                    object = stringBuffer.substring(i, i + 2);
                    byte by = (byte)Integer.parseInt((String)object, 16);
                    byteArrayOutputStream.write(by);
                    stringBuffer.deleteCharAt(i);
                    stringBuffer.deleteCharAt(i);
                    c = stringBuffer.charAt(i);
                }
                object = byteArrayOutputStream.toByteArray();
                try {
                    String string2 = new String((byte[])object, "UTF-8");
                    stringBuffer.insert(i, string2);
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException("Broken VM does not support UTF-8");
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            XPointerSyntaxException xPointerSyntaxException = new XPointerSyntaxException(string + " is not a syntactically correct XPointer");
            xPointerSyntaxException.initCause(stringIndexOutOfBoundsException);
            throw xPointerSyntaxException;
        }
        catch (NumberFormatException numberFormatException) {
            XPointerSyntaxException xPointerSyntaxException = new XPointerSyntaxException(string + " is not a syntactically correct XPointer");
            xPointerSyntaxException.initCause(numberFormatException);
            throw xPointerSyntaxException;
        }
        return stringBuffer.toString();
    }
}

