/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GenericBridge;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.util.HaltingThread;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GVTBuilder
implements SVGConstants {
    public GraphicsNode build(BridgeContext ctx, Document document) {
        ctx.setDocument(document);
        ctx.initializeDocument(document);
        ctx.setGVTBuilder(this);
        RootGraphicsNode rootNode = new RootGraphicsNode();
        Element svgElement = document.getDocumentElement();
        GraphicsNode topNode = null;
        try {
            Bridge bridge = ctx.getBridge(svgElement);
            if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
                return null;
            }
            GraphicsNodeBridge gnBridge = (GraphicsNodeBridge)bridge;
            topNode = gnBridge.createGraphicsNode(ctx, svgElement);
            if (topNode == null) {
                return null;
            }
            rootNode.getChildren().add(topNode);
            this.buildComposite(ctx, svgElement, (CompositeGraphicsNode)topNode);
            gnBridge.buildGraphicsNode(ctx, svgElement, topNode);
        }
        catch (BridgeException ex) {
            ex.setGraphicsNode(rootNode);
            Element errElement = ex.getElement();
            ex.setLineNumber(ctx.getDocumentLoader().getLineNumber(errElement));
            ex.printStackTrace();
            throw ex;
        }
        if (ctx.isInteractive()) {
            ctx.addUIEventListeners(document);
            ctx.addGVTListener(document);
        }
        if (ctx.isDynamic()) {
            ctx.addDOMListeners();
        }
        return rootNode;
    }

    public GraphicsNode build(BridgeContext ctx, Element e) {
        Bridge bridge = ctx.getBridge(e);
        if (bridge instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(ctx, e);
            return null;
        }
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            return null;
        }
        GraphicsNodeBridge gnBridge = (GraphicsNodeBridge)bridge;
        if (!gnBridge.getDisplay(e)) {
            return null;
        }
        GraphicsNode gn = gnBridge.createGraphicsNode(ctx, e);
        if (gn != null) {
            if (gnBridge.isComposite()) {
                this.buildComposite(ctx, e, (CompositeGraphicsNode)gn);
            } else {
                this.handleGenericBridges(ctx, e);
            }
            gnBridge.buildGraphicsNode(ctx, e, gn);
        }
        if (ctx.isDynamic()) {
            // empty if block
        }
        return gn;
    }

    protected void buildComposite(BridgeContext ctx, Element e, CompositeGraphicsNode parentNode) {
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            this.buildGraphicsNode(ctx, (Element)n, parentNode);
        }
    }

    protected void buildGraphicsNode(BridgeContext ctx, Element e, CompositeGraphicsNode parentNode) {
        if (HaltingThread.hasBeenHalted()) {
            throw new InterruptedBridgeException();
        }
        Bridge bridge = ctx.getBridge(e);
        if (bridge instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(ctx, e);
            return;
        }
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            return;
        }
        if (!CSSUtilities.convertDisplay(e)) {
            return;
        }
        GraphicsNodeBridge gnBridge = (GraphicsNodeBridge)bridge;
        try {
            GraphicsNode gn = gnBridge.createGraphicsNode(ctx, e);
            if (gn != null) {
                parentNode.getChildren().add(gn);
                if (gnBridge.isComposite()) {
                    this.buildComposite(ctx, e, (CompositeGraphicsNode)gn);
                } else {
                    this.handleGenericBridges(ctx, e);
                }
                gnBridge.buildGraphicsNode(ctx, e, gn);
            }
        }
        catch (BridgeException ex) {
            GraphicsNode errNode = ex.getGraphicsNode();
            if (errNode != null) {
                parentNode.getChildren().add(errNode);
                gnBridge.buildGraphicsNode(ctx, e, errNode);
                ex.setGraphicsNode(null);
            }
            throw ex;
        }
    }

    protected void handleGenericBridges(BridgeContext ctx, Element e) {
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e2;
            Bridge b;
            if (!(n instanceof Element) || !((b = ctx.getBridge(e2 = (Element)n)) instanceof GenericBridge)) continue;
            ((GenericBridge)b).handleElement(ctx, e2);
        }
    }
}

