/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.CursorManager;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGAElement;

public class SVGAElementBridge
extends SVGGElementBridge {
    protected AnchorListener al;
    protected CursorMouseOverListener bl;
    protected CursorMouseOutListener cl;

    public String getLocalName() {
        return "a";
    }

    public Bridge getInstance() {
        return new SVGAElementBridge();
    }

    public void buildGraphicsNode(BridgeContext ctx, Element e, GraphicsNode node) {
        super.buildGraphicsNode(ctx, e, node);
        if (ctx.isInteractive()) {
            NodeEventTarget target = (NodeEventTarget)((Object)e);
            this.al = new AnchorListener(ctx.getUserAgent());
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.al, false, null);
            ctx.storeEventListenerNS(target, "http://www.w3.org/2001/xml-events", "click", this.al, false);
            this.bl = new CursorMouseOverListener(ctx.getUserAgent());
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.bl, false, null);
            ctx.storeEventListenerNS(target, "http://www.w3.org/2001/xml-events", "mouseover", this.bl, false);
            this.cl = new CursorMouseOutListener(ctx.getUserAgent());
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.cl, false, null);
            ctx.storeEventListenerNS(target, "http://www.w3.org/2001/xml-events", "mouseout", this.cl, false);
        }
    }

    public void dispose() {
        NodeEventTarget target = (NodeEventTarget)((Object)this.e);
        if (this.al != null) {
            target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.al, false);
            this.al = null;
        }
        if (this.bl != null) {
            target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.bl, false);
            this.bl = null;
        }
        if (this.cl != null) {
            target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.cl, false);
            this.cl = null;
        }
        super.dispose();
    }

    public boolean isComposite() {
        return true;
    }

    public static class CursorMouseOutListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOutListener(UserAgent ua) {
            this.userAgent = ua;
        }

        public void handleEvent(Event evt) {
            if (AbstractEvent.getEventPreventDefault(evt)) {
                return;
            }
            SVGAElement elt = (SVGAElement)evt.getCurrentTarget();
            if (elt != null) {
                this.userAgent.displayMessage("");
            }
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOverListener(UserAgent ua) {
            this.userAgent = ua;
        }

        public void handleEvent(Event evt) {
            SVGAElement elt;
            if (AbstractEvent.getEventPreventDefault(evt)) {
                return;
            }
            Element target = (Element)((Object)evt.getTarget());
            if (CSSUtilities.isAutoCursor(target)) {
                this.userAgent.setSVGCursor(CursorManager.ANCHOR_CURSOR);
            }
            if ((elt = (SVGAElement)evt.getCurrentTarget()) != null) {
                String href = XLinkSupport.getXLinkHref(elt);
                this.userAgent.displayMessage(href);
            }
        }
    }

    public static class AnchorListener
    implements EventListener {
        protected UserAgent userAgent;

        public AnchorListener(UserAgent ua) {
            this.userAgent = ua;
        }

        public void handleEvent(Event evt) {
            if (AbstractEvent.getEventPreventDefault(evt)) {
                return;
            }
            SVGAElement elt = (SVGAElement)evt.getCurrentTarget();
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.userAgent.setSVGCursor(cursor);
            this.userAgent.openLink(elt);
            evt.stopPropagation();
        }
    }
}

