/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.Serializable;

public class HashTable
implements Serializable {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public HashTable() {
        this.table = new Entry[11];
    }

    public HashTable(int c) {
        this.table = new Entry[c];
    }

    public HashTable(HashTable t) {
        this.count = t.count;
        this.table = new Entry[t.table.length];
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = t.table[i];
            Entry n = null;
            if (e == null) continue;
            this.table[i] = n = new Entry(e.hash, e.key, e.value, null);
            e = e.next;
            while (e != null) {
                n = n.next = new Entry(e.hash, e.key, e.value, null);
                e = e.next;
            }
        }
    }

    public int size() {
        return this.count;
    }

    public Object get(Object key) {
        int hash = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && (e.key == null && key == null || e.key != null && e.key.equals(key))) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        Entry e;
        int hash = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && (e2.key == null && key == null || e2.key != null && e2.key.equals(key))) {
                Object old = e2.value;
                e2.value = value;
                return old;
            }
            e2 = e2.next;
        }
        int len = this.table.length;
        if (this.count++ >= len * 3 >>> 2) {
            this.rehash();
            index = hash % this.table.length;
        }
        this.table[index] = e = new Entry(hash, key, value, this.table[index]);
        return null;
    }

    public Object remove(Object key) {
        int hash = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry p = null;
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && (e.key == null && key == null || e.key != null && e.key.equals(key))) {
                Object result = e.value;
                if (p == null) {
                    this.table[index] = e.next;
                } else {
                    p.next = e.next;
                }
                --this.count;
                return result;
            }
            p = e;
            e = e.next;
        }
        return null;
    }

    public Object key(int index) {
        if (index < 0 || index >= this.count) {
            return null;
        }
        int j = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            if (e == null) continue;
            do {
                if (j++ != index) continue;
                return e.key;
            } while ((e = e.next) != null);
        }
        return null;
    }

    public Object item(int index) {
        if (index < 0 || index >= this.count) {
            return null;
        }
        int j = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            if (e == null) continue;
            do {
                if (j++ != index) continue;
                return e.value;
            } while ((e = e.next) != null);
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.count = 0;
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        for (int i = oldTable.length - 1; i >= 0; --i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = e.hash % this.table.length;
                e.next = this.table[index];
                this.table[index] = e;
            }
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public Object key;
        public Object value;
        public Entry next;

        public Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

