/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.CustomEvent;
import org.apache.batik.script.ScriptEventWrapper;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class EventTargetWrapper
extends NativeJavaObject {
    protected static WeakHashMap mapOfListenerMap;
    public static final String ADD_NAME = "addEventListener";
    public static final String ADDNS_NAME = "addEventListenerNS";
    public static final String REMOVE_NAME = "removeEventListener";
    public static final String REMOVENS_NAME = "removeEventListenerNS";
    public static final String DISPATCH_NAME = "dispatchEvent";
    protected RhinoInterpreter interpreter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$java$lang$Object;

    EventTargetWrapper(Scriptable scope, EventTarget object, RhinoInterpreter interpreter) {
        super(scope, object, null);
        this.interpreter = interpreter;
    }

    public Object get(String name, Scriptable start) {
        Object method = super.get(name, start);
        if (name.equals(ADD_NAME)) {
            method = new FunctionAddProxy(this.interpreter, (Function)method, this.initMap());
        } else if (name.equals(REMOVE_NAME)) {
            method = new FunctionRemoveProxy((Function)method, this.initMap());
        } else if (name.equals(ADDNS_NAME)) {
            method = new FunctionAddNSProxy(this.interpreter, (Function)method, this.initMap());
        } else if (name.equals(REMOVENS_NAME)) {
            method = new FunctionRemoveNSProxy((Function)method, this.initMap());
        } else if (name.equals(DISPATCH_NAME)) {
            method = new FunctionDispatchProxy(this.interpreter, (Function)method, this.initMap());
        }
        return method;
    }

    public Map initMap() {
        WeakHashMap map = null;
        if (mapOfListenerMap == null) {
            mapOfListenerMap = new WeakHashMap(10);
        }
        if ((map = (WeakHashMap)mapOfListenerMap.get(this.unwrap())) == null) {
            map = new WeakHashMap(2);
            mapOfListenerMap.put(this.unwrap(), map);
        }
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FunctionDispatchProxy
    extends FunctionProxy {
        protected Map eventMap;
        protected RhinoInterpreter interpreter;

        FunctionDispatchProxy(RhinoInterpreter interpreter, Function delegate, Map eventMap) {
            super(delegate);
            this.eventMap = eventMap;
            this.interpreter = interpreter;
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            NativeJavaObject njo = (NativeJavaObject)thisObj;
            if (args[0] instanceof NativeObject) {
                ObjectCustomEvent evt = new ObjectCustomEvent((NativeObject)args[0], this.interpreter, this.eventMap);
                this.eventMap.put(args[0], new SoftReference<ObjectCustomEvent>(evt));
                args[0] = Context.jsToJava(args[0], class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable);
                ((EventTarget)njo.unwrap()).dispatchEvent(evt);
                return Undefined.instance;
            }
            return this.delegate.call(ctx, scope, thisObj, args);
        }
    }

    static class FunctionRemoveNSProxy
    extends FunctionProxy {
        protected Map listenerMap;

        FunctionRemoveNSProxy(Function delegate, Map listenerMap) {
            super(delegate);
            this.listenerMap = listenerMap;
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            NativeJavaObject njo = (NativeJavaObject)thisObj;
            if (args[2] instanceof Function) {
                SoftReference sr = (SoftReference)this.listenerMap.get(args[2]);
                if (sr == null) {
                    return Undefined.instance;
                }
                EventListener el = (EventListener)sr.get();
                if (el == null) {
                    return Undefined.instance;
                }
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.jsToJava(args[i], paramTypes[i]);
                }
                AbstractNode target = (AbstractNode)njo.unwrap();
                target.removeEventListenerNS((String)args[0], (String)args[1], el, (Boolean)args[3]);
                return Undefined.instance;
            }
            if (args[2] instanceof NativeObject) {
                SoftReference sr = (SoftReference)this.listenerMap.get(args[2]);
                if (sr == null) {
                    return Undefined.instance;
                }
                EventListener el = (EventListener)sr.get();
                if (el == null) {
                    return Undefined.instance;
                }
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.jsToJava(args[i], paramTypes[i]);
                }
                AbstractNode target = (AbstractNode)njo.unwrap();
                target.removeEventListenerNS((String)args[0], (String)args[1], el, (Boolean)args[3]);
                return Undefined.instance;
            }
            return this.delegate.call(ctx, scope, thisObj, args);
        }
    }

    static class FunctionAddNSProxy
    extends FunctionProxy {
        protected Map listenerMap;
        protected RhinoInterpreter interpreter;

        FunctionAddNSProxy(RhinoInterpreter interpreter, Function delegate, Map listenerMap) {
            super(delegate);
            this.listenerMap = listenerMap;
            this.interpreter = interpreter;
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            NativeJavaObject njo = (NativeJavaObject)thisObj;
            if (args[2] instanceof Function) {
                FunctionEventListener evtListener = new FunctionEventListener((Function)args[2], this.interpreter);
                this.listenerMap.put(args[2], new SoftReference<FunctionEventListener>(evtListener));
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = EventTargetWrapper.class$("java.lang.Object")) : class$java$lang$Object};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.jsToJava(args[i], paramTypes[i]);
                }
                AbstractNode target = (AbstractNode)njo.unwrap();
                target.addEventListenerNS((String)args[0], (String)args[1], evtListener, (Boolean)args[3], args[4]);
                return Undefined.instance;
            }
            if (args[2] instanceof NativeObject) {
                HandleEventListener evtListener = new HandleEventListener((Scriptable)args[2], this.interpreter);
                this.listenerMap.put(args[2], new SoftReference<HandleEventListener>(evtListener));
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = EventTargetWrapper.class$("java.lang.Object")) : class$java$lang$Object};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.jsToJava(args[i], paramTypes[i]);
                }
                AbstractNode target = (AbstractNode)njo.unwrap();
                target.addEventListenerNS((String)args[0], (String)args[1], evtListener, (Boolean)args[3], args[4]);
                return Undefined.instance;
            }
            return this.delegate.call(ctx, scope, thisObj, args);
        }
    }

    static class FunctionRemoveProxy
    extends FunctionProxy {
        public Map listenerMap;

        FunctionRemoveProxy(Function delegate, Map listenerMap) {
            super(delegate);
            this.listenerMap = listenerMap;
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            NativeJavaObject njo = (NativeJavaObject)thisObj;
            if (args[1] instanceof Function) {
                SoftReference sr = (SoftReference)this.listenerMap.get(args[1]);
                if (sr == null) {
                    return Undefined.instance;
                }
                EventListener el = (EventListener)sr.get();
                if (el == null) {
                    return Undefined.instance;
                }
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.jsToJava(args[i], paramTypes[i]);
                }
                ((EventTarget)njo.unwrap()).removeEventListener((String)args[0], el, (Boolean)args[2]);
                return Undefined.instance;
            }
            if (args[1] instanceof NativeObject) {
                SoftReference sr = (SoftReference)this.listenerMap.get(args[1]);
                if (sr == null) {
                    return Undefined.instance;
                }
                EventListener el = (EventListener)sr.get();
                if (el == null) {
                    return Undefined.instance;
                }
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.jsToJava(args[i], paramTypes[i]);
                }
                ((EventTarget)njo.unwrap()).removeEventListener((String)args[0], el, (Boolean)args[2]);
                return Undefined.instance;
            }
            return this.delegate.call(ctx, scope, thisObj, args);
        }
    }

    static class FunctionAddProxy
    extends FunctionProxy {
        protected Map listenerMap;
        protected RhinoInterpreter interpreter;

        FunctionAddProxy(RhinoInterpreter interpreter, Function delegate, Map listenerMap) {
            super(delegate);
            this.listenerMap = listenerMap;
            this.interpreter = interpreter;
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            NativeJavaObject njo = (NativeJavaObject)thisObj;
            if (args[1] instanceof Function) {
                EventListener evtListener = null;
                SoftReference sr = (SoftReference)this.listenerMap.get(args[1]);
                if (sr != null) {
                    evtListener = (EventListener)sr.get();
                }
                if (evtListener == null) {
                    evtListener = new FunctionEventListener((Function)args[1], this.interpreter);
                    this.listenerMap.put(args[1], new SoftReference<EventListener>(evtListener));
                }
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.jsToJava(args[i], paramTypes[i]);
                }
                ((EventTarget)njo.unwrap()).addEventListener((String)args[0], evtListener, (Boolean)args[2]);
                return Undefined.instance;
            }
            if (args[1] instanceof NativeObject) {
                EventListener evtListener = null;
                SoftReference sr = (SoftReference)this.listenerMap.get(args[1]);
                if (sr != null) {
                    evtListener = (EventListener)sr.get();
                }
                if (evtListener == null) {
                    evtListener = new HandleEventListener((Scriptable)args[1], this.interpreter);
                    this.listenerMap.put(args[1], new SoftReference<EventListener>(evtListener));
                }
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.jsToJava(args[i], paramTypes[i]);
                }
                ((EventTarget)njo.unwrap()).addEventListener((String)args[0], evtListener, (Boolean)args[2]);
                return Undefined.instance;
            }
            return this.delegate.call(ctx, scope, thisObj, args);
        }
    }

    static abstract class FunctionProxy
    implements Function {
        protected Function delegate;

        public FunctionProxy(Function delegate) {
            this.delegate = delegate;
        }

        public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
            return this.delegate.construct(cx, scope, args);
        }

        public String getClassName() {
            return this.delegate.getClassName();
        }

        public Object get(String name, Scriptable start) {
            return this.delegate.get(name, start);
        }

        public Object get(int index, Scriptable start) {
            return this.delegate.get(index, start);
        }

        public boolean has(String name, Scriptable start) {
            return this.delegate.has(name, start);
        }

        public boolean has(int index, Scriptable start) {
            return this.delegate.has(index, start);
        }

        public void put(String name, Scriptable start, Object value) {
            this.delegate.put(name, start, value);
        }

        public void put(int index, Scriptable start, Object value) {
            this.delegate.put(index, start, value);
        }

        public void delete(String name) {
            this.delegate.delete(name);
        }

        public void delete(int index) {
            this.delegate.delete(index);
        }

        public Scriptable getPrototype() {
            return this.delegate.getPrototype();
        }

        public void setPrototype(Scriptable prototype) {
            this.delegate.setPrototype(prototype);
        }

        public Scriptable getParentScope() {
            return this.delegate.getParentScope();
        }

        public void setParentScope(Scriptable parent) {
            this.delegate.setParentScope(parent);
        }

        public Object[] getIds() {
            return this.delegate.getIds();
        }

        public Object getDefaultValue(Class hint) {
            return this.delegate.getDefaultValue(hint);
        }

        public boolean hasInstance(Scriptable instance) {
            return this.delegate.hasInstance(instance);
        }
    }

    static class ObjectCustomEvent
    implements CustomEvent,
    ScriptEventWrapper {
        public Scriptable scriptable;
        public RhinoInterpreter interpreter;
        protected Map eventMap;

        public ObjectCustomEvent(Scriptable s, RhinoInterpreter interpreter, Map eventMap) {
            this.scriptable = s;
            this.interpreter = interpreter;
            this.eventMap = eventMap;
        }

        public Object getEventObject() {
            return this.scriptable;
        }

        protected Object call(String fn) {
            return this.call(fn, null);
        }

        protected Object call(String fn, Object[] args) {
            ContextAction callMethodAction = new ContextAction(this, fn, args){
                private final /* synthetic */ String val$fn;
                private final /* synthetic */ Object[] val$args;
                private final /* synthetic */ ObjectCustomEvent this$0;
                {
                    this.this$0 = this$0;
                    this.val$fn = val$fn;
                    this.val$args = val$args;
                }

                public Object run(Context cx) {
                    return ScriptableObject.callMethod(this.this$0.scriptable, this.val$fn, this.val$args);
                }
            };
            return this.interpreter.call(callMethodAction);
        }

        public String getType() {
            return (String)Context.jsToJava(this.scriptable.get("type", this.scriptable), class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String);
        }

        public EventTarget getTarget() {
            Object target = this.scriptable.get("target", this.scriptable);
            if (target instanceof NativeJavaObject) {
                target = ((NativeJavaObject)target).unwrap();
            }
            return (EventTarget)target;
        }

        public void setTarget(EventTarget target) {
            this.scriptable.put("target", this.scriptable, (Object)Context.toObject(target, this.scriptable));
        }

        public EventTarget getCurrentTarget() {
            Object target = this.scriptable.get("currentTarget", this.scriptable);
            if (target instanceof NativeJavaObject) {
                target = ((NativeJavaObject)target).unwrap();
            }
            return (EventTarget)target;
        }

        public short getEventPhase() {
            Object ep = this.scriptable.get("eventPhase", this.scriptable);
            Integer i = (Integer)Context.jsToJava(ep, class$java$lang$Integer == null ? (class$java$lang$Integer = EventTargetWrapper.class$("java.lang.Integer")) : class$java$lang$Integer);
            return (short)i.intValue();
        }

        public boolean getBubbles() {
            Object ep = this.scriptable.get("bubbles", this.scriptable);
            Boolean i = (Boolean)Context.jsToJava(ep, class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            return i;
        }

        public boolean getCancelable() {
            Object ep = this.scriptable.get("cancelable", this.scriptable);
            Boolean i = (Boolean)Context.jsToJava(ep, class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            return i;
        }

        public long getTimeStamp() {
            Object ts = this.scriptable.get("timeStamp", this.scriptable);
            Double d = (Double)Context.jsToJava(ts, class$java$lang$Double == null ? (class$java$lang$Double = EventTargetWrapper.class$("java.lang.Double")) : class$java$lang$Double);
            return (long)d.doubleValue();
        }

        public void stopPropagation() {
            this.call("stopPropagation");
        }

        public void preventDefault() {
            this.call("preventDefault");
        }

        public void initEvent(String t, boolean b, boolean c) {
            this.call("initEvent", new Object[]{t, new Boolean(b), new Boolean(c)});
        }

        public String getNamespaceURI() {
            return (String)Context.jsToJava(this.scriptable.get("namespaceURI", this.scriptable), class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String);
        }

        public boolean isCustom() {
            Boolean b = (Boolean)Context.jsToJava(this.call("isCustom"), class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            return b;
        }

        public void stopImmediatePropagation() {
            this.call("stopImmediatePropagation");
        }

        public boolean isDefaultPrevented() {
            Boolean b = (Boolean)Context.jsToJava(this.call("isDefaultPrevented"), class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            return b;
        }

        public void initEventNS(String ns, String t, boolean b, boolean c) {
            this.call("initEventNS", new Object[]{ns, t, new Boolean(b), new Boolean(c)});
        }

        public void setDispatchState(EventTarget t, short phase) {
            this.call("setDispatchState", new Object[]{t, new Double(phase)});
        }

        public boolean isPropagationStopped() {
            Boolean b = (Boolean)Context.jsToJava(this.call("isPropagationStopped"), class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            return b;
        }

        public boolean isImmediatePropagationStopped() {
            Boolean b = (Boolean)Context.jsToJava(this.call("isImmediatePropagationStopped"), class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            return b;
        }

        public void resumePropagation() {
            this.call("resumePropagation");
        }

        public CustomEvent retarget(EventTarget target) {
            Object ret = this.call("cloneEventObject", new Object[]{target});
            if (ret instanceof ScriptableObject) {
                ScriptableObject e = (ScriptableObject)ret;
                e.put("originalEvent", (Scriptable)e, (Object)this.scriptable);
                e.put("target", (Scriptable)e, (Object)Context.toObject(target, this.scriptable));
                e.put("type", (Scriptable)e, this.scriptable.get("type", this.scriptable));
                e.put("currentTarget", (Scriptable)e, this.scriptable.get("currentTarget", this.scriptable));
                e.put("eventPhase", (Scriptable)e, this.scriptable.get("eventPhase", this.scriptable));
                e.put("bubbles", (Scriptable)e, this.scriptable.get("bubbles", this.scriptable));
                e.put("cancelable", (Scriptable)e, this.scriptable.get("cancelable", this.scriptable));
                e.put("timeStamp", (Scriptable)e, this.scriptable.get("timeStamp", this.scriptable));
                e.put("namespaceURI", (Scriptable)e, this.scriptable.get("namespaceURI", this.scriptable));
                ObjectCustomEvent evt = new ObjectCustomEvent((NativeObject)ret, this.interpreter, this.eventMap);
                this.eventMap.put(ret, new SoftReference<ObjectCustomEvent>(evt));
                return evt;
            }
            return null;
        }

        public Event getOriginalEvent() {
            Object target = this.scriptable.get("target", this.scriptable);
            if (target instanceof NativeJavaObject) {
                target = ((NativeJavaObject)target).unwrap();
            }
            return (Event)target;
        }
    }

    static class HandleEventListener
    implements EventListener {
        public static final String HANDLE_EVENT = "handleEvent";
        public Scriptable scriptable;
        public Object[] array = new Object[1];
        public RhinoInterpreter interpreter;

        HandleEventListener(Scriptable s, RhinoInterpreter interpreter) {
            this.scriptable = s;
            this.interpreter = interpreter;
        }

        public void handleEvent(Event evt) {
            this.array[0] = evt instanceof ScriptEventWrapper ? ((ScriptEventWrapper)((Object)evt)).getEventObject() : evt;
            ContextAction handleEventAction = new ContextAction(this){
                private final /* synthetic */ HandleEventListener this$0;
                {
                    this.this$0 = this$0;
                }

                public Object run(Context cx) {
                    ScriptableObject.callMethod(this.this$0.scriptable, "handleEvent", this.this$0.array);
                    return null;
                }
            };
            this.interpreter.call(handleEventAction);
        }
    }

    static class FunctionEventListener
    implements EventListener {
        protected Function function;
        protected RhinoInterpreter interpreter;

        FunctionEventListener(Function f, RhinoInterpreter i) {
            this.function = f;
            this.interpreter = i;
        }

        public void handleEvent(Event evt) {
            Object event = evt instanceof ScriptEventWrapper ? ((ScriptEventWrapper)((Object)evt)).getEventObject() : evt;
            this.interpreter.callHandler(this.function, event);
        }
    }
}

