/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.batik.ext.awt.geom.Polygon2D;
import org.apache.batik.ext.awt.geom.Polyline2D;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFReader;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;

public class WMFHeaderProperties
extends AbstractWMFReader {
    protected DataInputStream stream;
    private int _bleft;
    private int _bright;
    private int _btop;
    private int _bbottom;
    private int _bwidth;
    private int _bheight;
    private int _ileft;
    private int _iright;
    private int _itop;
    private int _ibottom;
    private float scale = 1.0f;
    private transient boolean firstEffectivePaint = true;
    public static final int PEN = 1;
    public static final int BRUSH = 2;
    public static final int FONT = 3;
    public static final int NULL_PEN = 4;
    public static final int NULL_BRUSH = 5;
    public static final int PALETTE = 6;
    public static final int OBJ_BITMAP = 7;
    public static final int OBJ_REGION = 8;

    public WMFHeaderProperties(File wmffile) throws IOException {
        this.reset();
        this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(wmffile)));
        this.read(this.stream);
        this.stream.close();
    }

    public WMFHeaderProperties() {
    }

    public void closeResource() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setFile(File wmffile) throws IOException {
        this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(wmffile)));
        this.read(this.stream);
        this.stream.close();
    }

    public void reset() {
        this.left = 0;
        this.right = 0;
        this.top = 1000;
        this.bottom = 1000;
        this.inch = 100;
        this._bleft = -1;
        this._bright = -1;
        this._btop = -1;
        this._bbottom = -1;
        this._ileft = -1;
        this._iright = -1;
        this._itop = -1;
        this._ibottom = -1;
        this._bwidth = -1;
        this._bheight = -1;
        this.vpW = -1;
        this.vpH = -1;
        this.vpX = 0;
        this.vpY = 0;
        this.firstEffectivePaint = true;
    }

    public DataInputStream getStream() {
        return this.stream;
    }

    protected boolean readRecords(DataInputStream is) throws IOException {
        int functionId = 1;
        int recSize = 0;
        int brushObject = -1;
        int penObject = -1;
        int fontObject = -1;
        short lfWidth = 0;
        short lfHeight = 0;
        block29: while (functionId > 0) {
            recSize = this.readInt(is);
            recSize -= 3;
            functionId = this.readShort(is);
            if (functionId <= 0) break;
            switch (functionId) {
                case 523: {
                    this.vpY = this.readShort(is);
                    this.vpX = this.readShort(is);
                    continue block29;
                }
                case 524: {
                    this.vpH = this.readShort(is);
                    this.vpW = this.readShort(is);
                    continue block29;
                }
                case 762: {
                    int objIndex = 0;
                    short penStyle = this.readShort(is);
                    this.readInt(is);
                    int colorref = this.readInt(is);
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    Color color = new Color(red, green, blue);
                    if (recSize == 6) {
                        this.readShort(is);
                    }
                    if (penStyle == 5) {
                        objIndex = this.addObjectAt(4, color, objIndex);
                        continue block29;
                    }
                    objIndex = this.addObjectAt(1, color, objIndex);
                    continue block29;
                }
                case 764: {
                    int objIndex = 0;
                    short brushStyle = this.readShort(is);
                    int colorref = this.readInt(is);
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    Color color = new Color(red, green, blue);
                    this.readShort(is);
                    if (brushStyle == 5) {
                        objIndex = this.addObjectAt(5, color, objIndex);
                        continue block29;
                    }
                    objIndex = this.addObjectAt(2, color, objIndex);
                    continue block29;
                }
                case 2610: {
                    short y = this.readShort(is);
                    short x = this.readShort(is);
                    int lenText = this.readInt(is);
                    int len = 2 * (recSize - 4);
                    for (int i = 0; i < len; ++i) {
                        is.readByte();
                    }
                    this.resizeBounds(x, y);
                    this.resizeBounds(x + lfWidth * lenText, y + lfHeight);
                    this.firstEffectivePaint = false;
                    continue block29;
                }
                case 1313: {
                    int len = this.readShort(is);
                    for (int i = 0; i < len; ++i) {
                        is.readByte();
                    }
                    if (len % 2 != 0) {
                        is.readByte();
                    }
                    short y = this.readShort(is);
                    short x = this.readShort(is);
                    this.resizeBounds(x, y);
                    this.resizeBounds(x + lfWidth * len, y + lfHeight);
                    continue block29;
                }
                case 763: {
                    int objIndex = 0;
                    lfHeight = this.readShort(is);
                    lfWidth = this.readShort(is);
                    this.readShort(is);
                    this.readShort(is);
                    this.readShort(is);
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    int len = 2 * (recSize - 9);
                    for (int i = 0; i < len; ++i) {
                        is.readByte();
                    }
                    objIndex = this.addObjectAt(3, new Boolean(true), objIndex);
                    continue block29;
                }
                case 1791: {
                    int objIndex = 0;
                    for (int j = 0; j < recSize; ++j) {
                        this.readShort(is);
                    }
                    objIndex = this.addObjectAt(6, new Integer(0), 0);
                    continue block29;
                }
                case 247: {
                    int objIndex = 0;
                    for (int j = 0; j < recSize; ++j) {
                        this.readShort(is);
                    }
                    objIndex = this.addObjectAt(8, new Integer(0), 0);
                    continue block29;
                }
                case 301: {
                    int gdiIndex = this.readShort(is);
                    if ((gdiIndex & Integer.MIN_VALUE) != 0) continue block29;
                    GdiObject gdiObj = this.getObject(gdiIndex);
                    if (!gdiObj.used) continue block29;
                    switch (gdiObj.type) {
                        case 1: {
                            penObject = gdiIndex;
                            break;
                        }
                        case 2: {
                            brushObject = gdiIndex;
                            break;
                        }
                        case 3: {
                            fontObject = gdiIndex;
                            break;
                        }
                        case 4: {
                            penObject = -1;
                            break;
                        }
                        case 5: {
                            brushObject = -1;
                        }
                    }
                    continue block29;
                }
                case 496: {
                    int gdiIndex = this.readShort(is);
                    GdiObject gdiObj = this.getObject(gdiIndex);
                    if (gdiIndex == brushObject) {
                        brushObject = -1;
                    } else if (gdiIndex == penObject) {
                        penObject = -1;
                    } else if (gdiIndex == fontObject) {
                        fontObject = -1;
                    }
                    gdiObj.clear();
                    continue block29;
                }
                case 531: 
                case 532: {
                    short y = this.readShort(is);
                    short x = this.readShort(is);
                    if (penObject >= 0) {
                        this.resizeBounds(x, y);
                    }
                    this.firstEffectivePaint = false;
                    continue block29;
                }
                case 1336: {
                    int count = this.readShort(is);
                    int[] pts = new int[count];
                    int ptCount = 0;
                    for (int i = 0; i < count; ++i) {
                        pts[i] = this.readShort(is);
                        ptCount += pts[i];
                    }
                    int offset = count + 1;
                    for (int i = 0; i < count; ++i) {
                        for (int j = 0; j < pts[i]; ++j) {
                            short x = this.readShort(is);
                            short y = this.readShort(is);
                            if (brushObject < 0 && penObject < 0) continue;
                            this.resizeBounds(x, y);
                        }
                    }
                    this.firstEffectivePaint = false;
                    continue block29;
                }
                case 804: {
                    int count = this.readShort(is);
                    float[] _xpts = new float[count + 1];
                    float[] _ypts = new float[count + 1];
                    for (int i = 0; i < count; ++i) {
                        _xpts[i] = this.readShort(is);
                        _ypts[i] = this.readShort(is);
                    }
                    _xpts[count] = _xpts[0];
                    _ypts[count] = _ypts[0];
                    Polygon2D pol = new Polygon2D(_xpts, _ypts, count);
                    this.paint(brushObject, penObject, pol);
                    continue block29;
                }
                case 805: {
                    int count = this.readShort(is);
                    float[] _xpts = new float[count];
                    float[] _ypts = new float[count];
                    for (int i = 0; i < count; ++i) {
                        _xpts[i] = this.readShort(is);
                        _ypts[i] = this.readShort(is);
                    }
                    Polyline2D pol = new Polyline2D(_xpts, _ypts, count);
                    this.paintWithPen(penObject, pol);
                    continue block29;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    short bot = this.readShort(is);
                    short right = this.readShort(is);
                    short top = this.readShort(is);
                    short left = this.readShort(is);
                    Rectangle2D.Float rec = new Rectangle2D.Float(left, top, right - left, this.bottom - top);
                    this.paint(brushObject, penObject, rec);
                    continue block29;
                }
                case 1564: {
                    this.readShort(is);
                    this.readShort(is);
                    short bot = this.readShort(is);
                    short right = this.readShort(is);
                    short top = this.readShort(is);
                    short left = this.readShort(is);
                    Rectangle2D.Float rec = new Rectangle2D.Float(left, top, right - left, this.bottom - top);
                    this.paint(brushObject, penObject, rec);
                    continue block29;
                }
                case 2071: 
                case 2074: 
                case 2096: {
                    this.readShort(is);
                    this.readShort(is);
                    this.readShort(is);
                    this.readShort(is);
                    short bot = this.readShort(is);
                    short right = this.readShort(is);
                    short top = this.readShort(is);
                    short left = this.readShort(is);
                    Rectangle2D.Float rec = new Rectangle2D.Float(left, top, right - left, this.bottom - top);
                    this.paint(brushObject, penObject, rec);
                    continue block29;
                }
                case 1565: {
                    this.readInt(is);
                    short height = this.readShort(is);
                    short width = this.readShort(is);
                    short left = this.readShort(is);
                    short top = this.readShort(is);
                    if (penObject >= 0) {
                        this.resizeBounds(left, top);
                    }
                    if (penObject < 0) continue block29;
                    this.resizeBounds(left + width, top + height);
                    continue block29;
                }
                case 2881: {
                    is.readInt();
                    this.readShort(is);
                    this.readShort(is);
                    this.readShort(is);
                    this.readShort(is);
                    float heightDst = this.readShort(is);
                    float widthDst = this.readShort(is);
                    float dy = (float)this.readShort(is) * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH;
                    float dx = (float)this.readShort(is) * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH;
                    widthDst = widthDst * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH;
                    heightDst = heightDst * this.getVpHFactor() * (float)this.inch / PIXEL_PER_INCH;
                    this.resizeImageBounds((int)dx, (int)dy);
                    this.resizeImageBounds((int)(dx + widthDst), (int)(dy + heightDst));
                    int len = 2 * recSize - 20;
                    for (int i = 0; i < len; ++i) {
                        is.readByte();
                    }
                    continue block29;
                }
            }
            for (int j = 0; j < recSize; ++j) {
                this.readShort(is);
            }
        }
        this.resetBounds();
        return true;
    }

    public int getWidthBoundsPixels() {
        return this._bwidth;
    }

    public int getHeightBoundsPixels() {
        return this._bheight;
    }

    public int getWidthBoundsUnits() {
        return (int)((float)this.inch * (float)this._bwidth / PIXEL_PER_INCH);
    }

    public int getHeightBoundsUnits() {
        return (int)((float)this.inch * (float)this._bheight / PIXEL_PER_INCH);
    }

    public int getXOffset() {
        return this._bleft;
    }

    public int getYOffset() {
        return this._btop;
    }

    private void resetBounds() {
        this.scale = (float)this.getWidthPixels() / (float)this.vpW;
        if (this._bright != -1) {
            this._bright = (int)(this.scale * (float)(this.vpX + this._bright));
            this._bleft = (int)(this.scale * (float)(this.vpX + this._bleft));
            this._bbottom = (int)(this.scale * (float)(this.vpY + this._bbottom));
            this._btop = (int)(this.scale * (float)(this.vpY + this._btop));
        }
        if (this._iright != -1) {
            this._iright = (int)((float)this._iright * (float)this.getWidthPixels() / (float)this.width);
            this._ileft = (int)((float)this._ileft * (float)this.getWidthPixels() / (float)this.width);
            this._ibottom = (int)((float)this._ibottom * (float)this.getWidthPixels() / (float)this.width);
            this._itop = (int)((float)this._itop * (float)this.getWidthPixels() / (float)this.width);
            if (this._bright == -1 || this._iright > this._bright) {
                this._bright = this._iright;
            }
            if (this._bleft == -1 || this._ileft < this._bleft) {
                this._bleft = this._ileft;
            }
            if (this._btop == -1 || this._itop < this._btop) {
                this._btop = this._itop;
            }
            if (this._bbottom == -1 || this._ibottom > this._bbottom) {
                this._bbottom = this._ibottom;
            }
        }
        if (this._bleft != -1 && this._bright != -1) {
            this._bwidth = this._bright - this._bleft;
        }
        if (this._btop != -1 && this._bbottom != -1) {
            this._bheight = this._bbottom - this._btop;
        }
    }

    private void resizeBounds(int x, int y) {
        if (x < this.right && x > this.left) {
            if (this._bleft == -1) {
                this._bleft = x;
            } else if (x < this._bleft) {
                this._bleft = x;
            }
            if (this._bright == -1) {
                this._bright = x;
            } else if (x > this._bright) {
                this._bright = x;
            }
        }
        if (y < this.bottom && y > this.top) {
            if (this._btop == -1) {
                this._btop = y;
            } else if (y < this._btop) {
                this._btop = y;
            }
            if (this._bbottom == -1) {
                this._bbottom = y;
            } else if (y > this._bbottom) {
                this._bbottom = y;
            }
        }
    }

    private void resizeImageBounds(int x, int y) {
        if (x < this.right && x > this.left) {
            if (this._ileft == -1) {
                this._ileft = x;
            } else if (x < this._ileft) {
                this._ileft = x;
            }
            if (this._iright == -1) {
                this._iright = x;
            } else if (x > this._iright) {
                this._iright = x;
            }
        }
        if (y < this.bottom && y > this.top) {
            if (this._itop == -1) {
                this._itop = y;
            } else if (y < this._itop) {
                this._itop = y;
            }
            if (this._ibottom == -1) {
                this._ibottom = y;
            } else if (y > this._ibottom) {
                this._ibottom = y;
            }
        }
    }

    private Color getColorFromObject(int brushObject) {
        Object color = null;
        if (brushObject >= 0) {
            GdiObject gdiObj = this.getObject(brushObject);
            return (Color)gdiObj.obj;
        }
        return null;
    }

    private void paint(int brushObject, int penObject, Shape shape) {
        if (brushObject >= 0 || penObject >= 0) {
            Color col = brushObject >= 0 ? this.getColorFromObject(brushObject) : this.getColorFromObject(penObject);
            if (!this.firstEffectivePaint || !col.equals(Color.white)) {
                Rectangle rec = shape.getBounds();
                this.resizeBounds((int)rec.getMinX(), (int)rec.getMinY());
                this.resizeBounds((int)rec.getMaxX(), (int)rec.getMaxY());
                this.firstEffectivePaint = false;
            }
        }
    }

    private void paintWithPen(int penObject, Shape shape) {
        if (penObject >= 0) {
            Color col = this.getColorFromObject(penObject);
            if (!this.firstEffectivePaint || !col.equals(Color.white)) {
                Rectangle rec = shape.getBounds();
                this.resizeBounds((int)rec.getMinX(), (int)rec.getMinY());
                this.resizeBounds((int)rec.getMaxX(), (int)rec.getMaxY());
                this.firstEffectivePaint = false;
            }
        }
    }
}

