/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.apache.batik.ext.awt.geom.Polygon2D;
import org.apache.batik.ext.awt.geom.Polyline2D;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFPainter;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.TextureFactory;
import org.apache.batik.transcoder.wmf.tosvg.WMFFont;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;

public class WMFPainter
extends AbstractWMFPainter {
    private static final int INPUT_BUFFER_SIZE = 30720;
    private float scale;
    private float scaleX;
    private float scaleY;
    private float conv;
    private float xOffset;
    private float yOffset;
    private float vpX;
    private float vpY;
    private float vpW;
    private float vpH;
    private Color frgdColor;
    private Color bkgdColor;
    private boolean opaque = false;
    private transient boolean firstEffectivePaint = true;
    private static BasicStroke solid = new BasicStroke(1.0f, 0, 1);
    private static BasicStroke textSolid = new BasicStroke(1.0f, 0, 1);
    private transient ImageObserver observer = new ImageObserver(){

        public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
            return false;
        }
    };
    private transient BufferedInputStream bufStream = null;

    public WMFPainter(WMFRecordStore currentStore, float scale) {
        this(currentStore, 0, 0, scale);
    }

    public WMFPainter(WMFRecordStore currentStore, int xOffset, int yOffset, float scale) {
        this.setRecordStore(currentStore);
        TextureFactory.getInstance().reset();
        this.conv = scale;
        this.xOffset = -xOffset;
        this.yOffset = -yOffset;
        this.scale = (float)currentStore.getWidthPixels() / (float)currentStore.getWidthUnits() * scale;
        this.scale = this.scale * (float)currentStore.getWidthPixels() / (float)currentStore.getVpW();
        float xfactor = (float)currentStore.getVpW() / (float)currentStore.getWidthPixels() * (float)currentStore.getWidthUnits() / (float)currentStore.getWidthPixels();
        float yfactor = (float)currentStore.getVpH() / (float)currentStore.getHeightPixels() * (float)currentStore.getHeightUnits() / (float)currentStore.getHeightPixels();
        this.xOffset *= xfactor;
        this.yOffset *= yfactor;
        this.scaleX = this.scale;
        this.scaleY = this.scale;
    }

    public void paint(Graphics g) {
        float fontHeight = 10.0f;
        float fontAngle = 0.0f;
        float penWidth = 0.0f;
        float startX = 0.0f;
        float startY = 0.0f;
        int brushObject = -1;
        int penObject = -1;
        int fontObject = -1;
        Object font = null;
        Stack<Serializable> dcStack = new Stack<Serializable>();
        int numRecords = this.currentStore.getNumRecords();
        int numObjects = this.currentStore.getNumObjects();
        this.vpX = this.currentStore.getVpX() * this.scale;
        this.vpY = this.currentStore.getVpY() * this.scale;
        this.vpW = (float)this.currentStore.getVpW() * this.scale;
        this.vpH = (float)this.currentStore.getVpH() * this.scale;
        if (!this.currentStore.isReading()) {
            GdiObject gdiObj;
            g.setPaintMode();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(solid);
            brushObject = -1;
            penObject = -1;
            fontObject = -1;
            this.frgdColor = null;
            this.bkgdColor = Color.white;
            for (int i = 0; i < numObjects; ++i) {
                gdiObj = this.currentStore.getObject(i);
                gdiObj.clear();
            }
            float w = this.vpW;
            float h = this.vpH;
            g2d.setColor(Color.black);
            block56: for (int iRec = 0; iRec < numRecords; ++iRec) {
                MetaRecord mr = this.currentStore.getRecord(iRec);
                switch (mr.functionId) {
                    case 523: {
                        this.vpX = -((float)mr.ElementAt(0).intValue());
                        this.currentStore.setVpX(this.vpX);
                        this.vpY = -((float)mr.ElementAt(1).intValue());
                        this.currentStore.setVpY(this.vpY);
                        this.vpX *= this.scale;
                        this.vpY *= this.scale;
                        continue block56;
                    }
                    case 0: 
                    case 524: {
                        this.vpW = mr.ElementAt(0).intValue();
                        this.vpH = mr.ElementAt(1).intValue();
                        this.scaleX = this.scale;
                        this.scaleY = this.scale;
                        solid = new BasicStroke(this.scaleX * 2.0f, 0, 1);
                        continue block56;
                    }
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 1040: 
                    case 1042: {
                        continue block56;
                    }
                    case 262: {
                        continue block56;
                    }
                    case 762: {
                        Color newClr;
                        int objIndex = 0;
                        int penStyle = mr.ElementAt(0);
                        if (penStyle == 5) {
                            newClr = new Color(255, 255, 255);
                            objIndex = this.addObjectAt(this.currentStore, 4, newClr, objIndex);
                            continue block56;
                        }
                        penWidth = mr.ElementAt(4).intValue();
                        this.setStroke(g2d, penStyle, penWidth, this.scaleX);
                        newClr = new Color(mr.ElementAt(1), mr.ElementAt(2), mr.ElementAt(3));
                        objIndex = this.addObjectAt(this.currentStore, 1, newClr, objIndex);
                        continue block56;
                    }
                    case 764: {
                        int objIndex = 0;
                        int brushStyle = mr.ElementAt(0);
                        Color clr = new Color(mr.ElementAt(1), mr.ElementAt(2), mr.ElementAt(3));
                        if (brushStyle == 0) {
                            objIndex = this.addObjectAt(this.currentStore, 2, clr, objIndex);
                            continue block56;
                        }
                        if (brushStyle == 2) {
                            int hatch = mr.ElementAt(4);
                            Paint paint = !this.opaque ? TextureFactory.getInstance().getTexture(hatch, clr) : TextureFactory.getInstance().getTexture(hatch, clr, this.bkgdColor);
                            if (paint != null) {
                                objIndex = this.addObjectAt(this.currentStore, 2, paint, objIndex);
                                continue block56;
                            }
                            clr = new Color(0, 0, 0);
                            objIndex = this.addObjectAt(this.currentStore, 5, clr, objIndex);
                            continue block56;
                        }
                        clr = new Color(0, 0, 0);
                        objIndex = this.addObjectAt(this.currentStore, 5, clr, objIndex);
                        continue block56;
                    }
                    case 763: {
                        int d;
                        float size = (int)(this.scaleY * (float)mr.ElementAt(0).intValue());
                        int charset = mr.ElementAt(3);
                        int italic = mr.ElementAt(1);
                        int weight = mr.ElementAt(2);
                        int style = italic > 0 ? 2 : 0;
                        style |= weight > 400 ? 1 : 0;
                        String face = ((MetaRecord.StringRecord)mr).text;
                        for (d = 0; d < face.length() && (Character.isLetterOrDigit(face.charAt(d)) || Character.isWhitespace(face.charAt(d))); ++d) {
                        }
                        face = d > 0 ? face.substring(0, d) : "System";
                        if (size < 0.0f) {
                            size = -size;
                        }
                        int objIndex = 0;
                        fontHeight = size;
                        Font f = new Font(face, style, (int)size);
                        f = f.deriveFont(size);
                        int underline = mr.ElementAt(4);
                        int strikeOut = mr.ElementAt(5);
                        int orient = mr.ElementAt(6);
                        int escape = mr.ElementAt(7);
                        WMFFont wf = new WMFFont(f, charset, underline, strikeOut, italic, weight, orient, escape);
                        objIndex = this.addObjectAt(this.currentStore, 3, wf, objIndex);
                        continue block56;
                    }
                    case 248: 
                    case 505: 
                    case 765: 
                    case 1790: 
                    case 1791: {
                        int objIndex = 0;
                        objIndex = this.addObjectAt(this.currentStore, 6, new Integer(0), 0);
                        continue block56;
                    }
                    case 247: {
                        int objIndex = 0;
                        objIndex = this.addObjectAt(this.currentStore, 8, new Integer(0), 0);
                        continue block56;
                    }
                    case 53: 
                    case 55: 
                    case 313: 
                    case 564: 
                    case 1078: {
                        continue block56;
                    }
                    case 301: {
                        int gdiIndex = mr.ElementAt(0);
                        if ((gdiIndex & Integer.MIN_VALUE) != 0) continue block56;
                        if (gdiIndex >= numObjects) {
                            switch (gdiIndex -= numObjects) {
                                case 5: {
                                    brushObject = -1;
                                    continue block56;
                                }
                                case 8: {
                                    penObject = -1;
                                    continue block56;
                                }
                            }
                            continue block56;
                        }
                        gdiObj = this.currentStore.getObject(gdiIndex);
                        if (!gdiObj.used) continue block56;
                        switch (gdiObj.type) {
                            case 1: {
                                g2d.setColor((Color)gdiObj.obj);
                                penObject = gdiIndex;
                                break;
                            }
                            case 2: {
                                if (gdiObj.obj instanceof Color) {
                                    g2d.setColor((Color)gdiObj.obj);
                                } else if (gdiObj.obj instanceof Paint) {
                                    g2d.setPaint((Paint)gdiObj.obj);
                                } else {
                                    g2d.setPaint(this.getPaint((byte[])gdiObj.obj));
                                }
                                brushObject = gdiIndex;
                                break;
                            }
                            case 3: {
                                this.wmfFont = (WMFFont)gdiObj.obj;
                                Font f = this.wmfFont.font;
                                g2d.setFont(f);
                                fontObject = gdiIndex;
                                break;
                            }
                            case 4: {
                                penObject = -1;
                                break;
                            }
                            case 5: {
                                brushObject = -1;
                            }
                        }
                        continue block56;
                    }
                    case 496: {
                        int gdiIndex = mr.ElementAt(0);
                        gdiObj = this.currentStore.getObject(gdiIndex);
                        if (gdiIndex == brushObject) {
                            brushObject = -1;
                        } else if (gdiIndex == penObject) {
                            penObject = -1;
                        } else if (gdiIndex == fontObject) {
                            fontObject = -1;
                        }
                        gdiObj.clear();
                        continue block56;
                    }
                    case 1336: {
                        int numPolygons = mr.ElementAt(0);
                        int[] pts = new int[numPolygons];
                        for (int ip = 0; ip < numPolygons; ++ip) {
                            pts[ip] = mr.ElementAt(ip + 1);
                        }
                        int offset = numPolygons + 1;
                        Vector<Polygon2D> v = new Vector<Polygon2D>(1);
                        for (int j = 0; j < numPolygons; ++j) {
                            int count = pts[j];
                            float[] xpts = new float[count];
                            float[] ypts = new float[count];
                            for (int k = 0; k < count; ++k) {
                                xpts[k] = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(offset + k * 2).intValue()));
                                ypts[k] = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(offset + k * 2 + 1).intValue()));
                            }
                            offset += count * 2;
                            Polygon2D pol = new Polygon2D(xpts, ypts, count);
                            v.add(pol);
                        }
                        if (brushObject >= 0) {
                            this.setBrushPaint(this.currentStore, g2d, brushObject);
                            this.fillPolyPolygon(g2d, v);
                            this.firstEffectivePaint = false;
                        }
                        if (penObject < 0) continue block56;
                        this.setPenColor(this.currentStore, g2d, penObject);
                        this.drawPolyPolygon(g2d, v);
                        this.firstEffectivePaint = false;
                        continue block56;
                    }
                    case 804: {
                        int count = mr.ElementAt(0);
                        float[] _xpts = new float[count];
                        float[] _ypts = new float[count];
                        for (int k = 0; k < count; ++k) {
                            _xpts[k] = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(k * 2 + 1).intValue()));
                            _ypts[k] = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(k * 2 + 2).intValue()));
                        }
                        Polygon2D pol = new Polygon2D(_xpts, _ypts, count);
                        this.paint(brushObject, penObject, pol, g2d);
                        continue block56;
                    }
                    case 532: {
                        startX = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(0).intValue()));
                        startY = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(1).intValue()));
                        continue block56;
                    }
                    case 531: {
                        float endX = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(0).intValue()));
                        float endY = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(1).intValue()));
                        Line2D.Float line = new Line2D.Float(startX, startY, endX, endY);
                        this.paintWithPen(penObject, line, g2d);
                        startX = endX;
                        startY = endY;
                        continue block56;
                    }
                    case 805: {
                        int count = mr.ElementAt(0);
                        float[] _xpts = new float[count];
                        float[] _ypts = new float[count];
                        for (int k = 0; k < count; ++k) {
                            _xpts[k] = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(k * 2 + 1).intValue()));
                            _ypts[k] = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(k * 2 + 2).intValue()));
                        }
                        Polyline2D pol = new Polyline2D(_xpts, _ypts, count);
                        this.paintWithPen(penObject, pol, g2d);
                        continue block56;
                    }
                    case 1051: {
                        float x1 = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(0).intValue()));
                        float x2 = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(2).intValue()));
                        float y1 = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(1).intValue()));
                        float y2 = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(3).intValue()));
                        Rectangle2D.Float rec = new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1);
                        this.paint(brushObject, penObject, rec, g2d);
                        continue block56;
                    }
                    case 1564: {
                        float x1 = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(0).intValue()));
                        float x2 = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(2).intValue()));
                        float x3 = this.scaleX * (float)mr.ElementAt(4).intValue();
                        float y1 = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(1).intValue()));
                        float y2 = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(3).intValue()));
                        float y3 = this.scaleY * (float)mr.ElementAt(5).intValue();
                        RoundRectangle2D.Float rec = new RoundRectangle2D.Float(x1, y1, x2 - x1, y2 - y1, x3, y3);
                        this.paint(brushObject, penObject, rec, g2d);
                        continue block56;
                    }
                    case 1048: {
                        float x1 = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(0).intValue()));
                        float x2 = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(2).intValue()));
                        float y1 = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(1).intValue()));
                        float y2 = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(3).intValue()));
                        Ellipse2D.Float el = new Ellipse2D.Float(x1, y1, x2 - x1, y2 - y1);
                        this.paint(brushObject, penObject, el, g2d);
                        continue block56;
                    }
                    case 302: {
                        this.currentAlign = this.getHorizontalAlignement(mr.ElementAt(0));
                        continue block56;
                    }
                    case 521: {
                        this.frgdColor = new Color(mr.ElementAt(0), mr.ElementAt(1), mr.ElementAt(2));
                        g2d.setColor(this.frgdColor);
                        continue block56;
                    }
                    case 513: {
                        this.bkgdColor = new Color(mr.ElementAt(0), mr.ElementAt(1), mr.ElementAt(2));
                        g2d.setColor(this.bkgdColor);
                        continue block56;
                    }
                    case 2610: {
                        try {
                            byte[] bstr = ((MetaRecord.ByteRecord)mr).bstr;
                            String sr = this.decodeString(bstr);
                            float x = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(0).intValue()));
                            float y = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(1).intValue()));
                            if (this.frgdColor != null) {
                                g2d.setColor(this.frgdColor);
                            } else {
                                g2d.setColor(Color.black);
                            }
                            FontRenderContext frc = g2d.getFontRenderContext();
                            Point2D.Double pen = new Point2D.Double(0.0, 0.0);
                            GeneralPath gp = new GeneralPath(1);
                            TextLayout layout = new TextLayout(sr, g2d.getFont(), frc);
                            pen.y += (double)layout.getAscent();
                            int flag = mr.ElementAt(2);
                            int x1 = 0;
                            int y1 = 0;
                            int x2 = 0;
                            int y2 = 0;
                            boolean clipped = false;
                            Shape clip = null;
                            if ((flag & 4) != 0) {
                                clipped = true;
                                x1 = mr.ElementAt(3);
                                y1 = mr.ElementAt(3);
                                x2 = mr.ElementAt(4);
                                y2 = mr.ElementAt(5);
                                clip = g2d.getClip();
                                g2d.setClip(x1, y1, x2, y2);
                            }
                            this.firstEffectivePaint = false;
                            this.drawString(flag, g2d, this.getCharacterIterator(g2d, sr, this.wmfFont, this.currentAlign), x, y, layout, this.wmfFont, this.currentAlign);
                            if (!clipped) continue block56;
                            g2d.setClip(clip);
                        }
                        catch (Exception e) {}
                        continue block56;
                    }
                    case 1313: 
                    case 1583: {
                        try {
                            byte[] bstr = ((MetaRecord.ByteRecord)mr).bstr;
                            String sr = this.decodeString(bstr);
                            float x = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(0).intValue()));
                            float y = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(1).intValue()));
                            if (this.frgdColor != null) {
                                g2d.setColor(this.frgdColor);
                            } else {
                                g2d.setColor(Color.black);
                            }
                            FontRenderContext frc = g2d.getFontRenderContext();
                            Point2D.Double pen = new Point2D.Double(0.0, 0.0);
                            GeneralPath gp = new GeneralPath(1);
                            TextLayout layout = new TextLayout(sr, g2d.getFont(), frc);
                            pen.y += (double)layout.getAscent();
                            this.firstEffectivePaint = false;
                            this.drawString(-1, g2d, this.getCharacterIterator(g2d, sr, this.wmfFont), x, y, layout, this.wmfFont, this.currentAlign);
                        }
                        catch (Exception e) {}
                        continue block56;
                    }
                    case 2071: 
                    case 2074: {
                        double left = (double)this.scaleX * ((double)(this.vpX + this.xOffset) + mr.ElementAt(0).doubleValue());
                        double top = (double)this.scaleY * ((double)(this.vpY + this.yOffset) + mr.ElementAt(1).doubleValue());
                        double right = (double)this.scaleX * ((double)(this.vpX + this.xOffset) + mr.ElementAt(2).doubleValue());
                        double bottom = (double)this.scaleY * ((double)(this.vpY + this.yOffset) + mr.ElementAt(3).doubleValue());
                        double xstart = (double)this.scaleX * ((double)(this.vpX + this.xOffset) + mr.ElementAt(4).doubleValue());
                        double ystart = (double)this.scaleY * ((double)(this.vpY + this.yOffset) + mr.ElementAt(5).doubleValue());
                        double xend = (double)this.scaleX * ((double)(this.vpX + this.xOffset) + mr.ElementAt(6).doubleValue());
                        double yend = (double)this.scaleY * ((double)(this.vpY + this.yOffset) + mr.ElementAt(7).doubleValue());
                        this.setBrushPaint(this.currentStore, g2d, brushObject);
                        double cx = left + (right - left) / 2.0;
                        double cy = top + (bottom - top) / 2.0;
                        double startAngle = -(57.29577951308232 * Math.atan2(ystart - cy, xstart - cx));
                        double endAngle = -(57.29577951308232 * Math.atan2(yend - cy, xend - cx));
                        double extentAngle = endAngle - startAngle;
                        if (extentAngle < 0.0) {
                            extentAngle += 360.0;
                        }
                        if (startAngle < 0.0) {
                            startAngle += 360.0;
                        }
                        Arc2D.Double arc = new Arc2D.Double(left, top, right - left, bottom - top, startAngle, extentAngle, 0);
                        if (mr.functionId == 2071) {
                            g2d.draw(arc);
                        } else {
                            g2d.fill(arc);
                        }
                        this.firstEffectivePaint = false;
                        continue block56;
                    }
                    case 2096: {
                        double left = (double)this.scaleX * ((double)(this.vpX + this.xOffset) + mr.ElementAt(0).doubleValue());
                        double top = (double)this.scaleY * ((double)(this.vpY + this.yOffset) + mr.ElementAt(1).doubleValue());
                        double right = (double)this.scaleX * ((double)(this.vpX + this.xOffset) + mr.ElementAt(2).doubleValue());
                        double bottom = (double)this.scaleY * ((double)(this.vpY + this.yOffset) + mr.ElementAt(3).doubleValue());
                        double xstart = (double)this.scaleX * ((double)(this.vpX + this.xOffset) + mr.ElementAt(4).doubleValue());
                        double ystart = (double)this.scaleY * ((double)(this.vpY + this.yOffset) + mr.ElementAt(5).doubleValue());
                        double xend = (double)this.scaleX * ((double)(this.vpX + this.xOffset) + mr.ElementAt(6).doubleValue());
                        double yend = (double)this.scaleY * ((double)(this.vpY + this.yOffset) + mr.ElementAt(7).doubleValue());
                        this.setBrushPaint(this.currentStore, g2d, brushObject);
                        double cx = left + (right - left) / 2.0;
                        double cy = top + (bottom - top) / 2.0;
                        double startAngle = -(57.29577951308232 * Math.atan2(ystart - cy, xstart - cx));
                        double endAngle = -(57.29577951308232 * Math.atan2(yend - cy, xend - cx));
                        double extentAngle = endAngle - startAngle;
                        if (extentAngle < 0.0) {
                            extentAngle += 360.0;
                        }
                        if (startAngle < 0.0) {
                            startAngle += 360.0;
                        }
                        Arc2D.Double arc = new Arc2D.Double(left, top, right - left, bottom - top, startAngle, extentAngle, 1);
                        this.paint(brushObject, penObject, arc, g2d);
                        this.firstEffectivePaint = false;
                        continue block56;
                    }
                    case 30: {
                        dcStack.push(new Float(penWidth));
                        dcStack.push(new Float(startX));
                        dcStack.push(new Float(startY));
                        dcStack.push(new Integer(brushObject));
                        dcStack.push(new Integer(penObject));
                        dcStack.push(new Integer(fontObject));
                        dcStack.push(this.frgdColor);
                        dcStack.push(this.bkgdColor);
                        continue block56;
                    }
                    case 295: {
                        this.bkgdColor = (Color)dcStack.pop();
                        this.frgdColor = (Color)dcStack.pop();
                        fontObject = (Integer)dcStack.pop();
                        penObject = (Integer)dcStack.pop();
                        brushObject = (Integer)dcStack.pop();
                        startY = ((Float)dcStack.pop()).floatValue();
                        startX = ((Float)dcStack.pop()).floatValue();
                        penWidth = ((Float)dcStack.pop()).floatValue();
                        continue block56;
                    }
                    case 4096: {
                        try {
                            this.setPenColor(this.currentStore, g2d, penObject);
                            int pointCount = mr.ElementAt(0);
                            int bezierCount = (pointCount - 1) / 3;
                            float _startX = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(1).intValue()));
                            float _startY = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(2).intValue()));
                            GeneralPath gp = new GeneralPath(1);
                            gp.moveTo(_startX, _startY);
                            for (int j = 0; j < bezierCount; ++j) {
                                float cp1X = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(j * 6 + 3).intValue()));
                                float cp1Y = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(j * 6 + 4).intValue()));
                                float cp2X = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(j * 6 + 5).intValue()));
                                float cp2Y = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(j * 6 + 6).intValue()));
                                float endX = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(j * 6 + 7).intValue()));
                                float endY = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(j * 6 + 8).intValue()));
                                gp.curveTo(cp1X, cp1Y, cp2X, cp2Y, endX, endY);
                                _startX = endX;
                                _startY = endY;
                            }
                            g2d.setStroke(solid);
                            g2d.draw(gp);
                            this.firstEffectivePaint = false;
                        }
                        catch (Exception e) {}
                        continue block56;
                    }
                    case 259: 
                    case 261: 
                    case 263: 
                    case 264: 
                    case 300: 
                    case 522: 
                    case 544: 
                    case 1045: 
                    case 1046: 
                    case 1049: {
                        continue block56;
                    }
                    case 258: {
                        int mode = mr.ElementAt(0);
                        if (mode == 2) {
                            this.opaque = true;
                            continue block56;
                        }
                        this.opaque = false;
                        continue block56;
                    }
                    case 260: {
                        float rop = mr.ElementAt(0).intValue();
                        Paint paint = null;
                        boolean ok = false;
                        if (rop == 66.0f) {
                            paint = Color.black;
                            ok = true;
                        } else if (rop == 1.6711778E7f) {
                            paint = Color.white;
                            ok = true;
                        } else if (rop == 1.5728673E7f && brushObject >= 0) {
                            paint = this.getStoredPaint(this.currentStore, brushObject);
                            ok = true;
                        }
                        if (!ok) continue block56;
                        if (paint != null) {
                            g2d.setPaint(paint);
                            continue block56;
                        }
                        this.setBrushPaint(this.currentStore, g2d, brushObject);
                        continue block56;
                    }
                    case 1565: {
                        float rop = mr.ElementAt(0).intValue();
                        float height = this.scaleY * (float)mr.ElementAt(1).intValue();
                        float width = this.scaleX * (float)mr.ElementAt(2).intValue();
                        float left = this.scaleX * (this.vpX + (this.xOffset + (float)mr.ElementAt(3).intValue()));
                        float top = this.scaleY * (this.vpY + (this.yOffset + (float)mr.ElementAt(4).intValue()));
                        Paint paint = null;
                        boolean ok = false;
                        if (rop == 66.0f) {
                            paint = Color.black;
                            ok = true;
                        } else if (rop == 1.6711778E7f) {
                            paint = Color.white;
                            ok = true;
                        } else if (rop == 1.5728673E7f && brushObject >= 0) {
                            paint = this.getStoredPaint(this.currentStore, brushObject);
                            ok = true;
                        }
                        if (!ok) continue block56;
                        Color oldClr = g2d.getColor();
                        if (paint != null) {
                            g2d.setPaint(paint);
                        } else {
                            this.setBrushPaint(this.currentStore, g2d, brushObject);
                        }
                        Rectangle2D.Float rec = new Rectangle2D.Float(left, top, width, height);
                        g2d.fill(rec);
                        g2d.setColor(oldClr);
                        continue block56;
                    }
                    case 2881: {
                        int height = mr.ElementAt(1);
                        int width = mr.ElementAt(2);
                        int sy = mr.ElementAt(3);
                        int sx = mr.ElementAt(4);
                        float dy = this.conv * this.currentStore.getVpWFactor() * (this.vpY + this.yOffset + (float)mr.ElementAt(7).intValue());
                        float dx = this.conv * this.currentStore.getVpHFactor() * (this.vpX + this.xOffset + (float)mr.ElementAt(8).intValue());
                        float heightDst = mr.ElementAt(5).intValue();
                        float widthDst = mr.ElementAt(6).intValue();
                        widthDst = widthDst * this.conv * this.currentStore.getVpWFactor();
                        heightDst = heightDst * this.conv * this.currentStore.getVpHFactor();
                        byte[] bitmap = ((MetaRecord.ByteRecord)mr).bstr;
                        BufferedImage img = this.getImage(bitmap, width, height);
                        if (img == null) continue block56;
                        g2d.drawImage(img, (int)dx, (int)dy, (int)(dx + widthDst), (int)(dy + heightDst), sx, sy, sx + width, sy + height, this.bkgdColor, this.observer);
                        continue block56;
                    }
                    case 322: {
                        int objIndex = 0;
                        byte[] bitmap = ((MetaRecord.ByteRecord)mr).bstr;
                        objIndex = this.addObjectAt(this.currentStore, 2, bitmap, objIndex);
                        continue block56;
                    }
                }
            }
        }
    }

    private Paint getPaint(byte[] bit) {
        Dimension d = this.getImageDimension(bit);
        BufferedImage img = this.getImage(bit);
        Rectangle2D.Float rec = new Rectangle2D.Float(0.0f, 0.0f, d.width, d.height);
        TexturePaint paint = new TexturePaint(img, rec);
        return paint;
    }

    private void drawString(int flag, Graphics2D g2d, AttributedCharacterIterator ati, float x, float y, TextLayout layout, WMFFont wmfFont, int align) {
        if (wmfFont.escape == 0) {
            if (flag != -1) {
                this.fillTextBackground(-1, flag, g2d, x, y, 0.0f, layout);
            }
            float width = (float)layout.getBounds().getWidth();
            if (align == 6) {
                g2d.drawString(ati, x - width / 2.0f, y);
            } else if (align == 2) {
                g2d.drawString(ati, x - width, y);
            } else {
                g2d.drawString(ati, x, y);
            }
        } else {
            AffineTransform tr = g2d.getTransform();
            float angle = -((float)((double)wmfFont.escape * Math.PI / 1800.0));
            float width = (float)layout.getBounds().getWidth();
            float height = (float)layout.getBounds().getHeight();
            if (align == 6) {
                g2d.translate(-width / 2.0f, height / 2.0f);
                g2d.rotate(angle, x - width / 2.0f, y);
            } else if (align == 2) {
                g2d.translate(-width / 2.0f, height / 2.0f);
                g2d.rotate(angle, x - width, y);
            } else {
                g2d.translate(0.0, height / 2.0f);
                g2d.rotate(angle, x, y);
            }
            if (flag != -1) {
                this.fillTextBackground(align, flag, g2d, x, y, width, layout);
            }
            Stroke _st = g2d.getStroke();
            g2d.setStroke(textSolid);
            g2d.drawString(ati, x, y);
            g2d.setStroke(_st);
            g2d.setTransform(tr);
        }
    }

    private void fillTextBackground(int align, int flag, Graphics2D g2d, float x, float y, float width, TextLayout layout) {
        float _x = x;
        if (align == 6) {
            _x = x - width / 2.0f;
        } else if (align == 2) {
            _x = x - width;
        }
        if ((flag & 2) != 0) {
            Color c = g2d.getColor();
            AffineTransform tr = g2d.getTransform();
            g2d.setColor(this.bkgdColor);
            g2d.translate(_x, y);
            g2d.fill(layout.getBounds());
            g2d.setColor(c);
            g2d.setTransform(tr);
        } else if (this.opaque) {
            Color c = g2d.getColor();
            AffineTransform tr = g2d.getTransform();
            g2d.setColor(this.bkgdColor);
            g2d.translate(_x, y);
            g2d.fill(layout.getBounds());
            g2d.setColor(c);
            g2d.setTransform(tr);
        }
    }

    private void drawPolyPolygon(Graphics2D g2d, Vector pols) {
        Iterator it = pols.iterator();
        while (it.hasNext()) {
            Polygon2D pol = (Polygon2D)it.next();
            g2d.draw(pol);
        }
    }

    private void fillPolyPolygon(Graphics2D g2d, Vector pols) {
        if (pols.size() == 1) {
            g2d.fill((Polygon2D)pols.get(0));
        } else {
            GeneralPath path = new GeneralPath(0);
            for (int i = 0; i < pols.size(); ++i) {
                Polygon2D pol = (Polygon2D)pols.get(i);
                path.append(pol, false);
            }
            g2d.fill(path);
        }
    }

    private void setStroke(Graphics2D g2d, int penStyle, float penWidth, float scale) {
        float _width = penWidth == 0.0f ? 1.0f : penWidth;
        float _scale = (float)Toolkit.getDefaultToolkit().getScreenResolution() / (float)this.currentStore.getMetaFileUnitsPerInch();
        float factor = scale / _scale;
        _width = _width * _scale * factor;
        _scale = (float)this.currentStore.getWidthPixels() * 1.0f / 350.0f;
        if (penStyle == 0) {
            BasicStroke stroke = new BasicStroke(_width, 0, 1);
            g2d.setStroke(stroke);
        } else if (penStyle == 2) {
            float[] dash = new float[]{1.0f * _scale, 5.0f * _scale};
            BasicStroke stroke = new BasicStroke(_width, 0, 1, 10.0f * _scale, dash, 0.0f);
            g2d.setStroke(stroke);
        } else if (penStyle == 1) {
            float[] dash = new float[]{5.0f * _scale, 2.0f * _scale};
            BasicStroke stroke = new BasicStroke(_width, 0, 1, 10.0f * _scale, dash, 0.0f);
            g2d.setStroke(stroke);
        } else if (penStyle == 3) {
            float[] dash = new float[]{5.0f * _scale, 2.0f * _scale, 1.0f * _scale, 2.0f * _scale};
            BasicStroke stroke = new BasicStroke(_width, 0, 1, 10.0f * _scale, dash, 0.0f);
            g2d.setStroke(stroke);
        } else if (penStyle == 4) {
            float[] dash = new float[]{5.0f * _scale, 2.0f * _scale, 1.0f * _scale, 2.0f * _scale, 1.0f * _scale, 2.0f * _scale};
            BasicStroke stroke = new BasicStroke(_width, 0, 1, 15.0f * _scale, dash, 0.0f);
            g2d.setStroke(stroke);
        } else {
            BasicStroke stroke = new BasicStroke(_width, 0, 1);
            g2d.setStroke(stroke);
        }
    }

    private void setPenColor(WMFRecordStore currentStore, Graphics2D g2d, int penObject) {
        if (penObject >= 0) {
            GdiObject gdiObj = currentStore.getObject(penObject);
            g2d.setColor((Color)gdiObj.obj);
            penObject = -1;
        }
    }

    private int getHorizontalAlignement(int align) {
        int v = align;
        v %= 24;
        if ((v %= 8) >= 6) {
            return 6;
        }
        if (v >= 2) {
            return 2;
        }
        return 0;
    }

    private void setBrushPaint(WMFRecordStore currentStore, Graphics2D g2d, int brushObject) {
        if (brushObject >= 0) {
            GdiObject gdiObj = currentStore.getObject(brushObject);
            if (gdiObj.obj instanceof Color) {
                g2d.setColor((Color)gdiObj.obj);
            } else if (gdiObj.obj instanceof Paint) {
                g2d.setPaint((Paint)gdiObj.obj);
            } else {
                g2d.setPaint(this.getPaint((byte[])gdiObj.obj));
            }
            brushObject = -1;
        }
    }

    private Paint getStoredPaint(WMFRecordStore currentStore, int object) {
        if (object >= 0) {
            GdiObject gdiObj = currentStore.getObject(object);
            if (gdiObj.obj instanceof Paint) {
                return (Paint)gdiObj.obj;
            }
            return this.getPaint((byte[])gdiObj.obj);
        }
        return null;
    }

    private void paint(int brushObject, int penObject, Shape shape, Graphics2D g2d) {
        Paint paint;
        if (brushObject >= 0) {
            paint = this.getStoredPaint(this.currentStore, brushObject);
            if (!this.firstEffectivePaint || !paint.equals(Color.white)) {
                this.setBrushPaint(this.currentStore, g2d, brushObject);
                g2d.fill(shape);
                this.firstEffectivePaint = false;
            }
        }
        if (penObject >= 0) {
            paint = this.getStoredPaint(this.currentStore, penObject);
            if (!this.firstEffectivePaint || !paint.equals(Color.white)) {
                this.setPenColor(this.currentStore, g2d, penObject);
                g2d.draw(shape);
                this.firstEffectivePaint = false;
            }
        }
    }

    private void paintWithPen(int penObject, Shape shape, Graphics2D g2d) {
        if (penObject >= 0) {
            Paint paint = this.getStoredPaint(this.currentStore, penObject);
            if (!this.firstEffectivePaint || !paint.equals(Color.white)) {
                this.setPenColor(this.currentStore, g2d, penObject);
                g2d.draw(shape);
                this.firstEffectivePaint = false;
            }
        }
    }

    public WMFRecordStore getRecordStore() {
        return this.currentStore;
    }
}

