/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFReader;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;

public class WMFRecordStore
extends AbstractWMFReader {
    private transient URL url;
    protected transient int numRecords;
    protected transient float vpX;
    protected transient float vpY;
    protected transient Vector records;
    protected transient boolean bReading = false;
    private transient boolean _bext = true;

    public WMFRecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0.0f;
        this.vpY = 0.0f;
        this.vpW = 1000;
        this.vpH = 1000;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.inch = 0;
        this.records = new Vector(20, 20);
    }

    protected boolean readRecords(DataInputStream is) throws IOException {
        int functionId = 1;
        int recSize = 0;
        this.numRecords = 0;
        while (functionId > 0) {
            recSize = this.readInt(is);
            recSize -= 3;
            functionId = this.readShort(is);
            if (functionId <= 0) break;
            MetaRecord mr = new MetaRecord();
            switch (functionId) {
                case 1583: {
                    for (int i = 0; i < recSize; ++i) {
                        short recData = this.readShort(is);
                    }
                    --this.numRecords;
                    break;
                }
                case 2610: {
                    short yVal = this.readShort(is);
                    short xVal = this.readShort(is);
                    int lenText = this.readShort(is);
                    short flag = this.readShort(is);
                    int read = 4;
                    boolean clipped = false;
                    short x1 = 0;
                    short y1 = 0;
                    short x2 = 0;
                    short y2 = 0;
                    if ((flag & 4) != 0) {
                        x1 = this.readShort(is);
                        y1 = this.readShort(is);
                        x2 = this.readShort(is);
                        y2 = this.readShort(is);
                        read += 4;
                        clipped = true;
                    }
                    byte[] bstr = new byte[lenText];
                    for (int i = 0; i < lenText; ++i) {
                        bstr[i] = is.readByte();
                    }
                    read += (lenText + 1) / 2;
                    if (lenText % 2 != 0) {
                        is.readByte();
                    }
                    if (read < recSize) {
                        for (int j = read; j < recSize; ++j) {
                            this.readShort(is);
                        }
                    }
                    mr = new MetaRecord.ByteRecord(bstr);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(xVal));
                    mr.AddElement(new Integer(yVal));
                    mr.AddElement(new Integer(flag));
                    if (clipped) {
                        mr.AddElement(new Integer(x1));
                        mr.AddElement(new Integer(y1));
                        mr.AddElement(new Integer(x2));
                        mr.AddElement(new Integer(y2));
                    }
                    this.records.addElement(mr);
                    break;
                }
                case 1313: {
                    int j;
                    int i;
                    int len = this.readShort(is);
                    int read = 1;
                    byte[] bstr = new byte[len];
                    for (i = 0; i < len; ++i) {
                        bstr[i] = is.readByte();
                    }
                    if (len % 2 != 0) {
                        is.readByte();
                    }
                    read += (len + 1) / 2;
                    short yVal = this.readShort(is);
                    short xVal = this.readShort(is);
                    if ((read += 2) < recSize) {
                        for (j = read; j < recSize; ++j) {
                            this.readShort(is);
                        }
                    }
                    mr = new MetaRecord.ByteRecord(bstr);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(xVal));
                    mr.AddElement(new Integer(yVal));
                    this.records.addElement(mr);
                    break;
                }
                case 763: {
                    short lfHeight = this.readShort(is);
                    short lfWidth = this.readShort(is);
                    short lfEscapement = this.readShort(is);
                    short lfOrientation = this.readShort(is);
                    short lfWeight = this.readShort(is);
                    byte lfItalic = is.readByte();
                    byte lfUnderline = is.readByte();
                    byte lfStrikeOut = is.readByte();
                    int lfCharSet = is.readByte() & 0xFF;
                    byte lfOutPrecision = is.readByte();
                    byte lfClipPrecision = is.readByte();
                    byte lfQuality = is.readByte();
                    byte lfPitchAndFamily = is.readByte();
                    int len = 2 * (recSize - 9);
                    byte[] lfFaceName = new byte[len];
                    for (int i = 0; i < len; ++i) {
                        lfFaceName[i] = is.readByte();
                    }
                    String str = new String(lfFaceName);
                    mr = new MetaRecord.StringRecord(str);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(lfHeight));
                    mr.AddElement(new Integer(lfItalic));
                    mr.AddElement(new Integer(lfWeight));
                    mr.AddElement(new Integer(lfCharSet));
                    mr.AddElement(new Integer(lfUnderline));
                    mr.AddElement(new Integer(lfStrikeOut));
                    mr.AddElement(new Integer(lfOrientation));
                    mr.AddElement(new Integer(lfEscapement));
                    this.records.addElement(mr);
                    break;
                }
                case 259: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short mode = this.readShort(is);
                    mr.AddElement(new Integer(mode));
                    this.records.addElement(mr);
                    break;
                }
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short height = this.readShort(is);
                    short width = this.readShort(is);
                    mr.AddElement(new Integer(width));
                    mr.AddElement(new Integer(height));
                    this.records.addElement(mr);
                    if (!this._bext || functionId != 524) break;
                    this.vpW = width;
                    this.vpH = height;
                    this._bext = false;
                    break;
                }
                case 527: 
                case 529: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short y = this.readShort(is);
                    short x = this.readShort(is);
                    mr.AddElement(new Integer(x));
                    mr.AddElement(new Integer(y));
                    this.records.addElement(mr);
                    break;
                }
                case 1040: 
                case 1042: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short ydenom = this.readShort(is);
                    short ynum = this.readShort(is);
                    short xdenom = this.readShort(is);
                    short xnum = this.readShort(is);
                    mr.AddElement(new Integer(xdenom));
                    mr.AddElement(new Integer(ydenom));
                    mr.AddElement(new Integer(xnum));
                    mr.AddElement(new Integer(ynum));
                    this.records.addElement(mr);
                    this.scaleX = this.scaleX * (float)xdenom / (float)xnum;
                    this.scaleY = this.scaleY * (float)ydenom / (float)ynum;
                    break;
                }
                case 764: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(this.readShort(is)));
                    int colorref = this.readInt(is);
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    int flags = (colorref & 0x3000000) >> 24;
                    mr.AddElement(new Integer(red));
                    mr.AddElement(new Integer(green));
                    mr.AddElement(new Integer(blue));
                    mr.AddElement(new Integer(this.readShort(is)));
                    this.records.addElement(mr);
                    break;
                }
                case 762: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    Integer style = new Integer(this.readShort(is));
                    mr.AddElement(style);
                    int width = this.readInt(is);
                    int colorref = this.readInt(is);
                    if (recSize == 6) {
                        this.readShort(is);
                    }
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    int flags = (colorref & 0x3000000) >> 24;
                    mr.AddElement(new Integer(red));
                    mr.AddElement(new Integer(green));
                    mr.AddElement(new Integer(blue));
                    mr.AddElement(new Integer(width));
                    this.records.addElement(mr);
                    break;
                }
                case 302: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short align = this.readShort(is);
                    if (recSize > 1) {
                        for (int i = 1; i < recSize; ++i) {
                            this.readShort(is);
                        }
                    }
                    mr.AddElement(new Integer(align));
                    this.records.addElement(mr);
                    break;
                }
                case 513: 
                case 521: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int colorref = this.readInt(is);
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    int flags = (colorref & 0x3000000) >> 24;
                    mr.AddElement(new Integer(red));
                    mr.AddElement(new Integer(green));
                    mr.AddElement(new Integer(blue));
                    this.records.addElement(mr);
                    break;
                }
                case 531: 
                case 532: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short y = this.readShort(is);
                    short x = this.readShort(is);
                    mr.AddElement(new Integer(x));
                    mr.AddElement(new Integer(y));
                    this.records.addElement(mr);
                    break;
                }
                case 262: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short mode = this.readShort(is);
                    if (recSize > 1) {
                        for (int i = 1; i < recSize; ++i) {
                            this.readShort(is);
                        }
                    }
                    mr.AddElement(new Integer(mode));
                    this.records.addElement(mr);
                    break;
                }
                case 1336: {
                    int j;
                    int i;
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int count = this.readShort(is);
                    int[] pts = new int[count];
                    int ptCount = 0;
                    for (i = 0; i < count; ++i) {
                        pts[i] = this.readShort(is);
                        ptCount += pts[i];
                    }
                    mr.AddElement(new Integer(count));
                    for (i = 0; i < count; ++i) {
                        mr.AddElement(new Integer(pts[i]));
                    }
                    int offset = count + 1;
                    for (int i2 = 0; i2 < count; ++i2) {
                        for (j = 0; j < pts[i2]; ++j) {
                            mr.AddElement(new Integer(this.readShort(is)));
                            mr.AddElement(new Integer(this.readShort(is)));
                        }
                    }
                    this.records.addElement(mr);
                    break;
                }
                case 804: 
                case 805: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int count = this.readShort(is);
                    mr.AddElement(new Integer(count));
                    for (int i = 0; i < count; ++i) {
                        mr.AddElement(new Integer(this.readShort(is)));
                        mr.AddElement(new Integer(this.readShort(is)));
                    }
                    this.records.addElement(mr);
                    break;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short bottom = this.readShort(is);
                    short right = this.readShort(is);
                    short top = this.readShort(is);
                    short left = this.readShort(is);
                    mr.AddElement(new Integer(left));
                    mr.AddElement(new Integer(top));
                    mr.AddElement(new Integer(right));
                    mr.AddElement(new Integer(bottom));
                    this.records.addElement(mr);
                    break;
                }
                case 1791: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short left = this.readShort(is);
                    short top = this.readShort(is);
                    short right = this.readShort(is);
                    short bottom = this.readShort(is);
                    mr.AddElement(new Integer(left));
                    mr.AddElement(new Integer(top));
                    mr.AddElement(new Integer(right));
                    mr.AddElement(new Integer(bottom));
                    this.records.addElement(mr);
                    break;
                }
                case 1564: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short el_height = this.readShort(is);
                    short el_width = this.readShort(is);
                    short bottom = this.readShort(is);
                    short right = this.readShort(is);
                    short top = this.readShort(is);
                    short left = this.readShort(is);
                    mr.AddElement(new Integer(left));
                    mr.AddElement(new Integer(top));
                    mr.AddElement(new Integer(right));
                    mr.AddElement(new Integer(bottom));
                    mr.AddElement(new Integer(el_width));
                    mr.AddElement(new Integer(el_height));
                    this.records.addElement(mr);
                    break;
                }
                case 2071: 
                case 2074: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short yend = this.readShort(is);
                    short xend = this.readShort(is);
                    short ystart = this.readShort(is);
                    short xstart = this.readShort(is);
                    short bottom = this.readShort(is);
                    short right = this.readShort(is);
                    short top = this.readShort(is);
                    short left = this.readShort(is);
                    mr.AddElement(new Integer(left));
                    mr.AddElement(new Integer(top));
                    mr.AddElement(new Integer(right));
                    mr.AddElement(new Integer(bottom));
                    mr.AddElement(new Integer(xstart));
                    mr.AddElement(new Integer(ystart));
                    mr.AddElement(new Integer(xend));
                    mr.AddElement(new Integer(yend));
                    this.records.addElement(mr);
                    break;
                }
                case 1565: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int rop = this.readInt(is);
                    short height = this.readShort(is);
                    short width = this.readShort(is);
                    short left = this.readShort(is);
                    short top = this.readShort(is);
                    mr.AddElement(new Integer(rop));
                    mr.AddElement(new Integer(height));
                    mr.AddElement(new Integer(width));
                    mr.AddElement(new Integer(top));
                    mr.AddElement(new Integer(left));
                    this.records.addElement(mr);
                    break;
                }
                case 258: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short mode = this.readShort(is);
                    mr.AddElement(new Integer(mode));
                    if (recSize > 1) {
                        for (int i = 1; i < recSize; ++i) {
                            this.readShort(is);
                        }
                    }
                    this.records.addElement(mr);
                    break;
                }
                case 260: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int rop = recSize == 1 ? this.readShort(is) : this.readInt(is);
                    mr.AddElement(new Integer(rop));
                    this.records.addElement(mr);
                    break;
                }
                case 2881: {
                    int mode = is.readInt() & 0xFF;
                    short heightSrc = this.readShort(is);
                    short widthSrc = this.readShort(is);
                    short sy = this.readShort(is);
                    short sx = this.readShort(is);
                    short heightDst = this.readShort(is);
                    short widthDst = this.readShort(is);
                    short dy = this.readShort(is);
                    short dx = this.readShort(is);
                    int len = 2 * recSize - 20;
                    byte[] bitmap = new byte[len];
                    for (int i = 0; i < len; ++i) {
                        bitmap[i] = is.readByte();
                    }
                    mr = new MetaRecord.ByteRecord(bitmap);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(mode));
                    mr.AddElement(new Integer(heightSrc));
                    mr.AddElement(new Integer(widthSrc));
                    mr.AddElement(new Integer(sy));
                    mr.AddElement(new Integer(sx));
                    mr.AddElement(new Integer(heightDst));
                    mr.AddElement(new Integer(widthDst));
                    mr.AddElement(new Integer(dy));
                    mr.AddElement(new Integer(dx));
                    this.records.addElement(mr);
                    break;
                }
                case 322: {
                    int i;
                    int type = is.readInt() & 0xFF;
                    int len = 2 * recSize - 4;
                    byte[] bitmap = new byte[len];
                    for (i = 0; i < len; ++i) {
                        bitmap[i] = is.readByte();
                    }
                    mr = new MetaRecord.ByteRecord(bitmap);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(type));
                    this.records.addElement(mr);
                    break;
                }
                default: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    for (int j = 0; j < recSize; ++j) {
                        mr.AddElement(new Integer(this.readShort(is)));
                    }
                    this.records.addElement(mr);
                }
            }
            ++this.numRecords;
        }
        this.setReading(false);
        return true;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL newUrl) {
        this.url = newUrl;
    }

    public MetaRecord getRecord(int idx) {
        return (MetaRecord)this.records.elementAt(idx);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public float getVpX() {
        return this.vpX;
    }

    public float getVpY() {
        return this.vpY;
    }

    public void setVpX(float newValue) {
        this.vpX = newValue;
    }

    public void setVpY(float newValue) {
        this.vpY = newValue;
    }
}

