/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.bean;

import java.util.AbstractList;
import org.dom4j.Attribute;
import org.dom4j.QName;
import org.dom4j.bean.BeanAttribute;
import org.dom4j.bean.BeanElement;
import org.dom4j.bean.BeanMetaData;

public class BeanAttributeList
extends AbstractList {
    private BeanElement parent;
    private BeanMetaData beanMetaData;
    private BeanAttribute[] attributes;

    public BeanAttributeList(BeanElement parent) {
        this.parent = parent;
        Object data = parent.getData();
        Class<?> beanClass = data != null ? data.getClass() : null;
        this.beanMetaData = BeanMetaData.get(beanClass);
        this.attributes = new BeanAttribute[this.beanMetaData.attributeCount()];
    }

    public BeanAttributeList(BeanElement parent, BeanMetaData beanMetaData) {
        this.parent = parent;
        this.beanMetaData = beanMetaData;
        this.attributes = new BeanAttribute[beanMetaData.attributeCount()];
    }

    public void add(int index, Object object) {
        throw new UnsupportedOperationException("add(int, Object) is not supported");
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException("add(int, Object) is not supported");
    }

    public BeanAttribute attribute(int index) {
        if (index >= 0 && index <= this.attributes.length) {
            BeanAttribute attribute2 = this.attributes[index];
            if (attribute2 == null) {
                this.attributes[index] = attribute2 = this.createAttribute(this.parent, index);
            }
            return attribute2;
        }
        return null;
    }

    public Attribute attribute(String name) {
        int index = this.beanMetaData.getIndex(name);
        return this.attribute(index);
    }

    public Attribute attribute(QName qname) {
        int index = this.beanMetaData.getIndex(qname);
        return this.attribute(index);
    }

    public void clear() {
        int i = 0;
        int size = this.attributes.length;
        while (i < size) {
            BeanAttribute attribute2 = this.attributes[i];
            if (attribute2 != null) {
                attribute2.setValue(null);
            }
            ++i;
        }
    }

    protected BeanAttribute createAttribute(BeanElement parent, int index) {
        return new BeanAttribute(this, index);
    }

    public Object get(int index) {
        BeanAttribute attribute2 = this.attributes[index];
        if (attribute2 == null) {
            this.attributes[index] = attribute2 = this.createAttribute(this.parent, index);
        }
        return attribute2;
    }

    public Object getData(int index) {
        return this.beanMetaData.getData(index, this.parent.getData());
    }

    public BeanElement getParent() {
        return this.parent;
    }

    public QName getQName(int index) {
        return this.beanMetaData.getQName(index);
    }

    public Object remove(int index) {
        BeanAttribute attribute2 = (BeanAttribute)this.get(index);
        String oldValue = attribute2.getValue();
        attribute2.setValue(null);
        return oldValue;
    }

    public boolean remove(Object object) {
        return false;
    }

    public Object set(int index, Object object) {
        throw new UnsupportedOperationException("set(int, Object) is not supported");
    }

    public void setData(int index, Object data) {
        this.beanMetaData.setData(index, this.parent.getData(), data);
    }

    public int size() {
        return this.attributes.length;
    }
}

