/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dom;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMAttributeNodeMap;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMNodeHelper;
import org.dom4j.tree.DefaultElement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMElement
extends DefaultElement
implements Element {
    private static final DocumentFactory DOCUMENT_FACTORY = DOMDocumentFactory.getInstance();

    public DOMElement(String name) {
        super(name);
    }

    public DOMElement(String name, Namespace namespace) {
        super(name, namespace);
    }

    public DOMElement(QName qname) {
        super(qname);
    }

    public DOMElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return DOMNodeHelper.appendChild(this, newChild);
    }

    protected Attribute attribute(String namespaceURI, String localName) {
        List attributes = this.attributeList();
        int size = attributes.size();
        int i = 0;
        while (i < size) {
            Attribute attribute2 = (Attribute)attributes.get(i);
            if (localName.equals(attribute2.getName()) && namespaceURI.equals(attribute2.getNamespaceURI())) {
                return attribute2;
            }
            ++i;
        }
        return null;
    }

    protected Attribute attribute(Attr attr) {
        return this.attribute(DOCUMENT_FACTORY.createQName(attr.getLocalName(), attr.getPrefix(), attr.getNamespaceURI()));
    }

    public Node cloneNode(boolean deep) {
        return DOMNodeHelper.cloneNode(this, deep);
    }

    protected Attribute createAttribute(Attr newAttr) {
        Namespace namespace;
        QName qname = null;
        String name = newAttr.getLocalName();
        String uri = newAttr.getNamespaceURI();
        if (uri != null && uri.length() > 0 && (namespace = this.getNamespaceForURI(uri)) != null) {
            qname = DOCUMENT_FACTORY.createQName(name, namespace);
        }
        if (qname == null) {
            qname = DOCUMENT_FACTORY.createQName(name);
        }
        return new DOMAttribute(qname, newAttr.getValue());
    }

    public String getAttribute(String name) {
        String answer = this.attributeValue(name);
        return answer != null ? answer : "";
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        String answer;
        Attribute attribute2 = this.attribute(namespaceURI, localName);
        if (attribute2 != null && (answer = attribute2.getValue()) != null) {
            return answer;
        }
        return "";
    }

    public Attr getAttributeNode(String name) {
        return DOMNodeHelper.asDOMAttr(this.attribute(name));
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        Attribute attribute2 = this.attribute(namespaceURI, localName);
        if (attribute2 != null) {
            DOMNodeHelper.asDOMAttr(attribute2);
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        return new DOMAttributeNodeMap(this);
    }

    public NodeList getChildNodes() {
        return DOMNodeHelper.createNodeList(this.content());
    }

    protected DocumentFactory getDocumentFactory() {
        DocumentFactory factory = this.getQName().getDocumentFactory();
        return factory != null ? factory : DOCUMENT_FACTORY;
    }

    public NodeList getElementsByTagName(String name) {
        ArrayList list = new ArrayList();
        DOMNodeHelper.appendElementsByTagName(list, this, name);
        return DOMNodeHelper.createNodeList(list);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        ArrayList list = new ArrayList();
        DOMNodeHelper.appendElementsByTagNameNS(list, this, namespaceURI, localName);
        return DOMNodeHelper.createNodeList(list);
    }

    public Node getFirstChild() {
        return DOMNodeHelper.asDOMNode(this.node(0));
    }

    public Node getLastChild() {
        return DOMNodeHelper.asDOMNode(this.node(this.nodeCount() - 1));
    }

    public String getLocalName() {
        return this.getQName().getName();
    }

    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    public Node getNextSibling() {
        return DOMNodeHelper.getNextSibling(this);
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() throws DOMException {
        return DOMNodeHelper.getNodeValue(this);
    }

    public Document getOwnerDocument() {
        return DOMNodeHelper.getOwnerDocument(this);
    }

    public Node getParentNode() {
        return DOMNodeHelper.getParentNode(this);
    }

    public String getPrefix() {
        return this.getQName().getNamespacePrefix();
    }

    public Node getPreviousSibling() {
        return DOMNodeHelper.getPreviousSibling(this);
    }

    protected QName getQName(String namespaceURI, String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        String prefix = "";
        String localName = qualifiedName;
        if (index >= 0) {
            prefix = qualifiedName.substring(0, index);
            localName = qualifiedName.substring(index + 1);
        }
        return DOCUMENT_FACTORY.createQName(localName, prefix, namespaceURI);
    }

    public String getTagName() {
        return this.getName();
    }

    public boolean hasAttribute(String name) {
        return this.attribute(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.attribute(namespaceURI, localName) != null;
    }

    public boolean hasAttributes() {
        return DOMNodeHelper.hasAttributes(this);
    }

    public boolean hasChildNodes() {
        return this.nodeCount() > 0;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return DOMNodeHelper.insertBefore(this, newChild, refChild);
    }

    public boolean isSupported(String feature, String version) {
        return DOMNodeHelper.isSupported(this, feature, version);
    }

    public void removeAttribute(String name) throws DOMException {
        Attribute attribute2 = this.attribute(name);
        if (attribute2 != null) {
            this.remove(attribute2);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attribute attribute2 = this.attribute(namespaceURI, localName);
        if (attribute2 != null) {
            this.remove(attribute2);
        }
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        Attribute attribute2 = this.attribute(oldAttr);
        if (attribute2 != null) {
            attribute2.detach();
            return DOMNodeHelper.asDOMAttr(attribute2);
        }
        throw new DOMException(8, "No such attribute");
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return DOMNodeHelper.removeChild(this, oldChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return DOMNodeHelper.replaceChild(this, newChild, oldChild);
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.addAttribute(name, value);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        Attribute attribute2 = this.attribute(namespaceURI, qualifiedName);
        if (attribute2 != null) {
            attribute2.setValue(value);
        } else {
            QName qname = this.getQName(namespaceURI, qualifiedName);
            this.addAttribute(qname, value);
        }
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        Attribute attribute2 = this.attribute(newAttr);
        if (attribute2 != null) {
            attribute2.setValue(newAttr.getValue());
        } else {
            attribute2 = this.createAttribute(newAttr);
            this.add(attribute2);
        }
        return DOMNodeHelper.asDOMAttr(attribute2);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        Attribute attribute2 = this.attribute(newAttr.getNamespaceURI(), newAttr.getLocalName());
        if (attribute2 != null) {
            attribute2.setValue(newAttr.getValue());
        } else {
            attribute2 = this.createAttribute(newAttr);
            this.add(attribute2);
        }
        return DOMNodeHelper.asDOMAttr(attribute2);
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        DOMNodeHelper.setNodeValue(this, nodeValue);
    }

    public void setPrefix(String prefix) throws DOMException {
        DOMNodeHelper.setPrefix(this, prefix);
    }
}

