/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.JAXPHelper;
import org.dom4j.io.SAXHelper;
import org.dom4j.tree.NamespaceStack;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;

public class DOMWriter {
    private static boolean loggedWarning = false;
    private static final String[] DEFAULT_DOM_DOCUMENT_CLASSES = new String[]{"org.apache.xerces.dom.DocumentImpl", "org.apache.crimson.tree.XmlDocument", "com.sun.xml.tree.XmlDocument", "oracle.xml.parser.v2.XMLDocument", "oracle.xml.parser.XMLDocument"};
    private Class domDocumentClass;
    private NamespaceStack namespaceStack = new NamespaceStack();
    static /* synthetic */ Class class$org$dom4j$io$DOMWriter;

    public DOMWriter() {
    }

    public DOMWriter(Class domDocumentClass) {
        this.domDocumentClass = domDocumentClass;
    }

    protected void appendDOMTree(org.w3c.dom.Document domDocument, Node domCurrent, String text) {
        org.w3c.dom.Text domText = domDocument.createTextNode(text);
        domCurrent.appendChild(domText);
    }

    protected void appendDOMTree(org.w3c.dom.Document domDocument, Node domCurrent, List content) {
        int size = content.size();
        int i = 0;
        while (i < size) {
            Object object = content.get(i);
            if (object instanceof Element) {
                this.appendDOMTree(domDocument, domCurrent, (Element)object);
            } else if (object instanceof String) {
                this.appendDOMTree(domDocument, domCurrent, (String)object);
            } else if (object instanceof Text) {
                Text text = (Text)object;
                this.appendDOMTree(domDocument, domCurrent, text.getText());
            } else if (object instanceof CDATA) {
                this.appendDOMTree(domDocument, domCurrent, (CDATA)object);
            } else if (object instanceof Comment) {
                this.appendDOMTree(domDocument, domCurrent, (Comment)object);
            } else if (object instanceof Entity) {
                this.appendDOMTree(domDocument, domCurrent, (Entity)object);
            } else if (object instanceof ProcessingInstruction) {
                this.appendDOMTree(domDocument, domCurrent, (ProcessingInstruction)object);
            }
            ++i;
        }
    }

    protected void appendDOMTree(org.w3c.dom.Document domDocument, Node domCurrent, CDATA cdata) {
        CDATASection domCDATA = domDocument.createCDATASection(cdata.getText());
        domCurrent.appendChild(domCDATA);
    }

    protected void appendDOMTree(org.w3c.dom.Document domDocument, Node domCurrent, Comment comment) {
        org.w3c.dom.Comment domComment = domDocument.createComment(comment.getText());
        domCurrent.appendChild(domComment);
    }

    protected void appendDOMTree(org.w3c.dom.Document domDocument, Node domCurrent, Element element) {
        org.w3c.dom.Element domElement = null;
        String elementUri = element.getNamespaceURI();
        domElement = elementUri != null && elementUri.length() > 0 ? domDocument.createElementNS(elementUri, element.getQualifiedName()) : domDocument.createElement(element.getQualifiedName());
        int stackSize = this.namespaceStack.size();
        List declaredNamespaces = element.declaredNamespaces();
        int i = 0;
        int size = declaredNamespaces.size();
        while (i < size) {
            Namespace namespace = (Namespace)declaredNamespaces.get(i);
            if (this.isNamespaceDeclaration(namespace)) {
                this.namespaceStack.push(namespace);
                this.writeNamespace(domElement, namespace);
            }
            ++i;
        }
        int i2 = 0;
        int size2 = element.attributeCount();
        while (i2 < size2) {
            Attribute attribute2 = element.attribute(i2);
            String uri = attribute2.getNamespaceURI();
            if (uri != null && uri.length() > 0) {
                domElement.setAttributeNS(uri, attribute2.getQualifiedName(), attribute2.getValue());
            } else {
                domElement.setAttribute(attribute2.getName(), attribute2.getValue());
            }
            ++i2;
        }
        this.appendDOMTree(domDocument, (Node)domElement, element.content());
        domCurrent.appendChild(domElement);
        while (this.namespaceStack.size() > stackSize) {
            this.namespaceStack.pop();
        }
    }

    protected void appendDOMTree(org.w3c.dom.Document domDocument, Node domCurrent, Entity entity) {
        EntityReference domEntity = domDocument.createEntityReference(entity.getName());
        domCurrent.appendChild(domEntity);
    }

    protected void appendDOMTree(org.w3c.dom.Document domDocument, Node domCurrent, ProcessingInstruction pi) {
        org.w3c.dom.ProcessingInstruction domPI = domDocument.createProcessingInstruction(pi.getTarget(), pi.getText());
        domCurrent.appendChild(domPI);
    }

    protected String attributeNameForNamespace(Namespace namespace) {
        String xmlns = "xmlns";
        String prefix = namespace.getPrefix();
        if (prefix.length() > 0) {
            return String.valueOf(xmlns) + ":" + prefix;
        }
        return xmlns;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected org.w3c.dom.Document createDomDocument(Document document) throws DocumentException {
        org.w3c.dom.Document answer = this.createDomDocumentViaJAXP();
        if (answer != null) {
            return answer;
        }
        Class theClass = this.getDomDocumentClass();
        try {
            return (org.w3c.dom.Document)theClass.newInstance();
        }
        catch (Exception e) {
            throw new DocumentException("Could not instantiate an instance of DOM Document wtih class: " + theClass.getName(), e);
        }
    }

    protected org.w3c.dom.Document createDomDocument(Document document, DOMImplementation domImplementation) throws DocumentException {
        String namespaceURI = null;
        String qualifiedName = null;
        DocumentType docType = null;
        return domImplementation.createDocument(namespaceURI, qualifiedName, docType);
    }

    protected org.w3c.dom.Document createDomDocumentViaJAXP() throws DocumentException {
        if (!SAXHelper.classNameAvailable("javax.xml.parsers.DocumentBuilderFactory")) {
            return null;
        }
        try {
            return JAXPHelper.createDocument(false, true);
        }
        catch (Throwable e) {
            if (!loggedWarning) {
                loggedWarning = true;
                if (SAXHelper.isVerboseErrorReporting()) {
                    System.out.println("Warning: Caught exception attempting to use JAXP to create a W3C DOM document");
                    System.out.println("Warning: Exception was: " + e);
                    e.printStackTrace();
                } else {
                    System.out.println("Warning: Error occurred using JAXP to create a DOM document.");
                }
            }
            return null;
        }
    }

    public Class getDomDocumentClass() throws DocumentException {
        if (this.domDocumentClass == null) {
            int size = DEFAULT_DOM_DOCUMENT_CLASSES.length;
            int i = 0;
            while (i < size) {
                try {
                    String name = DEFAULT_DOM_DOCUMENT_CLASSES[i];
                    this.domDocumentClass = Class.forName(name, true, (class$org$dom4j$io$DOMWriter != null ? class$org$dom4j$io$DOMWriter : DOMWriter.class$("org.dom4j.io.DOMWriter")).getClassLoader());
                    if (this.domDocumentClass != null) {
                        break;
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        return this.domDocumentClass;
    }

    protected boolean isNamespaceDeclaration(Namespace ns) {
        String uri;
        return ns != null && ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE && (uri = ns.getURI()) != null && uri.length() > 0 && !this.namespaceStack.contains(ns);
    }

    protected void resetNamespaceStack() {
        this.namespaceStack.clear();
        this.namespaceStack.push(Namespace.XML_NAMESPACE);
    }

    public void setDomDocumentClass(Class domDocumentClass) {
        this.domDocumentClass = domDocumentClass;
    }

    public void setDomDocumentClassName(String className) throws DocumentException {
        try {
            this.domDocumentClass = Class.forName(className, true, (class$org$dom4j$io$DOMWriter != null ? class$org$dom4j$io$DOMWriter : (class$org$dom4j$io$DOMWriter = DOMWriter.class$("org.dom4j.io.DOMWriter"))).getClassLoader());
        }
        catch (Exception e) {
            throw new DocumentException("Could not load the DOM Document class: " + className, e);
        }
    }

    public org.w3c.dom.Document write(Document document) throws DocumentException {
        if (document instanceof org.w3c.dom.Document) {
            return (org.w3c.dom.Document)((Object)document);
        }
        this.resetNamespaceStack();
        org.w3c.dom.Document domDocument = this.createDomDocument(document);
        this.appendDOMTree(domDocument, (Node)domDocument, document.content());
        this.namespaceStack.clear();
        return domDocument;
    }

    public org.w3c.dom.Document write(Document document, DOMImplementation domImplementation) throws DocumentException {
        if (document instanceof org.w3c.dom.Document) {
            return (org.w3c.dom.Document)((Object)document);
        }
        this.resetNamespaceStack();
        org.w3c.dom.Document domDocument = this.createDomDocument(document, domImplementation);
        this.appendDOMTree(domDocument, (Node)domDocument, document.content());
        this.namespaceStack.clear();
        return domDocument;
    }

    protected void writeNamespace(org.w3c.dom.Element domElement, Namespace namespace) {
        String attributeName = this.attributeNameForNamespace(namespace);
        domElement.setAttribute(attributeName, namespace.getURI());
    }
}

