/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.OutputFormat;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl
implements LexicalHandler {
    protected static final String[] LEXICAL_HANDLER_NAMES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler"};
    private static final boolean ESCAPE_TEXT = true;
    private static final boolean SUPPORT_PAD_TEXT = false;
    protected static final OutputFormat DEFAULT_FORMAT = new OutputFormat();
    protected int lastOutputNodeType;
    protected Writer writer;
    private NamespaceStack namespaceStack = new NamespaceStack();
    private OutputFormat format;
    private int indentLevel = 0;
    private StringBuffer buffer = new StringBuffer();
    private boolean autoFlush;
    private LexicalHandler lexicalHandler;
    private boolean showCommentsInDTDs;
    private boolean inDTD;

    public XMLWriter() {
        this.format = DEFAULT_FORMAT;
        this.writer = new BufferedWriter(new OutputStreamWriter(System.out));
        this.autoFlush = true;
    }

    public XMLWriter(OutputStream out) throws UnsupportedEncodingException {
        this.format = DEFAULT_FORMAT;
        this.writer = this.createWriter(out, this.format.getEncoding());
        this.autoFlush = true;
    }

    public XMLWriter(OutputStream out, OutputFormat format) throws UnsupportedEncodingException {
        this.format = format;
        this.writer = this.createWriter(out, format.getEncoding());
        this.autoFlush = true;
    }

    public XMLWriter(Writer writer) {
        this(writer, DEFAULT_FORMAT);
    }

    public XMLWriter(Writer writer, OutputFormat format) {
        this.writer = writer;
        this.format = format;
    }

    public XMLWriter(OutputFormat format) throws UnsupportedEncodingException {
        this.format = format;
        this.writer = this.createWriter(System.out, format.getEncoding());
        this.autoFlush = true;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.write(new String(ch, start, length));
            super.characters(ch, start, length);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.showCommentsInDTDs || !this.inDTD) {
            try {
                this.writeComment(new String(ch, start, length));
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    protected Writer createWriter(OutputStream outStream, String encoding) throws UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter(outStream, encoding));
    }

    public void endCDATA() throws SAXException {
        try {
            this.writer.write("]]>");
        }
        catch (IOException e) {
            this.handleException(e);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            boolean hadContent;
            --this.indentLevel;
            if (this.lastOutputNodeType == 1) {
                this.writePrintln();
                this.indent();
            }
            if (hadContent = true) {
                this.writeClose(qName);
            } else {
                this.writeEmptyElementClose(qName);
            }
            this.lastOutputNodeType = 1;
            super.endElement(namespaceURI, localName, qName);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    protected String escapeAttributeEntities(String text) {
        char[] block = null;
        int last = 0;
        int size = text.length();
        int i = 0;
        while (i < size) {
            String entity = null;
            switch (text.charAt(i)) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\'': {
                    entity = "&apos;";
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
            }
            if (entity != null) {
                if (block == null) {
                    block = text.toCharArray();
                }
                this.buffer.append(block, last, i - last);
                this.buffer.append(entity);
                last = i + 1;
            }
            ++i;
        }
        if (last == 0) {
            return text;
        }
        if (last < size) {
            if (block == null) {
                block = text.toCharArray();
            }
            this.buffer.append(block, last, i - last);
        }
        String answer = this.buffer.toString();
        this.buffer.setLength(0);
        return answer;
    }

    protected String escapeElementEntities(String text) {
        char[] block = null;
        int last = 0;
        int size = text.length();
        int i = 0;
        while (i < size) {
            String entity = null;
            switch (text.charAt(i)) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
            }
            if (entity != null) {
                if (block == null) {
                    block = text.toCharArray();
                }
                this.buffer.append(block, last, i - last);
                this.buffer.append(entity);
                last = i + 1;
            }
            ++i;
        }
        if (last == 0) {
            return text;
        }
        if (last < size) {
            if (block == null) {
                block = text.toCharArray();
            }
            this.buffer.append(block, last, i - last);
        }
        String answer = this.buffer.toString();
        this.buffer.setLength(0);
        return answer;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    protected String getPadText() {
        return null;
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        int i = 0;
        while (i < LEXICAL_HANDLER_NAMES.length) {
            if (LEXICAL_HANDLER_NAMES[i].equals(name)) {
                return this.getLexicalHandler();
            }
            ++i;
        }
        return super.getProperty(name);
    }

    protected void handleException(IOException e) throws SAXException {
        throw new SAXException(e);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    protected void indent() throws IOException {
        String indent = this.format.getIndent();
        if (indent != null && indent.length() > 0) {
            int i = 0;
            while (i < this.indentLevel) {
                this.writer.write(indent);
                ++i;
            }
        }
    }

    protected void installLexicalHandler() {
        XMLReader parent = this.getParent();
        if (parent == null) {
            throw new NullPointerException("No parent for filter");
        }
        int i = 0;
        while (i < LEXICAL_HANDLER_NAMES.length) {
            try {
                parent.setProperty(LEXICAL_HANDLER_NAMES[i], this);
                break;
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
            ++i;
        }
    }

    protected boolean isExpandEmptyElements() {
        return this.format.isExpandEmptyElements();
    }

    protected boolean isNamespaceDeclaration(Namespace ns) {
        String uri;
        return ns != null && ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE && (uri = ns.getURI()) != null && uri.length() > 0 && !this.namespaceStack.contains(ns);
    }

    public void notationDecl(String name, String publicID, String systemID) throws SAXException {
        super.notationDecl(name, publicID, systemID);
    }

    public void parse(InputSource source) throws IOException, SAXException {
        this.installLexicalHandler();
        super.parse(source);
    }

    public void println() throws IOException {
        this.writer.write(this.format.getLineSeparator());
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.indent();
            this.writer.write("<?");
            this.writer.write(target);
            this.writer.write(" ");
            this.writer.write(data);
            this.writer.write("?>");
            this.writePrintln();
            this.lastOutputNodeType = 7;
            super.processingInstruction(target, data);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
    }

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null lexical handler");
        }
        this.lexicalHandler = handler;
    }

    public void setOutputStream(OutputStream out) throws UnsupportedEncodingException {
        this.writer = this.createWriter(out, this.format.getEncoding());
        this.autoFlush = true;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        int i = 0;
        while (i < LEXICAL_HANDLER_NAMES.length) {
            if (LEXICAL_HANDLER_NAMES[i].equals(name)) {
                this.setLexicalHandler((LexicalHandler)value);
                return;
            }
            ++i;
        }
        super.setProperty(name, value);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
        this.autoFlush = false;
    }

    public void startCDATA() throws SAXException {
        try {
            this.writer.write("<![CDATA[");
        }
        catch (IOException e) {
            this.handleException(e);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void startDTD(String name, String publicID, String systemID) throws SAXException {
        this.inDTD = true;
        try {
            this.writeDocType(name, publicID, systemID);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicID, systemID);
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.writeDeclaration();
            super.startDocument();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.writePrintln();
            this.indent();
            this.writer.write("<");
            this.writer.write(qName);
            this.writeAttributes(attributes);
            this.writer.write(">");
            ++this.indentLevel;
            this.lastOutputNodeType = 1;
            super.startElement(namespaceURI, localName, qName, attributes);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void startEntity(String name) throws SAXException {
        try {
            this.writeEntityRef(name);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
    }

    public void unparsedEntityDecl(String name, String publicID, String systemID, String notationName) throws SAXException {
        super.unparsedEntityDecl(name, publicID, systemID, notationName);
    }

    public void write(Object object) throws IOException {
        if (object instanceof Node) {
            this.write((Node)object);
        } else if (object instanceof String) {
            this.write((String)object);
        } else if (object instanceof List) {
            List list = (List)object;
            int i = 0;
            int size = list.size();
            while (i < size) {
                this.write(list.get(i));
                ++i;
            }
        } else if (object != null) {
            throw new IOException("Invalid object: " + object);
        }
    }

    public void write(String text) throws IOException {
        this.writeString(text);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Attribute attribute2) throws IOException {
        this.writeAttribute(attribute2);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(CDATA cdata) throws IOException {
        this.writeCDATA(cdata.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Comment comment) throws IOException {
        this.writeComment(comment.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Document doc) throws IOException {
        this.writeDeclaration();
        if (doc.getDocType() != null) {
            this.indent();
            this.writeDocType(doc.getDocType());
        }
        int i = 0;
        int size = doc.nodeCount();
        while (i < size) {
            Node node = doc.node(i);
            this.writeNode(node);
            ++i;
        }
        this.writePrintln();
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(DocumentType docType) throws IOException {
        this.writeDocType(docType);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Element element) throws IOException {
        this.writeElement(element);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Entity entity) throws IOException {
        this.writeEntity(entity);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Namespace namespace) throws IOException {
        this.writeNamespace(namespace);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Node node) throws IOException {
        this.writeNode(node);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(ProcessingInstruction processingInstruction) throws IOException {
        this.writeProcessingInstruction(processingInstruction);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Text text) throws IOException {
        this.writeString(text.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    protected void writeAttribute(Attribute attribute2) throws IOException {
        this.writer.write(" ");
        this.writer.write(attribute2.getQualifiedName());
        this.writer.write("=");
        this.writer.write("\"");
        this.writeEscapeAttributeEntities(attribute2.getValue());
        this.writer.write("\"");
        this.lastOutputNodeType = 2;
    }

    protected void writeAttribute(Attributes attributes, int index) throws IOException {
        this.writer.write(" ");
        this.writer.write(attributes.getQName(index));
        this.writer.write("=\"");
        this.writeEscapeAttributeEntities(attributes.getValue(index));
        this.writer.write("\"");
    }

    protected void writeAttributes(Element element) throws IOException {
        int i = 0;
        int size = element.attributeCount();
        while (i < size) {
            Attribute attribute2 = element.attribute(i);
            Namespace ns = attribute2.getNamespace();
            if (ns != null && ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE) {
                String prefix = ns.getPrefix();
                String uri = this.namespaceStack.getURI(prefix);
                if (!ns.getURI().equals(uri)) {
                    this.writeNamespace(ns);
                    this.namespaceStack.push(ns);
                }
            }
            this.writer.write(" ");
            this.writer.write(attribute2.getQualifiedName());
            this.writer.write("=\"");
            this.writeEscapeAttributeEntities(attribute2.getValue());
            this.writer.write("\"");
            ++i;
        }
    }

    protected void writeAttributes(Attributes attributes) throws IOException {
        int i = 0;
        int size = attributes.getLength();
        while (i < size) {
            this.writeAttribute(attributes, i);
            ++i;
        }
    }

    protected void writeCDATA(String text) throws IOException {
        this.writer.write("<![CDATA[");
        this.writer.write(text);
        this.writer.write("]]>");
        this.lastOutputNodeType = 4;
    }

    protected void writeClose(String qualifiedName) throws IOException {
        this.writer.write("</");
        this.writer.write(qualifiedName);
        this.writer.write(">");
    }

    public void writeClose(Element element) throws IOException {
        this.writeClose(element.getQualifiedName());
    }

    protected void writeComment(String text) throws IOException {
        if (this.format.isNewlines()) {
            if (this.lastOutputNodeType != 8) {
                this.println();
            }
            this.indent();
        }
        this.writer.write("<!--");
        this.writer.write(text);
        this.writer.write("-->");
        this.writePrintln();
        this.lastOutputNodeType = 8;
    }

    protected void writeDeclaration() throws IOException {
        String encoding = this.format.getEncoding();
        if (!this.format.isSuppressDeclaration()) {
            if (encoding.equals("UTF8")) {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"UTF-8\"");
                }
                this.writer.write("?>");
            } else {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"" + encoding + "\"");
                }
                this.writer.write("?>");
            }
            this.println();
        }
    }

    protected void writeDocType(String name, String publicID, String systemID) throws IOException {
        boolean hasPublic = false;
        this.writer.write("<!DOCTYPE ");
        this.writer.write(name);
        if (publicID != null && !publicID.equals("")) {
            this.writer.write(" PUBLIC \"");
            this.writer.write(publicID);
            this.writer.write("\"");
            hasPublic = true;
        }
        if (systemID != null && !systemID.equals("")) {
            if (!hasPublic) {
                this.writer.write(" SYSTEM");
            }
            this.writer.write(" \"");
            this.writer.write(systemID);
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writePrintln();
    }

    protected void writeDocType(DocumentType docType) throws IOException {
        if (docType != null) {
            docType.write(this.writer);
            this.writePrintln();
        }
    }

    protected void writeElement(Element element) throws IOException {
        int size = element.nodeCount();
        String qualifiedName = element.getQualifiedName();
        this.writePrintln();
        this.indent();
        this.writer.write("<");
        this.writer.write(qualifiedName);
        int previouslyDeclaredNamespaces = this.namespaceStack.size();
        Namespace ns = element.getNamespace();
        if (this.isNamespaceDeclaration(ns)) {
            this.namespaceStack.push(ns);
            this.writeNamespace(ns);
        }
        boolean textOnly = true;
        int i = 0;
        while (i < size) {
            Node node = element.node(i);
            if (node instanceof Namespace) {
                Namespace additional = (Namespace)node;
                if (this.isNamespaceDeclaration(additional)) {
                    this.namespaceStack.push(additional);
                    this.writeNamespace(additional);
                }
            } else if (node instanceof Element) {
                textOnly = false;
            }
            ++i;
        }
        this.writeAttributes(element);
        this.lastOutputNodeType = 1;
        if (size <= 0) {
            this.writeEmptyElementClose(qualifiedName);
        } else {
            this.writer.write(">");
            if (textOnly) {
                this.writeElementContent(element);
            } else {
                ++this.indentLevel;
                this.writeElementContent(element);
                --this.indentLevel;
                this.writePrintln();
                this.indent();
            }
            this.writer.write("</");
            this.writer.write(qualifiedName);
            this.writer.write(">");
        }
        while (this.namespaceStack.size() > previouslyDeclaredNamespaces) {
            this.namespaceStack.pop();
        }
        this.lastOutputNodeType = 1;
    }

    protected void writeElementContent(Element element) throws IOException {
        if (this.format.isTrimText()) {
            Node lastTextNode = null;
            StringBuffer buffer = null;
            int i = 0;
            int size = element.nodeCount();
            while (i < size) {
                Node node = element.node(i);
                if (node instanceof Text) {
                    if (lastTextNode == null) {
                        lastTextNode = (Text)node;
                    } else {
                        buffer = new StringBuffer(lastTextNode.getText());
                        buffer.append(((Text)node).getText());
                    }
                } else {
                    if (lastTextNode != null) {
                        if (buffer != null) {
                            this.writeString(buffer.toString());
                            buffer = null;
                        } else {
                            this.writeString(lastTextNode.getText());
                        }
                        lastTextNode = null;
                    }
                    this.writeNode(node);
                }
                ++i;
            }
            if (lastTextNode != null) {
                if (buffer != null) {
                    this.writeString(buffer.toString());
                    buffer = null;
                } else {
                    this.writeString(lastTextNode.getText());
                }
                lastTextNode = null;
            }
        } else {
            int i = 0;
            int size = element.nodeCount();
            while (i < size) {
                Node node = element.node(i);
                this.writeNode(node);
                ++i;
            }
        }
    }

    protected void writeEmptyElementClose(String qualifiedName) throws IOException {
        if (!this.isExpandEmptyElements()) {
            this.writer.write("/>");
        } else {
            this.writer.write("></");
            this.writer.write(qualifiedName);
            this.writer.write(">");
        }
    }

    protected void writeEntity(Entity entity) throws IOException {
        this.writeEntityRef(entity.getName());
    }

    protected void writeEntityRef(String name) throws IOException {
        this.writer.write("&");
        this.writer.write(name);
        this.writer.write(";");
        this.lastOutputNodeType = 5;
    }

    protected void writeEscapeAttributeEntities(String text) throws IOException {
        if (text != null) {
            String escapedText = this.escapeAttributeEntities(text);
            this.writer.write(escapedText);
        }
    }

    protected void writeNamespace(Namespace namespace) throws IOException {
        if (namespace != null) {
            String prefix = namespace.getPrefix();
            this.writer.write(" xmlns");
            if (prefix != null && prefix.length() > 0) {
                this.writer.write(":");
                this.writer.write(prefix);
            }
            this.writer.write("=\"");
            this.writer.write(namespace.getURI());
            this.writer.write("\"");
        }
    }

    protected void writeNode(Node node) throws IOException {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: {
                this.writeElement((Element)node);
                break;
            }
            case 2: {
                this.writeAttribute((Attribute)node);
                break;
            }
            case 3: {
                this.writeString(node.getText());
                break;
            }
            case 4: {
                this.writeCDATA(node.getText());
                break;
            }
            case 5: {
                this.writeEntity((Entity)node);
                break;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.writeComment(node.getText());
                break;
            }
            case 9: {
                this.write((Document)node);
                break;
            }
            case 10: {
                this.writeDocType((DocumentType)node);
                break;
            }
            default: {
                throw new IOException("Invalid node type: " + node);
            }
            case 13: 
        }
    }

    public void writeOpen(Element element) throws IOException {
        this.writer.write("<");
        this.writer.write(element.getQualifiedName());
        this.writeAttributes(element);
        this.writer.write(">");
    }

    protected void writePrintln() throws IOException {
        if (this.format.isNewlines()) {
            this.writer.write(this.format.getLineSeparator());
        }
    }

    protected void writeProcessingInstruction(ProcessingInstruction processingInstruction) throws IOException {
        this.writer.write("<?");
        this.writer.write(processingInstruction.getName());
        this.writer.write(" ");
        this.writer.write(processingInstruction.getText());
        this.writer.write("?>");
        this.writePrintln();
        this.lastOutputNodeType = 7;
    }

    protected void writeString(String text) throws IOException {
        if (text != null && text.length() > 0) {
            text = this.escapeElementEntities(text);
            if (this.format.isTrimText()) {
                boolean first = true;
                StringTokenizer tokenizer = new StringTokenizer(text);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (first) {
                        first = false;
                        if (this.lastOutputNodeType == 3) {
                            this.writer.write(" ");
                        }
                    } else {
                        this.writer.write(" ");
                    }
                    this.writer.write(token);
                    this.lastOutputNodeType = 3;
                }
            } else {
                this.lastOutputNodeType = 3;
                this.writer.write(text);
            }
        }
    }
}

