/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpp;

import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.tree.AbstractElement;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlStartTag;

public class ProxyXmlStartTag
implements XmlStartTag {
    private Element element;
    private DocumentFactory factory = DocumentFactory.getInstance();

    public ProxyXmlStartTag() {
    }

    public ProxyXmlStartTag(Element element) {
        this.element = element;
    }

    public void addAttribute(String namespaceURI, String localName, String rawName, String value) throws XmlPullParserException {
        QName qname = QName.get(rawName, namespaceURI);
        this.element.addAttribute(qname, value);
    }

    public void addAttribute(String namespaceURI, String localName, String rawName, String value, boolean isNamespaceDeclaration) throws XmlPullParserException {
        if (isNamespaceDeclaration) {
            String prefix = "";
            int idx = rawName.indexOf(58);
            if (idx > 0) {
                prefix = rawName.substring(0, idx);
            }
            this.element.addNamespace(prefix, namespaceURI);
        } else {
            QName qname = QName.get(rawName, namespaceURI);
            this.element.addAttribute(qname, value);
        }
    }

    public void ensureAttributesCapacity(int minCapacity) throws XmlPullParserException {
        if (this.element instanceof AbstractElement) {
            AbstractElement elementImpl = (AbstractElement)this.element;
            elementImpl.ensureAttributesCapacity(minCapacity);
        }
    }

    public int getAttributeCount() {
        return this.element != null ? this.element.attributeCount() : 0;
    }

    public String getAttributeLocalName(int index) {
        Attribute attribute2;
        if (this.element != null && (attribute2 = this.element.attribute(index)) != null) {
            return attribute2.getName();
        }
        return null;
    }

    public String getAttributeNamespaceUri(int index) {
        Attribute attribute2;
        if (this.element != null && (attribute2 = this.element.attribute(index)) != null) {
            return attribute2.getNamespaceURI();
        }
        return null;
    }

    public String getAttributePrefix(int index) {
        String prefix;
        Attribute attribute2;
        if (this.element != null && (attribute2 = this.element.attribute(index)) != null && (prefix = attribute2.getNamespacePrefix()) != null && prefix.length() > 0) {
            return prefix;
        }
        return null;
    }

    public String getAttributeRawName(int index) {
        Attribute attribute2;
        if (this.element != null && (attribute2 = this.element.attribute(index)) != null) {
            return attribute2.getQualifiedName();
        }
        return null;
    }

    public String getAttributeValue(int index) {
        Attribute attribute2;
        if (this.element != null && (attribute2 = this.element.attribute(index)) != null) {
            return attribute2.getValue();
        }
        return null;
    }

    public String getAttributeValueFromName(String namespaceURI, String localName) {
        if (this.element != null) {
            Iterator iter = this.element.attributeIterator();
            while (iter.hasNext()) {
                Attribute attribute2 = (Attribute)iter.next();
                if (!namespaceURI.equals(attribute2.getNamespaceURI()) || !localName.equals(attribute2.getName())) continue;
                return attribute2.getValue();
            }
        }
        return null;
    }

    public String getAttributeValueFromRawName(String rawName) {
        if (this.element != null) {
            Iterator iter = this.element.attributeIterator();
            while (iter.hasNext()) {
                Attribute attribute2 = (Attribute)iter.next();
                if (!rawName.equals(attribute2.getQualifiedName())) continue;
                return attribute2.getValue();
            }
        }
        return null;
    }

    public DocumentFactory getDocumentFactory() {
        return this.factory;
    }

    public Element getElement() {
        return this.element;
    }

    public String getLocalName() {
        return this.element.getName();
    }

    public String getNamespaceUri() {
        return this.element.getNamespaceURI();
    }

    public String getPrefix() {
        return this.element.getNamespacePrefix();
    }

    public String getRawName() {
        return this.element.getQualifiedName();
    }

    public boolean isAttributeNamespaceDeclaration(int index) {
        Attribute attribute2;
        if (this.element != null && (attribute2 = this.element.attribute(index)) != null) {
            return "xmlns".equals(attribute2.getNamespacePrefix());
        }
        return false;
    }

    public void modifyTag(String namespaceURI, String localName, String rawName) {
        this.element = this.factory.createElement(rawName, namespaceURI);
    }

    public void removeAtttributes() throws XmlPullParserException {
        if (this.element != null) {
            this.element.setAttributes(new ArrayList());
        }
    }

    public void resetStartTag() {
        this.element = null;
    }

    public void resetTag() {
        this.element = null;
    }

    public void setDocumentFactory(DocumentFactory factory) {
        this.factory = factory;
    }
}

