/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataProvider;
import org.jdesktop.dataset.DataRelation;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataSelector;
import org.jdesktop.dataset.DataSet;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.event.DataTableListener;
import org.jdesktop.dataset.event.RowChangeEvent;
import org.jdesktop.dataset.event.TableChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRelationTable
extends DataTable {
    private static final Logger LOG = Logger.getLogger(DataRelationTable.class.getName());
    private DataRelation relation;
    private DataSelector parentSelector;
    private DataTable parentTable;
    private SelectionListener listener = new SelectionListener();
    private ParentTableListener pListener = new ParentTableListener();
    private ChildTableListener cListener = new ChildTableListener();

    public DataRelationTable(DataSet dataSet) {
        super(dataSet);
    }

    public DataRelationTable(DataSet dataSet, String string) {
        super(dataSet, string);
    }

    public void setRelation(DataRelation dataRelation) {
        if (this.relation != dataRelation) {
            if (this.relation != null && this.relation.getChildColumn() != null) {
                this.relation.getChildColumn().getTable().removeDataTableListener(this.cListener);
            }
            this.relation = dataRelation;
            this.addChildListener();
            if (dataRelation != null) {
                dataRelation.addPropertyChangeListener("childColumn", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        DataRelationTable.this.addChildListener();
                    }
                });
            }
        }
    }

    private void addChildListener() {
        if (this.relation != null && this.relation.getChildColumn() != null) {
            this.relation.getChildColumn().getTable().removeDataTableListener(this.cListener);
        }
        if (this.relation != null && this.relation.getChildColumn() != null) {
            this.relation.getChildColumn().getTable().addDataTableListener(this.cListener);
        }
    }

    public DataRelation getRelation() {
        return this.relation;
    }

    public void setParentSelector(DataSelector dataSelector) {
        if (this.parentSelector != null) {
            this.parentSelector.removePropertyChangeListener("rowIndices", this.listener);
        }
        this.parentSelector = dataSelector;
        if (this.parentSelector != null) {
            this.parentSelector.addPropertyChangeListener("rowIndices", this.listener);
        }
    }

    public DataSelector getParentSelector() {
        return this.parentSelector;
    }

    public void setParentTable(DataTable dataTable) {
        if (this.parentTable != null) {
            this.parentTable.removeDataTableListener(this.pListener);
        }
        this.parentTable = dataTable;
        if (this.parentTable != null) {
            this.parentTable.addDataTableListener(this.pListener);
        }
    }

    public DataTable getParentTable() {
        return this.parentTable;
    }

    @Override
    public void setDataProvider(DataProvider dataProvider) {
        LOG.warning("An attempt was made to set the DataProvider for a DataRelationTable. This is not honored because a DataRelationTable, by definition, gets its records by querying a DataSelector from the Parent table, and the DataRelation leading to the Child table.");
    }

    @Override
    public void save() {
        LOG.warning("An attempt was made to save a DataRelationTable. This is not honored because a DataRelationTable, by definition, gets its records by querying a DataSelector from the Parent table, and the DataRelation leading to the Child table. Therefore, to save, the child table should be asked to save, not the DataRelationTable.");
    }

    @Override
    public DataRow appendRow() {
        if (this.relation != null && this.relation.getChildColumn() != null) {
            DataTable dataTable = this.relation.getChildColumn().getTable();
            DataRow dataRow = dataTable.appendRow();
            if (this.parentSelector.getRowIndices().size() == 1) {
                dataRow.setValue(this.relation.getChildColumn().getName(), this.relation.getParentColumn().getTable().getValue(this.parentSelector.getRowIndices().get(0), this.relation.getParentColumn().getName()));
            }
            this.rows.add(dataRow);
            return dataRow;
        }
        return null;
    }

    @Override
    public void refresh() {
        int n;
        Object object;
        Object[][] objectArray;
        HashMap<Object, Object[][]> hashMap = new HashMap<Object, Object[][]>();
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>();
        for (Object object2 : this.columns.values()) {
            if (!((DataColumn)object2).isKeyColumn()) continue;
            arrayList.add((DataColumn)object2);
        }
        for (Object object2 : this.selectors.values()) {
            objectArray = ((DataSelector)object2).getRowIndices();
            object = new Object[objectArray.size()][arrayList.size()];
            for (int i = 0; i < objectArray.size(); ++i) {
                for (n = 0; n < arrayList.size(); ++n) {
                    DataRow dataRow = (DataRow)this.rows.get((Integer)objectArray.get(i));
                    object[i][n] = this.getValue(dataRow, (DataColumn)arrayList.get(n));
                }
            }
            ((DataSelector)object2).setRowIndices(new int[0]);
            hashMap.put(object2, (Object[][])object);
        }
        this.clear();
        if (this.relation != null && this.relation.getChildColumn() != null) {
            this.fireDataTableChanged(TableChangeEvent.newLoadStartEvent(this));
            if (this.parentSelector != null) {
                this.rows.addAll(this.relation.getRows(this.parentSelector.getRowIndices()));
            } else if (this.parentTable != null) {
                List<DataRow> list = this.parentTable.getRows();
                this.rows.addAll(this.relation.getRows(list.toArray(new DataRow[list.size()])));
            } else {
                this.rows.addAll(this.relation.getChildColumn().getTable().getRows());
            }
            this.fireDataTableChanged(TableChangeEvent.newLoadCompleteEvent(this));
        }
        for (Object object2 : this.selectors.values()) {
            objectArray = (Object[][])hashMap.get(object2);
            object = new ArrayList(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                n = 1;
                for (int j = 0; j < this.rows.size(); ++j) {
                    n = 1;
                    for (int k = 0; k < arrayList.size(); ++k) {
                        DataRow dataRow = (DataRow)this.rows.get(j);
                        if (n != 0 && objectArray[i][k].equals(dataRow.getValue((DataColumn)arrayList.get(k)))) continue;
                        n = 0;
                    }
                    if (n == 0) continue;
                    object.add(j);
                }
            }
            int[] nArray = new int[object.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)object.get(n);
            }
            if (this.rows.size() <= 0) continue;
            if (nArray.length == 0) {
                ((DataSelector)object2).setRowIndices(new int[]{0});
                continue;
            }
            ((DataSelector)object2).setRowIndices(nArray);
        }
    }

    @Override
    public DataColumn getColumn(String string) {
        DataColumn dataColumn = null;
        if (this.relation != null && this.relation.getChildColumn() != null && this.relation.getChildColumn().getTable() != null) {
            dataColumn = this.relation.getChildColumn().getTable().getColumn(string);
        }
        if (dataColumn == null) {
            return super.getColumn(string);
        }
        return dataColumn;
    }

    @Override
    public List<DataColumn> getColumns() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>();
        if (this.relation != null && this.relation.getChildColumn() != null && this.relation.getChildColumn().getTable() != null) {
            arrayList.addAll(this.relation.getChildColumn().getTable().getColumns());
        }
        arrayList.addAll(super.getColumns());
        return Collections.unmodifiableList(arrayList);
    }

    private final class ChildTableListener
    implements DataTableListener {
        private ChildTableListener() {
        }

        public void rowChanged(RowChangeEvent rowChangeEvent) {
        }

        public void tableChanged(TableChangeEvent tableChangeEvent) {
            DataRelationTable.this.refresh();
        }
    }

    private final class ParentTableListener
    implements DataTableListener {
        private ParentTableListener() {
        }

        public void rowChanged(RowChangeEvent rowChangeEvent) {
        }

        public void tableChanged(TableChangeEvent tableChangeEvent) {
            DataRelationTable.this.refresh();
        }
    }

    private final class SelectionListener
    implements PropertyChangeListener {
        private SelectionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataRelationTable.this.refresh();
        }
    }
}

