/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.event.RowChangeEvent;

public class DataRow {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataTable table;
    private DataRowStatus status = DataRowStatus.INSERTED;
    private Map<DataColumn, DataCell> cells = new HashMap<DataColumn, DataCell>();

    protected DataRow(DataTable dataTable) {
        assert (dataTable != null);
        this.table = dataTable;
        for (DataColumn dataColumn : this.table.getColumns()) {
            this.addCell(dataColumn);
        }
    }

    public void setReferenceValue(String string, Object object) {
        this.setReferenceValue(this.table.getColumn(string), object);
    }

    public void setReferenceValue(DataColumn dataColumn, Object object) {
        assert (dataColumn != null);
        this.getCell(dataColumn).setReferenceValue(this.table, dataColumn, object);
        DataRowStatus dataRowStatus = this.deriveRowStatus();
        if (dataRowStatus != this.status) {
            this.setStatus(dataRowStatus);
        }
    }

    public void setValue(String string, Object object) {
        DataColumn dataColumn = this.table.getColumn(string);
        this.setValue(dataColumn, object);
    }

    public void setValue(DataColumn dataColumn, Object object) {
        assert (dataColumn != null);
        Object object2 = this.getValue(dataColumn);
        DataCell dataCell = this.getCell(dataColumn);
        boolean bl = dataCell.changed;
        this.getCell(dataColumn).setValue(this.table, dataColumn, object);
        DataRowStatus dataRowStatus = this.status;
        DataRowStatus dataRowStatus2 = this.deriveRowStatus();
        if (dataRowStatus2 != dataRowStatus) {
            this.setStatus(dataRowStatus2);
        }
        if (bl != dataCell.changed) {
            this.fireDataRowChanged(RowChangeEvent.newCellChangedEvent(this, dataColumn, object2, dataRowStatus));
        }
    }

    public void resetAllToReferenceValue() {
        List<DataColumn> list = this.table.getColumns();
        for (DataColumn dataColumn : list) {
            this.resetToReferenceValue(dataColumn);
        }
    }

    public void resetToReferenceValue(String string) {
        this.resetToReferenceValue(this.table.getColumn(string));
    }

    public void resetToReferenceValue(DataColumn dataColumn) {
        this.setValue(dataColumn, this.getCell((DataColumn)dataColumn).referenceValue);
    }

    public Object getReferenceValue(String string) {
        return this.getReferenceValue(this.table.getColumn(string));
    }

    public Object getValue(String string) {
        return this.getValue(this.table.getColumn(string));
    }

    public Object getReferenceValue(DataColumn dataColumn) {
        assert (dataColumn != null);
        String string = dataColumn.getExpression();
        if (string == null || string.equals("")) {
            DataCell dataCell = this.getCell(dataColumn);
            return dataCell.referenceValue;
        }
        return dataColumn.getValueForRow(this);
    }

    public Object getValue(DataColumn dataColumn) {
        assert (dataColumn != null);
        String string = dataColumn.getExpression();
        if (string == null || string.equals("")) {
            DataCell dataCell = this.getCell(dataColumn);
            return dataCell.value;
        }
        return dataColumn.getValueForRow(this);
    }

    protected DataCell getCell(DataColumn dataColumn) {
        DataCell dataCell = this.cells.get(dataColumn);
        if (dataCell == null && dataColumn.getTable() == this.table) {
            dataCell = this.addCell(dataColumn);
        }
        return dataCell;
    }

    public DataTable getTable() {
        return this.table;
    }

    public DataRowStatus getStatus() {
        return this.status;
    }

    public boolean isModified(String string) {
        return this.isModified(this.table.getColumn(string));
    }

    public boolean isModified(DataColumn dataColumn) {
        return this.cells.get((Object)dataColumn).changed;
    }

    public Object getOriginalValue(String string) {
        return this.getReferenceValue(string);
    }

    public Object getOriginalValue(DataColumn dataColumn) {
        return this.getReferenceValue(dataColumn);
    }

    public void setStatus(DataRowStatus dataRowStatus) {
        if (this.status != dataRowStatus) {
            DataRowStatus dataRowStatus2 = this.status;
            this.status = dataRowStatus;
            this.pcs.firePropertyChange("status", (Object)dataRowStatus2, (Object)dataRowStatus);
            if (this.status == DataRowStatus.UNCHANGED) {
                List<DataColumn> list = this.table.getColumns();
                for (DataColumn dataColumn : list) {
                    DataCell dataCell = this.getCell(dataColumn);
                    if (!dataCell.changed) continue;
                    dataCell.overwriteReference();
                }
            }
        }
    }

    public void fireDataRowChanged(RowChangeEvent rowChangeEvent) {
        this.table.fireRowChanged(rowChangeEvent);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Row #");
        stringBuilder.append(this.table.indexOfRow(this));
        stringBuilder.append(" [ ");
        int n = 0;
        for (DataCell dataCell : this.cells.values()) {
            stringBuilder.append(dataCell.value);
            if (n < this.cells.size() - 1) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    protected DataCell addCell(DataColumn dataColumn) {
        DataCell dataCell = this.cells.get(dataColumn);
        if (dataCell == null) {
            dataCell = new DataCell(dataColumn);
            this.cells.put(dataColumn, dataCell);
        }
        return dataCell;
    }

    protected DataRowStatus deriveRowStatus() {
        DataRowStatus dataRowStatus;
        switch (this.status) {
            case INSERTED: 
            case DELETED: {
                dataRowStatus = this.status;
                break;
            }
            case UPDATED: 
            case UNCHANGED: {
                boolean bl = false;
                for (DataCell dataCell : this.cells.values()) {
                    if (!dataCell.changed) continue;
                    bl = true;
                    break;
                }
                dataRowStatus = bl ? DataRowStatus.UPDATED : DataRowStatus.UNCHANGED;
                break;
            }
            default: {
                throw new RuntimeException("deriveRowStatus() has no case for row status of " + (Object)((Object)this.status));
            }
        }
        return dataRowStatus;
    }

    private static final class DataCell {
        Object referenceValue;
        Object value;
        boolean changed;
        boolean valueSet;

        DataCell(DataColumn dataColumn) {
            this.value = this.referenceValue = dataColumn.getDefaultValue();
        }

        public void setReferenceValue(DataTable dataTable, DataColumn dataColumn, Object object) {
            this.referenceValue = object;
            this.changed = this.isSame(dataTable, dataColumn, this.referenceValue, object);
        }

        public void setValue(DataTable dataTable, DataColumn dataColumn, Object object) {
            if (!this.valueSet) {
                this.value = this.referenceValue = object;
                this.changed = false;
                this.valueSet = true;
                return;
            }
            if (this.isSame(dataTable, dataColumn, this.referenceValue, object)) {
                this.value = this.referenceValue;
                this.changed = false;
                return;
            }
            if (!this.isSame(dataTable, dataColumn, this.value, object)) {
                this.value = object;
                this.changed = true;
            }
        }

        public void overwriteReference() {
            this.referenceValue = this.value;
            this.changed = false;
        }

        private boolean isSame(DataTable dataTable, DataColumn dataColumn, Object object, Object object2) {
            if (dataTable.isIdentityComparisonEnabled()) {
                return object2 == object;
            }
            Comparator comparator = null;
            comparator = dataTable.hasColumnComparator(dataColumn) ? dataTable.getColumnComparator(dataColumn) : dataTable.getClassComparator(dataColumn.getType());
            return comparator.compare(object, object2) == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataRowStatus {
        INSERTED,
        DELETED,
        UPDATED,
        UNCHANGED;

    }
}

