/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.NameGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSelector {
    protected static final String DEFAULT_NAME_PREFIX = "DataSelector";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataSelector");
    private DataTable table;
    private String name;
    private BitSet indices = new BitSet(0);
    private int[] helper = new int[1];
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public DataSelector(DataTable dataTable) {
        assert (dataTable != null);
        this.table = dataTable;
        this.name = NAMEGEN.generateName(this);
        if (dataTable != null && dataTable.getRowCount() > 0) {
            this.setRowIndices(new int[]{0});
        }
    }

    public DataTable getDataTable() {
        return this.table;
    }

    public DataTable getTable() {
        return this.table;
    }

    public void setName(String string) {
        if (this.name != string) {
            assert (string != null && !string.trim().equals(""));
            String string2 = this.name;
            this.name = string;
            this.pcs.firePropertyChange("name", string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<Integer> getRowIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.indices.cardinality());
        int n = -1;
        for (int i = 0; i < this.indices.cardinality(); ++i) {
            n = this.indices.nextSetBit(n + 1);
            arrayList.add(n);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public int getFirstRowIndex() {
        return this.indices.cardinality() > 0 ? this.indices.nextSetBit(0) : -1;
    }

    public void setRowIndices(int[] nArray) {
        List<Integer> list = this.getRowIndices();
        this.indices.clear();
        for (int n : nArray) {
            this.indices.set(n);
        }
        this.pcs.firePropertyChange("rowIndices", list, this.getRowIndices());
    }

    public void setRowIndex(int n) {
        assert (n < this.table.getRowCount());
        if (n >= 0) {
            this.helper[0] = n;
            this.setRowIndices(this.helper);
        } else {
            this.setRowIndices(new int[0]);
        }
    }

    public void setRowIndex(DataRow dataRow) {
        assert (dataRow != null);
        this.setRowIndices(new int[]{this.table.indexOfRow(dataRow)});
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }
}

