/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.adapter;

import java.util.ArrayList;
import java.util.List;
import org.jdesktop.binding.TabularDataModel;
import org.jdesktop.binding.TabularValueChangeEvent;
import org.jdesktop.binding.TabularValueChangeListener;
import org.jdesktop.binding.ValueChangeEvent;
import org.jdesktop.binding.ValueChangeListener;
import org.jdesktop.binding.metadata.MetaData;
import org.jdesktop.binding.metadata.Validator;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.adapter.MetaDataProviderAdapter;
import org.jdesktop.dataset.event.DataTableListener;
import org.jdesktop.dataset.event.RowChangeEvent;
import org.jdesktop.dataset.event.TableChangeEvent;

public class TabularDataModelAdapter
implements TabularDataModel {
    private DataTable table;
    private MetaDataProviderAdapter mdp;
    private List<Validator> validators = new ArrayList<Validator>();
    private List<ValueChangeListener> listeners = new ArrayList<ValueChangeListener>();
    private List<TabularValueChangeListener> tabularListeners = new ArrayList<TabularValueChangeListener>();

    public TabularDataModelAdapter(DataTable dataTable) {
        assert (dataTable != null);
        this.table = dataTable;
        this.mdp = new MetaDataProviderAdapter(dataTable);
        dataTable.addDataTableListener(new DataTableListener(){

            public void rowChanged(RowChangeEvent rowChangeEvent) {
                TabularDataModelAdapter.this.fireRowChanged((DataRow)rowChangeEvent.getSource());
            }

            public void tableChanged(TableChangeEvent tableChangeEvent) {
                TabularDataModelAdapter.this.fireTableChanged();
            }
        });
    }

    public int getRecordCount() {
        return this.table.getRowCount();
    }

    public DataTable getDataTable() {
        return this.table;
    }

    public void addValidator(Validator validator) {
        if (!this.validators.contains(validator)) {
            this.validators.add(validator);
        }
    }

    public void removeValidator(Validator validator) {
        this.validators.remove(validator);
    }

    public Validator[] getValidators() {
        return this.validators.toArray(new Validator[this.validators.size()]);
    }

    public void addValueChangeListener(ValueChangeListener valueChangeListener) {
        if (!this.listeners.contains(valueChangeListener)) {
            this.listeners.add(valueChangeListener);
        }
    }

    public void removeValueChangeListener(ValueChangeListener valueChangeListener) {
        this.listeners.remove(valueChangeListener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return this.listeners.toArray(new ValueChangeListener[this.listeners.size()]);
    }

    public void addTabularValueChangeListener(TabularValueChangeListener tabularValueChangeListener) {
        if (!this.tabularListeners.contains(tabularValueChangeListener)) {
            this.tabularListeners.add(tabularValueChangeListener);
        }
    }

    public TabularValueChangeListener[] getTabularValueChangeListeners() {
        return this.tabularListeners.toArray(new TabularValueChangeListener[this.tabularListeners.size()]);
    }

    public void removeTabularValueChangeListener(TabularValueChangeListener tabularValueChangeListener) {
        this.tabularListeners.remove(tabularValueChangeListener);
    }

    public int getFieldCount() {
        return this.mdp.getFieldCount();
    }

    public String[] getFieldNames() {
        return this.mdp.getFieldNames();
    }

    public MetaData[] getMetaData() {
        return this.mdp.getMetaData();
    }

    public MetaData getMetaData(String string) {
        return this.mdp.getMetaData(string);
    }

    public Object getValueAt(String string, int n) {
        return this.table.getValue(n, string);
    }

    public void setValueAt(String string, int n, Object object) {
        this.table.setValue(n, string, object);
        this.fireTabularValueChanged(n, string);
    }

    public Object getValue(String string) {
        return null;
    }

    public void setValue(String string, Object object) {
    }

    protected void fireValueChanged(String string) {
        ValueChangeEvent valueChangeEvent = new ValueChangeEvent(this, string);
        for (ValueChangeListener valueChangeListener : this.listeners) {
            try {
                valueChangeListener.valueChanged(valueChangeEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void fireRowChanged(DataRow dataRow) {
        int n = this.table.getRows().indexOf(dataRow);
        this.fireTabularValueChanged(n, null);
    }

    protected void fireTableChanged() {
        this.fireTabularValueChanged(-1, null);
    }

    protected void fireTabularValueChanged(int n, String string) {
        TabularValueChangeEvent tabularValueChangeEvent = new TabularValueChangeEvent(this, n, string);
        for (TabularValueChangeListener tabularValueChangeListener : this.tabularListeners) {
            tabularValueChangeListener.tabularValueChanged(tabularValueChangeEvent);
        }
    }

    protected void fireAllFieldsChanged() {
        for (String string : this.mdp.getFieldNames()) {
            this.fireValueChanged(string);
        }
        this.fireValueChanged("");
    }
}

