/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.event;

import java.util.EventObject;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataRow;

public class RowChangeEvent
extends EventObject {
    private EventType eventType;
    private DataColumn columnAffected;
    private Object priorColumnValue;
    private DataRow.DataRowStatus priorRowStatus;

    private RowChangeEvent(DataRow dataRow) {
        super(dataRow);
    }

    public static RowChangeEvent newRowStatusChangeEvent(DataRow dataRow, DataRow.DataRowStatus dataRowStatus) {
        RowChangeEvent rowChangeEvent = new RowChangeEvent(dataRow);
        rowChangeEvent.eventType = EventType.ROW_STATUS_CHANGED;
        rowChangeEvent.priorRowStatus = dataRowStatus;
        return rowChangeEvent;
    }

    public static RowChangeEvent newCellChangedEvent(DataRow dataRow, DataColumn dataColumn, Object object, DataRow.DataRowStatus dataRowStatus) {
        RowChangeEvent rowChangeEvent = new RowChangeEvent(dataRow);
        rowChangeEvent.eventType = EventType.CELL_CHANGED;
        rowChangeEvent.columnAffected = dataColumn;
        rowChangeEvent.priorColumnValue = object;
        rowChangeEvent.priorRowStatus = dataRowStatus;
        return rowChangeEvent;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public DataColumn getColumnAffected() {
        return this.columnAffected;
    }

    public Object getPriorColumnValue() {
        return this.priorColumnValue;
    }

    public DataRow.DataRowStatus getPriorRowStatus() {
        return this.priorRowStatus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        ROW_STATUS_CHANGED,
        CELL_CHANGED;

    }
}

