/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.event;

import java.util.EventObject;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataTable;

public class TableChangeEvent
extends EventObject {
    private EventType eventType;
    private DataColumn columnAffected;
    private DataRow rowAffected;

    private TableChangeEvent(DataTable dataTable) {
        super(dataTable);
    }

    private TableChangeEvent(DataTable dataTable, EventType eventType) {
        super(dataTable);
        this.eventType = eventType;
    }

    private TableChangeEvent(DataTable dataTable, EventType eventType, DataRow dataRow) {
        this(dataTable, eventType);
        this.rowAffected = dataRow;
    }

    private TableChangeEvent(DataTable dataTable, EventType eventType, DataColumn dataColumn) {
        this(dataTable, eventType);
        this.columnAffected = dataColumn;
    }

    public static TableChangeEvent newLoadStartEvent(DataTable dataTable) {
        return new TableChangeEvent(dataTable, EventType.LOAD_STARTED);
    }

    public static TableChangeEvent newLoadCompleteEvent(DataTable dataTable) {
        return new TableChangeEvent(dataTable, EventType.LOAD_COMPLETE);
    }

    public static TableChangeEvent newSaveStartEvent(DataTable dataTable) {
        return new TableChangeEvent(dataTable, EventType.SAVE_STARTED);
    }

    public static TableChangeEvent newSaveCompleteEvent(DataTable dataTable) {
        return new TableChangeEvent(dataTable, EventType.SAVE_COMPLETE);
    }

    public static TableChangeEvent newTableClearedEvent(DataTable dataTable) {
        return new TableChangeEvent(dataTable, EventType.TABLE_CLEARED);
    }

    public static TableChangeEvent newColumnAddedEvent(DataTable dataTable, DataColumn dataColumn) {
        return new TableChangeEvent(dataTable, EventType.COLUMN_ADDED, dataColumn);
    }

    public static TableChangeEvent newColumnRemovedEvent(DataTable dataTable, DataColumn dataColumn) {
        return new TableChangeEvent(dataTable, EventType.COLUMN_REMOVED, dataColumn);
    }

    public static TableChangeEvent newRowAddedEvent(DataTable dataTable, DataRow dataRow) {
        return new TableChangeEvent(dataTable, EventType.ROW_ADDED, dataRow);
    }

    public static TableChangeEvent newRowDeletedEvent(DataTable dataTable, DataRow dataRow) {
        return new TableChangeEvent(dataTable, EventType.ROW_DELETED, dataRow);
    }

    public static TableChangeEvent newRowDiscardedEvent(DataTable dataTable, DataRow dataRow) {
        return new TableChangeEvent(dataTable, EventType.ROW_DISCARDED, dataRow);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public DataRow getRowAffected() {
        return this.rowAffected;
    }

    public DataColumn getColumnAffected() {
        return this.columnAffected;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        LOAD_STARTED,
        LOAD_COMPLETE,
        SAVE_STARTED,
        SAVE_COMPLETE,
        TABLE_CLEARED,
        ROW_ADDED,
        ROW_DELETED,
        ROW_DISCARDED,
        COLUMN_ADDED,
        COLUMN_REMOVED;

    }
}

