/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.provider.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataProvider;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.event.TableChangeEvent;
import org.jdesktop.dataset.provider.LoadTask;
import org.jdesktop.dataset.provider.SaveTask;
import org.jdesktop.dataset.provider.sql.AbstractSqlCommand;
import org.jdesktop.dataset.provider.sql.JDBCDataConnection;
import org.jdesktop.dataset.provider.sql.TableCommand;

public class SQLDataProvider
extends DataProvider {
    private static final Logger LOG = Logger.getLogger(SQLDataProvider.class.getName());
    private Map<String, String> columnMappings = new HashMap<String, String>();

    public SQLDataProvider() {
    }

    public SQLDataProvider(String string) {
        TableCommand tableCommand = new TableCommand(string);
        this.setCommand(tableCommand);
    }

    public SQLDataProvider(String string, String string2) {
        TableCommand tableCommand = new TableCommand(string, string2);
        this.setCommand(tableCommand);
    }

    public void addColumnNameMapping(String string, String string2) {
        this.columnMappings.put(string, string2);
    }

    public void removeColumnNameMapping(String string) {
        this.columnMappings.remove(string);
    }

    protected LoadTask createLoadTask(DataTable[] dataTableArray) {
        return new LoadTask(dataTableArray){

            protected void readData(DataTable[] dataTableArray) throws Exception {
                JDBCDataConnection jDBCDataConnection = (JDBCDataConnection)SQLDataProvider.this.getConnection();
                if (jDBCDataConnection == null) {
                    return;
                }
                if (SQLDataProvider.this.getCommand() == null) {
                    return;
                }
                this.setMinimum(0);
                this.setMaximum(dataTableArray.length);
                for (DataTable dataTable : dataTableArray) {
                    try {
                        PreparedStatement preparedStatement = ((AbstractSqlCommand)SQLDataProvider.this.getCommand()).getSelectStatement(jDBCDataConnection);
                        ResultSet resultSet = preparedStatement.executeQuery();
                        HashSet<Object> hashSet = new HashSet<Object>();
                        hashSet.addAll(SQLDataProvider.this.columnMappings.keySet());
                        for (DataColumn dataColumn : dataTable.getColumns()) {
                            hashSet.add(dataColumn.getName());
                        }
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        ArrayList<String> object2 = new ArrayList<String>();
                        for (String string : hashSet) {
                            for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                                if (!string.equalsIgnoreCase(resultSetMetaData.getColumnName(i + 1))) continue;
                                object2.add(string);
                            }
                        }
                        ArrayList arrayList = new ArrayList(60);
                        while (resultSet.next()) {
                            if (arrayList.size() >= 50) {
                                LoadTask.LoadItem<Object> loadItem = new LoadTask.LoadItem<Object>(dataTable, arrayList);
                                this.scheduleLoad(loadItem);
                                arrayList = new ArrayList(60);
                            }
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            for (String string : object2) {
                                hashMap.put(string, resultSet.getObject(string));
                            }
                            arrayList.add(hashMap);
                        }
                        resultSet.close();
                        LoadTask.LoadItem<Object> loadItem = new LoadTask.LoadItem<Object>(dataTable, arrayList);
                        this.scheduleLoad(loadItem);
                    }
                    catch (Exception exception) {
                        LOG.log(Level.WARNING, "Failed to read data for table {0}", dataTable);
                        LOG.log(Level.WARNING, exception.getMessage(), exception);
                    }
                    this.setProgress(this.getProgress() + 1);
                }
                this.setProgress(this.getMaximum());
            }

            protected void loadData(LoadTask.LoadItem[] loadItemArray) {
                for (LoadTask.LoadItem loadItem : loadItemArray) {
                    for (Map map : (List)loadItem.data) {
                        DataRow dataRow = loadItem.table.appendRowNoEvent();
                        for (String string : map.keySet()) {
                            if (SQLDataProvider.this.columnMappings.containsKey(string)) {
                                string = (String)SQLDataProvider.this.columnMappings.get(string);
                            }
                            dataRow.setValue(string, map.get(string));
                        }
                        dataRow.setStatus(DataRow.DataRowStatus.UNCHANGED);
                        loadItem.table.fireDataTableChanged(TableChangeEvent.newRowAddedEvent(loadItem.table, dataRow));
                    }
                    loadItem.table.fireDataTableChanged(TableChangeEvent.newLoadCompleteEvent(loadItem.table));
                }
            }
        };
    }

    protected SaveTask createSaveTask(DataTable[] dataTableArray) {
        return new SaveTask(dataTableArray){

            protected void saveData(DataTable[] dataTableArray) throws Exception {
                JDBCDataConnection jDBCDataConnection = (JDBCDataConnection)SQLDataProvider.this.getConnection();
                if (jDBCDataConnection == null) {
                    return;
                }
                if (SQLDataProvider.this.getCommand() == null) {
                    return;
                }
                this.setMinimum(0);
                this.setMaximum(dataTableArray.length);
                for (DataTable dataTable : dataTableArray) {
                    ArrayList<DataRow> arrayList = new ArrayList<DataRow>(dataTable.getRows());
                    for (DataRow dataRow : arrayList) {
                        PreparedStatement preparedStatement = null;
                        switch (dataRow.getStatus()) {
                            case UPDATED: {
                                preparedStatement = ((AbstractSqlCommand)SQLDataProvider.this.getCommand()).getUpdateStatement(jDBCDataConnection, dataRow);
                                jDBCDataConnection.executeUpdate(preparedStatement);
                                dataRow.setStatus(DataRow.DataRowStatus.UNCHANGED);
                                break;
                            }
                            case INSERTED: {
                                preparedStatement = ((AbstractSqlCommand)SQLDataProvider.this.getCommand()).getInsertStatement(jDBCDataConnection, dataRow);
                                jDBCDataConnection.executeUpdate(preparedStatement);
                                dataRow.setStatus(DataRow.DataRowStatus.UNCHANGED);
                                break;
                            }
                            case DELETED: {
                                preparedStatement = ((AbstractSqlCommand)SQLDataProvider.this.getCommand()).getDeleteStatement(jDBCDataConnection, dataRow);
                                jDBCDataConnection.executeUpdate(preparedStatement);
                                dataTable.discardRow(dataRow);
                                break;
                            }
                        }
                    }
                    dataTable.fireDataTableChanged(TableChangeEvent.newSaveCompleteEvent(dataTable));
                    this.setProgress(this.getProgress() + 1);
                }
                this.setProgress(this.getMaximum());
                jDBCDataConnection.commit();
            }
        };
    }
}

