/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class PatternModel {
    public static final String SEARCH_PREFIX = "Search.";
    public static final String REGEX_UNCHANGED = "regex";
    public static final String REGEX_ANCHORED = "anchored";
    public static final String REGEX_WILDCARD = "wildcard";
    public static final String REGEX_MATCH_RULES = "explicit";
    public static final String MATCH_RULE_CONTAINS = "contains";
    public static final String MATCH_RULE_EQUALS = "equals";
    public static final String MATCH_RULE_ENDSWITH = "endsWith";
    public static final String MATCH_RULE_STARTSWITH = "startsWith";
    public static final String MATCH_BACKWARDS_ACTION_COMMAND = "backwardsSearch";
    public static final String MATCH_WRAP_ACTION_COMMAND = "wrapSearch";
    public static final String MATCH_CASE_ACTION_COMMAND = "matchCase";
    public static final String MATCH_INCREMENTAL_ACTION_COMMAND = "matchIncremental";
    private String rawText;
    private boolean backwards;
    private Pattern pattern;
    private int foundIndex = -1;
    private boolean caseSensitive;
    private PropertyChangeSupport propertySupport;
    private String regexCreatorKey;
    private RegexCreator regexCreator;
    private boolean wrapping;
    private boolean incremental;

    public int getFoundIndex() {
        return this.foundIndex;
    }

    public void setFoundIndex(int n) {
        int n2 = this.getFoundIndex();
        this.updateFoundIndex(n);
        this.firePropertyChange("foundIndex", n2, this.getFoundIndex());
    }

    protected void updateFoundIndex(int n) {
        if (n < 0) {
            this.foundIndex = n;
            return;
        }
        this.foundIndex = this.isAutoAdjustFoundIndex() ? (this.backwards ? n - 1 : n + 1) : n;
    }

    public boolean isAutoAdjustFoundIndex() {
        return !this.isIncremental();
    }

    public boolean isBackwards() {
        return this.backwards;
    }

    public void setBackwards(boolean bl) {
        boolean bl2 = this.isBackwards();
        this.backwards = bl;
        this.firePropertyChange("backwards", bl2, this.isBackwards());
        this.setFoundIndex(this.getFoundIndex());
    }

    public boolean isWrapping() {
        return this.wrapping;
    }

    public void setWrapping(boolean bl) {
        boolean bl2 = this.isWrapping();
        this.wrapping = bl;
        this.firePropertyChange("wrapping", bl2, this.isWrapping());
    }

    public void setIncremental(boolean bl) {
        boolean bl2 = this.isIncremental();
        this.incremental = bl;
        this.firePropertyChange("incremental", bl2, this.isIncremental());
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        boolean bl2 = this.isCaseSensitive();
        this.caseSensitive = bl;
        this.updatePattern(bl);
        this.firePropertyChange("caseSensitive", bl2, this.isCaseSensitive());
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getRawText() {
        return this.rawText;
    }

    public void setRawText(String string) {
        String string2 = this.getRawText();
        boolean bl = this.isEmpty();
        this.rawText = string;
        this.updatePattern(this.createRegEx(string));
        this.firePropertyChange("rawText", string2, this.getRawText());
        this.firePropertyChange("empty", bl, this.isEmpty());
    }

    public boolean isEmpty() {
        return this.isEmpty(this.getRawText());
    }

    private String createRegEx(String string) {
        if (this.isEmpty(string)) {
            return null;
        }
        return this.getRegexCreator().createRegEx(string);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private void updatePattern(String string) {
        Pattern pattern = this.getPattern();
        if (this.isEmpty(string)) {
            this.pattern = null;
        } else if (pattern == null || !pattern.pattern().equals(string)) {
            this.pattern = Pattern.compile(string, this.getFlags());
        }
        this.firePropertyChange("pattern", pattern, this.getPattern());
    }

    private int getFlags() {
        return this.isCaseSensitive() ? 0 : this.getCaseInsensitiveFlag();
    }

    private int getCaseInsensitiveFlag() {
        return 66;
    }

    private void updatePattern(boolean bl) {
        if (this.pattern == null) {
            return;
        }
        Pattern pattern = this.getPattern();
        int n = pattern.flags();
        int n2 = this.getCaseInsensitiveFlag();
        if (bl && (n & n2) != 0) {
            this.pattern = Pattern.compile(this.pattern.pattern(), 0);
        } else if (!bl && (n & n2) == 0) {
            this.pattern = Pattern.compile(this.pattern.pattern(), n2);
        }
        this.firePropertyChange("pattern", pattern, this.getPattern());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertySupport == null) {
            return;
        }
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.propertySupport == null) {
            return;
        }
        this.propertySupport.firePropertyChange(string, object, object2);
    }

    public void setRegexCreatorKey(String string) {
        if (this.getRegexCreatorKey().equals(string)) {
            return;
        }
        String string2 = this.getRegexCreatorKey();
        this.regexCreatorKey = string;
        this.firePropertyChange("regexCreatorKey", string2, this.getRegexCreatorKey());
    }

    public String getRegexCreatorKey() {
        if (this.regexCreatorKey == null) {
            this.regexCreatorKey = this.getDefaultRegexCreatorKey();
        }
        return this.regexCreatorKey;
    }

    private String getDefaultRegexCreatorKey() {
        return REGEX_MATCH_RULES;
    }

    public void setMatchRule(String string) {
        if (this.getMatchRule().equals(string)) {
            return;
        }
        String string2 = this.getMatchRule();
        this.getRegexCreator().setMatchRule(string);
        this.updatePattern(this.createRegEx(this.getRawText()));
        this.firePropertyChange("matchRule", string2, this.getMatchRule());
    }

    public String getMatchRule() {
        return this.getRegexCreator().getMatchRule();
    }

    private RegexCreator getRegexCreator() {
        if (this.regexCreator == null) {
            this.regexCreator = new RegexCreator();
        }
        return this.regexCreator;
    }

    public List getMatchRules() {
        return this.getRegexCreator().getMatchRules();
    }

    public static class AnchoredSearchMode
    extends RegexCreator {
        public boolean isAutoDetect() {
            return true;
        }

        public String createRegEx(String string) {
            if (this.isAutoDetect()) {
                StringBuffer stringBuffer = new StringBuffer(string.length() + 4);
                if (!this.hasStartAnchor(string) && this.isStartAnchored()) {
                    stringBuffer.append("^");
                }
                stringBuffer.append(string);
                if (!this.hasEndAnchor(string) && this.isEndAnchored()) {
                    stringBuffer.append("$");
                }
                return stringBuffer.toString();
            }
            return super.createRegEx(string);
        }

        private boolean hasStartAnchor(String string) {
            return string.startsWith("^");
        }

        private boolean hasEndAnchor(String string) {
            int n = string.length();
            if (string.charAt(n - 1) != '$') {
                return false;
            }
            if (n == 1) {
                return true;
            }
            for (int i = n - 2; i >= 0; --i) {
                if (string.charAt(i) == '\\') continue;
                return (n - i) % 2 == 0;
            }
            return n % 2 != 0;
        }

        public boolean isStartAnchored() {
            return PatternModel.MATCH_RULE_EQUALS.equals(this.getMatchRule()) || PatternModel.MATCH_RULE_STARTSWITH.equals(this.getMatchRule());
        }

        public boolean isEndAnchored() {
            return PatternModel.MATCH_RULE_EQUALS.equals(this.getMatchRule()) || PatternModel.MATCH_RULE_ENDSWITH.equals(this.getMatchRule());
        }
    }

    public static class RegexCreator {
        protected String matchRule;
        private List rules;

        public String getMatchRule() {
            if (this.matchRule == null) {
                this.matchRule = this.getDefaultMatchRule();
            }
            return this.matchRule;
        }

        public boolean isAutoDetect() {
            return false;
        }

        public String createRegEx(String string) {
            if (PatternModel.MATCH_RULE_CONTAINS.equals(this.getMatchRule())) {
                return this.createContainedRegEx(string);
            }
            if (PatternModel.MATCH_RULE_EQUALS.equals(this.getMatchRule())) {
                return this.createEqualsRegEx(string);
            }
            if (PatternModel.MATCH_RULE_STARTSWITH.equals(this.getMatchRule())) {
                return this.createStartsAnchoredRegEx(string);
            }
            if (PatternModel.MATCH_RULE_ENDSWITH.equals(this.getMatchRule())) {
                return this.createEndAnchoredRegEx(string);
            }
            return string;
        }

        protected String createEndAnchoredRegEx(String string) {
            return Pattern.quote(string) + "$";
        }

        protected String createStartsAnchoredRegEx(String string) {
            return "^" + Pattern.quote(string);
        }

        protected String createEqualsRegEx(String string) {
            return "^" + Pattern.quote(string) + "$";
        }

        protected String createContainedRegEx(String string) {
            return Pattern.quote(string);
        }

        public void setMatchRule(String string) {
            this.matchRule = string;
        }

        protected String getDefaultMatchRule() {
            return PatternModel.MATCH_RULE_CONTAINS;
        }

        public List getMatchRules() {
            if (this.rules == null) {
                this.rules = this.createAndInitRules();
            }
            return this.rules;
        }

        private List createAndInitRules() {
            if (!this.supportsRules()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(PatternModel.MATCH_RULE_CONTAINS);
            arrayList.add(PatternModel.MATCH_RULE_EQUALS);
            arrayList.add(PatternModel.MATCH_RULE_STARTSWITH);
            arrayList.add(PatternModel.MATCH_RULE_ENDSWITH);
            return arrayList;
        }

        private boolean supportsRules() {
            return true;
        }
    }
}

