/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.plaf.TaskPaneContainerUI;

public class BasicTaskPaneContainerUI
extends TaskPaneContainerUI {
    protected JXTaskPaneContainer taskPane;
    protected boolean useGradient;
    protected Color gradientStart;
    protected Color gradientEnd;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTaskPaneContainerUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.taskPane = (JXTaskPaneContainer)jComponent;
        this.taskPane.setLayout(new VerticalLayout(14));
        this.taskPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.taskPane.setOpaque(true);
        if (this.taskPane.getBackground() == null || this.taskPane.getBackground() instanceof ColorUIResource) {
            this.taskPane.setBackground(UIManager.getColor("TaskPaneContainer.background"));
        }
        this.useGradient = UIManager.getBoolean("TaskPaneContainer.useGradient");
        if (this.useGradient) {
            this.gradientStart = UIManager.getColor("TaskPaneContainer.backgroundGradientStart");
            this.gradientEnd = UIManager.getColor("TaskPaneContainer.backgroundGradientEnd");
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.useGradient) {
            Paint paint = graphics2D.getPaint();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.gradientStart, 0.0f, jComponent.getHeight(), this.gradientEnd);
            graphics2D.setPaint(gradientPaint);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            graphics2D.setPaint(paint);
        }
    }
}

