/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.constraint;

import java.lang.reflect.Array;
import org.jmock.core.Constraint;

public class IsEqual
implements Constraint {
    private Object object;

    public boolean eval(Object arg) {
        return IsEqual.areEqual(this.object, arg);
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        buffer.append("eq(");
        if (this.object == null) {
            buffer.append("null");
        } else {
            buffer.append("<");
            buffer.append(this.object);
            buffer.append(">");
        }
        buffer.append(")");
        return buffer;
    }

    private static final boolean areEqual(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            boolean bl = false;
            if (o1 == null && o2 == null) {
                bl = true;
            }
            return bl;
        }
        if (IsEqual.isArray(o1)) {
            boolean bl = false;
            if (IsEqual.isArray(o2) && IsEqual.areArraysEqual(o1, o2)) {
                bl = true;
            }
            return bl;
        }
        return o1.equals(o2);
    }

    private static final boolean areArraysEqual(Object o1, Object o2) {
        boolean bl = false;
        if (IsEqual.areArrayLengthsEqual(o1, o2) && IsEqual.areArrayElementsEqual(o1, o2)) {
            bl = true;
        }
        return bl;
    }

    private static final boolean areArrayLengthsEqual(Object o1, Object o2) {
        boolean bl = false;
        if (Array.getLength(o1) == Array.getLength(o2)) {
            bl = true;
        }
        return bl;
    }

    private static final boolean areArrayElementsEqual(Object o1, Object o2) {
        int i = 0;
        while (i < Array.getLength(o1)) {
            if (!IsEqual.areEqual(Array.get(o1, i), Array.get(o2, i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final boolean isArray(Object o) {
        return o.getClass().isArray();
    }

    public IsEqual(Object equalArg) {
        this.object = equalArg;
    }
}

