/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.matcher;

import junit.framework.AssertionFailedError;
import org.jmock.core.Invocation;
import org.jmock.core.matcher.InvokedRecorder;
import org.jmock.core.matcher.StatelessInvocationMatcher;

public class InvokedAfterMatcher
extends StatelessInvocationMatcher {
    private InvokedRecorder priorCallRecorder;
    private String priorCallDescription;

    public boolean matches(Invocation invocation) {
        return this.priorCallRecorder.hasBeenInvoked();
    }

    public void invoked(Invocation invocation) {
        if (!this.matches(invocation)) {
            throw new AssertionFailedError("called out of order; should be called after " + this.priorCallDescription);
        }
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        return buffer.append("after ").append(this.priorCallDescription);
    }

    public InvokedAfterMatcher(InvokedRecorder priorCallRecorder, String priorCallDescription) {
        this.priorCallRecorder = priorCallRecorder;
        this.priorCallDescription = priorCallDescription;
    }
}

