/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.dynamic;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jmock.dynamic.DynamicMock;

public class DynamicUtil {
    public static String toReadableString(Object element) {
        if (element == null) {
            return "null";
        }
        if (Proxy.isProxyClass(element.getClass())) {
            return DynamicUtil.unpackProxy(element).toString();
        }
        if (element.getClass().isArray()) {
            return DynamicUtil.join(element, new StringBuffer()).toString();
        }
        return element.toString();
    }

    private static Object unpackProxy(Object element) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(element);
        return invocationHandler instanceof DynamicMock ? invocationHandler : element;
    }

    public static StringBuffer join(Object array, StringBuffer buf) {
        return DynamicUtil.join(array, buf, "[", "]");
    }

    public static StringBuffer join(Object array, StringBuffer buf, String prefix, String postfix) {
        buf.append(prefix);
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object element;
            if (i > 0) {
                buf.append(", ");
            }
            if (null == (element = Array.get(array, i))) {
                buf.append("<null>");
                continue;
            }
            if (element.getClass().isArray()) {
                DynamicUtil.join(element, buf);
                continue;
            }
            buf.append("<");
            buf.append(DynamicUtil.toReadableString(element));
            buf.append(">");
        }
        buf.append(postfix);
        return buf;
    }

    public static String classShortName(Class c) {
        return c.getName().substring(c.getPackage().getName().length() + 1);
    }
}

