/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.dynamock;

import org.jmock.Verifiable;
import org.jmock.dynamic.BuildableInvokable;
import org.jmock.dynamic.CoreMock;
import org.jmock.dynamic.DynamicMock;
import org.jmock.dynamic.InvocationMatcher;
import org.jmock.dynamic.Invokable;
import org.jmock.dynamic.LIFOInvocationDispatcher;
import org.jmock.dynamic.Stub;
import org.jmock.dynamock.BuildableInvokableFactory;
import org.jmock.dynamock.InvokableFactory;

public class Mock
implements Verifiable {
    private DynamicMock coreMock;
    private BuildableInvokableFactory factory;

    public Mock(Class mockedClass) {
        this(mockedClass, CoreMock.mockNameFromClass(mockedClass));
    }

    public Mock(Class mockedClass, String nonDefaultName) {
        this(new CoreMock(mockedClass, nonDefaultName, new LIFOInvocationDispatcher()), new InvokableFactory());
    }

    public Mock(DynamicMock coreMock, BuildableInvokableFactory factory) {
        this.factory = factory;
        this.coreMock = coreMock;
    }

    public String toString() {
        return this.coreMock.toString();
    }

    public Object proxy() {
        return this.coreMock.proxy();
    }

    public Class getMockedType() {
        return this.coreMock.getMockedType();
    }

    public void reset() {
        this.coreMock.reset();
    }

    public void verify() {
        this.coreMock.verify();
    }

    public void setDefaultStub(Stub newDefaultStub) {
        this.coreMock.setDefaultStub(newDefaultStub);
    }

    public void add(Invokable invokable) {
        this.coreMock.add(invokable);
    }

    public void stub(String methodName, InvocationMatcher argumentsMatcher, Stub stub) {
        this.createStub(methodName, argumentsMatcher, stub);
    }

    public void stubVoid(String methodName, InvocationMatcher argumentsMatcher) {
        this.stub(methodName, argumentsMatcher, this.factory.createVoidStub());
    }

    public void stubAndReturn(String methodName, InvocationMatcher argumentsMatcher, Object result) {
        this.stub(methodName, argumentsMatcher, this.factory.createReturnStub(result));
    }

    public void stubAndThrow(String methodName, InvocationMatcher argumentsMatcher, Throwable throwable) {
        this.stub(methodName, argumentsMatcher, this.factory.createThrowStub(throwable));
    }

    public void expect(String methodName, InvocationMatcher argumentsMatcher, Stub stub) {
        BuildableInvokable buildableInvokable = this.createStub(methodName, argumentsMatcher, stub);
        buildableInvokable.addMatcher(this.factory.createCallOnceMatcher());
    }

    public void expectVoid(String methodName, InvocationMatcher argumentsMatcher) {
        this.expect(methodName, argumentsMatcher, this.factory.createVoidStub());
    }

    public void expectAndReturn(String methodName, InvocationMatcher argumentsMatcher, Object result) {
        this.expect(methodName, argumentsMatcher, this.factory.createReturnStub(result));
    }

    public void expectAndThrow(String methodName, InvocationMatcher argumentsMatcher, Throwable throwable) {
        this.expect(methodName, argumentsMatcher, this.factory.createThrowStub(throwable));
    }

    public void expectNotCalled(String methodName, InvocationMatcher argumentsMatcher) {
        this.createStub(methodName, argumentsMatcher, this.factory.createTestFailureStub("must not be called"));
    }

    private BuildableInvokable createStub(String methodName, InvocationMatcher argumentsMatcher, Stub stub) {
        BuildableInvokable buildableInvokable = this.factory.createBuildableInvokable();
        buildableInvokable.addMatcher(this.factory.createMethodNameMatcher(methodName));
        buildableInvokable.addMatcher(argumentsMatcher);
        buildableInvokable.setStub(stub);
        this.add(buildableInvokable);
        return buildableInvokable;
    }
}

