/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import org.jmock.expectation.AbstractExpectation;
import org.jmock.expectation.AssertMo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExpectationDoubleValue
extends AbstractExpectation {
    private Double expectedValue;
    private double expectedError;
    private boolean expectNothing;
    private Double actualValue;

    public void clearActual() {
        this.actualValue = null;
    }

    public void setActual(double value) {
        this.actualValue = new Double(value);
        if (this.shouldCheckImmediately()) {
            this.verify();
        }
    }

    public void setExpected(double value, double error) {
        this.expectedValue = new Double(value);
        this.expectedError = Math.abs(error);
        this.setHasExpectations();
    }

    public void setExpectNothing() {
        this.expectNothing = true;
        this.clearActual();
        this.setHasExpectations();
    }

    public void verify() {
        if (this.expectNothing) {
            AssertMo.assertNull((String)(this.myName + " expected no value"), (Object)this.actualValue);
        } else if (this.expectedValue != null) {
            AssertMo.assertNotNull((String)(this.myName + " expected a value"), (Object)this.actualValue);
            double actualError = Math.abs(this.actualValue - this.expectedValue);
            String string = this.myName + " expected a value within " + this.expectedError + " of " + this.expectedValue + ", was " + this.actualValue;
            boolean bl = false;
            if (actualError <= this.expectedError) {
                bl = true;
            }
            AssertMo.assertTrue((String)string, (boolean)bl);
        }
    }

    private final /* synthetic */ void this() {
        this.expectedValue = null;
        this.expectedError = 0.0;
        this.expectNothing = false;
        this.actualValue = null;
    }

    public ExpectationDoubleValue(String name) {
        super(name);
        this.this();
        this.clearActual();
    }
}

