/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.InstantConverter;

public final class Instant
extends AbstractInstant
implements ReadableInstant,
Serializable {
    private static final long serialVersionUID = 3299096530934209741L;
    private final long iMillis;

    public Instant() {
        this.iMillis = DateTimeUtils.currentTimeMillis();
    }

    public Instant(long instant) {
        this.iMillis = instant;
    }

    public Instant(Object instant) {
        InstantConverter converter = ConverterManager.getInstance().getInstantConverter(instant);
        this.iMillis = converter.getInstantMillis(instant, Chronology.getISOUTC());
    }

    public Instant toInstant() {
        return this;
    }

    public Instant withMillis(long newMillis) {
        return newMillis == this.iMillis ? this : new Instant(newMillis);
    }

    public Instant withDurationAdded(long durationToAdd, int scalar) {
        if (durationToAdd == 0L || scalar == 0) {
            return this;
        }
        long instant = this.getChronology().add(this.getMillis(), durationToAdd, scalar);
        return this.withMillis(instant);
    }

    public Instant withDurationAdded(ReadableDuration durationToAdd, int scalar) {
        if (durationToAdd == null || scalar == 0) {
            return this;
        }
        return this.withDurationAdded(durationToAdd.getMillis(), scalar);
    }

    public Instant plus(long duration) {
        return this.withDurationAdded(duration, 1);
    }

    public Instant plus(ReadableDuration duration) {
        return this.withDurationAdded(duration, 1);
    }

    public Instant minus(long duration) {
        return this.withDurationAdded(duration, -1);
    }

    public Instant minus(ReadableDuration duration) {
        return this.withDurationAdded(duration, -1);
    }

    public long getMillis() {
        return this.iMillis;
    }

    public Chronology getChronology() {
        return Chronology.getISOUTC();
    }
}

