/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadWritableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseDateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISODateTimeFormat;

public class MutableDateTime
extends BaseDateTime
implements ReadWritableDateTime,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2852608688135209575L;
    public static final int ROUND_NONE = 0;
    public static final int ROUND_FLOOR = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_HALF_FLOOR = 3;
    public static final int ROUND_HALF_CEILING = 4;
    public static final int ROUND_HALF_EVEN = 5;
    private DateTimeField iRoundingField;
    private int iRoundingMode;

    public MutableDateTime() {
    }

    public MutableDateTime(DateTimeZone zone) {
        super(zone);
    }

    public MutableDateTime(Chronology chronology) {
        super(chronology);
    }

    public MutableDateTime(long instant) {
        super(instant);
    }

    public MutableDateTime(long instant, DateTimeZone zone) {
        super(instant, zone);
    }

    public MutableDateTime(long instant, Chronology chronology) {
        super(instant, chronology);
    }

    public MutableDateTime(Object instant) {
        super(instant, (Chronology)null);
    }

    public MutableDateTime(Object instant, DateTimeZone zone) {
        super(instant, zone);
    }

    public MutableDateTime(Object instant, Chronology chronology) {
        super(instant, DateTimeUtils.getChronology(chronology));
    }

    public MutableDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        super(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }

    public MutableDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, DateTimeZone zone) {
        super(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, zone);
    }

    public MutableDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Chronology chronology) {
        super(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, chronology);
    }

    public DateTimeField getRoundingField() {
        return this.iRoundingField;
    }

    public int getRoundingMode() {
        return this.iRoundingMode;
    }

    public void setRounding(DateTimeField field) {
        this.setRounding(field, 1);
    }

    public void setRounding(DateTimeField field, int mode) {
        if (field != null && (mode < 0 || mode > 5)) {
            throw new IllegalArgumentException("Illegal rounding mode: " + mode);
        }
        this.iRoundingField = mode == 0 ? null : field;
        this.iRoundingMode = field == null ? 0 : mode;
        this.setMillis(this.getMillis());
    }

    public void setMillis(long instant) {
        switch (this.iRoundingMode) {
            case 0: {
                break;
            }
            case 1: {
                instant = this.iRoundingField.roundFloor(instant);
                break;
            }
            case 2: {
                instant = this.iRoundingField.roundCeiling(instant);
                break;
            }
            case 3: {
                instant = this.iRoundingField.roundHalfFloor(instant);
                break;
            }
            case 4: {
                instant = this.iRoundingField.roundHalfCeiling(instant);
                break;
            }
            case 5: {
                instant = this.iRoundingField.roundHalfEven(instant);
            }
        }
        super.setMillis(instant);
    }

    public void setMillis(ReadableInstant instant) {
        long instantMillis = DateTimeUtils.getInstantMillis(instant);
        this.setMillis(instantMillis);
    }

    public void add(long duration) {
        this.setMillis(FieldUtils.safeAdd(this.getMillis(), duration));
    }

    public void add(ReadableDuration duration) {
        this.add(duration, 1);
    }

    public void add(ReadableDuration duration, int scalar) {
        if (duration != null) {
            this.add(FieldUtils.safeMultiply(duration.getMillis(), scalar));
        }
    }

    public void add(ReadablePeriod period) {
        this.add(period, 1);
    }

    public void add(ReadablePeriod period, int scalar) {
        if (period != null) {
            this.setMillis(this.getChronology().add(period, this.getMillis(), scalar));
        }
    }

    public void setChronology(Chronology chronology) {
        super.setChronology(chronology);
    }

    public void setZone(DateTimeZone newZone) {
        newZone = DateTimeUtils.getZone(newZone);
        Chronology chrono = this.getChronology();
        if (chrono.getZone() != newZone) {
            this.setChronology(chrono.withZone(newZone));
        }
    }

    public void setZoneRetainFields(DateTimeZone newZone) {
        DateTimeZone originalZone;
        if ((newZone = DateTimeUtils.getZone(newZone)) == (originalZone = DateTimeUtils.getZone(this.getZone()))) {
            return;
        }
        long millis = originalZone.getMillisKeepLocal(newZone, this.getMillis());
        this.setChronology(this.getChronology().withZone(newZone));
        this.setMillis(millis);
    }

    public void set(DateTimeFieldType type, int value) {
        if (type == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        this.setMillis(type.getField(this.getChronology()).set(this.getMillis(), value));
    }

    public void add(DurationFieldType type, int amount) {
        if (type == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        this.setMillis(type.getField(this.getChronology()).add(this.getMillis(), amount));
    }

    public void setYear(int year) {
        this.setMillis(this.getChronology().year().set(this.getMillis(), year));
    }

    public void addYears(int years) {
        this.setMillis(this.getChronology().years().add(this.getMillis(), years));
    }

    public void setWeekyear(int weekyear) {
        this.setMillis(this.getChronology().weekyear().set(this.getMillis(), weekyear));
    }

    public void addWeekyears(int weekyears) {
        this.setMillis(this.getChronology().weekyears().add(this.getMillis(), weekyears));
    }

    public void setMonthOfYear(int monthOfYear) {
        this.setMillis(this.getChronology().monthOfYear().set(this.getMillis(), monthOfYear));
    }

    public void addMonths(int months) {
        this.setMillis(this.getChronology().months().add(this.getMillis(), months));
    }

    public void setWeekOfWeekyear(int weekOfWeekyear) {
        this.setMillis(this.getChronology().weekOfWeekyear().set(this.getMillis(), weekOfWeekyear));
    }

    public void addWeeks(int weeks) {
        this.setMillis(this.getChronology().weeks().add(this.getMillis(), weeks));
    }

    public void setDayOfYear(int dayOfYear) {
        this.setMillis(this.getChronology().dayOfYear().set(this.getMillis(), dayOfYear));
    }

    public void setDayOfMonth(int dayOfMonth) {
        this.setMillis(this.getChronology().dayOfMonth().set(this.getMillis(), dayOfMonth));
    }

    public void setDayOfWeek(int dayOfWeek) {
        this.setMillis(this.getChronology().dayOfWeek().set(this.getMillis(), dayOfWeek));
    }

    public void addDays(int days) {
        this.setMillis(this.getChronology().days().add(this.getMillis(), days));
    }

    public void setHourOfDay(int hourOfDay) {
        this.setMillis(this.getChronology().hourOfDay().set(this.getMillis(), hourOfDay));
    }

    public void addHours(int hours) {
        this.setMillis(this.getChronology().hours().add(this.getMillis(), hours));
    }

    public void setMinuteOfDay(int minuteOfDay) {
        this.setMillis(this.getChronology().minuteOfDay().set(this.getMillis(), minuteOfDay));
    }

    public void setMinuteOfHour(int minuteOfHour) {
        this.setMillis(this.getChronology().minuteOfHour().set(this.getMillis(), minuteOfHour));
    }

    public void addMinutes(int minutes) {
        this.setMillis(this.getChronology().minutes().add(this.getMillis(), minutes));
    }

    public void setSecondOfDay(int secondOfDay) {
        this.setMillis(this.getChronology().secondOfDay().set(this.getMillis(), secondOfDay));
    }

    public void setSecondOfMinute(int secondOfMinute) {
        this.setMillis(this.getChronology().secondOfMinute().set(this.getMillis(), secondOfMinute));
    }

    public void addSeconds(int seconds) {
        this.setMillis(this.getChronology().seconds().add(this.getMillis(), seconds));
    }

    public void setMillisOfDay(int millisOfDay) {
        this.setMillis(this.getChronology().millisOfDay().set(this.getMillis(), millisOfDay));
    }

    public void setMillisOfSecond(int millisOfSecond) {
        this.setMillis(this.getChronology().millisOfSecond().set(this.getMillis(), millisOfSecond));
    }

    public void addMillis(int millis) {
        this.setMillis(this.getChronology().millis().add(this.getMillis(), millis));
    }

    public void setDate(long instant) {
        this.setMillis(this.getChronology().millisOfDay().set(instant, this.getMillisOfDay()));
    }

    public void setDate(ReadableInstant instant) {
        long instantMillis = DateTimeUtils.getInstantMillis(instant);
        Chronology instantChrono = DateTimeUtils.getInstantChronology(instant);
        DateTimeZone zone = instantChrono.getZone();
        if (zone != null) {
            instantMillis = zone.getMillisKeepLocal(DateTimeZone.UTC, instantMillis);
        }
        this.setDate(instantMillis);
    }

    public void setDate(int year, int monthOfYear, int dayOfMonth) {
        Chronology c = this.getChronology();
        long instantMidnight = c.getDateTimeMillis(year, monthOfYear, dayOfMonth, 0);
        this.setDate(instantMidnight);
    }

    public void setTime(long millis) {
        int millisOfDay = ISOChronology.getInstanceUTC().millisOfDay().get(millis);
        this.setMillis(this.getChronology().millisOfDay().set(this.getMillis(), millisOfDay));
    }

    public void setTime(ReadableInstant instant) {
        long instantMillis = DateTimeUtils.getInstantMillis(instant);
        Chronology instantChrono = DateTimeUtils.getInstantChronology(instant);
        DateTimeZone zone = instantChrono.getZone();
        if (zone != null) {
            instantMillis = zone.getMillisKeepLocal(DateTimeZone.UTC, instantMillis);
        }
        this.setTime(instantMillis);
    }

    public void setTime(int hour, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        long instant = this.getChronology().getDateTimeMillis(this.getMillis(), hour, minuteOfHour, secondOfMinute, millisOfSecond);
        this.setMillis(instant);
    }

    public void setDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        long instant = this.getChronology().getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        this.setMillis(instant);
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    public Property minuteOfDay() {
        return new Property(this, this.getChronology().minuteOfDay());
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public Property secondOfDay() {
        return new Property(this, this.getChronology().secondOfDay());
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    public MutableDateTime copy() {
        return (MutableDateTime)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("Clone error");
        }
    }

    public String toString() {
        return ISODateTimeFormat.dateTime().print(this);
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -4481126543819298617L;
        private final MutableDateTime iInstant;
        private final DateTimeField iField;

        Property(MutableDateTime instant, DateTimeField field) {
            this.iInstant = instant;
            this.iField = field;
        }

        public DateTimeField getField() {
            return this.iField;
        }

        protected long getMillis() {
            return this.iInstant.getMillis();
        }

        public MutableDateTime getMutableDateTime() {
            return this.iInstant;
        }

        public MutableDateTime add(int value) {
            this.iInstant.setMillis(this.getField().add(this.iInstant.getMillis(), value));
            return this.iInstant;
        }

        public MutableDateTime add(long value) {
            this.iInstant.setMillis(this.getField().add(this.iInstant.getMillis(), value));
            return this.iInstant;
        }

        public MutableDateTime addWrapField(int value) {
            this.iInstant.setMillis(this.getField().addWrapField(this.iInstant.getMillis(), value));
            return this.iInstant;
        }

        public MutableDateTime set(int value) {
            this.iInstant.setMillis(this.getField().set(this.iInstant.getMillis(), value));
            return this.iInstant;
        }

        public MutableDateTime set(String text, Locale locale) {
            this.iInstant.setMillis(this.getField().set(this.iInstant.getMillis(), text, locale));
            return this.iInstant;
        }

        public MutableDateTime set(String text) {
            this.set(text, null);
            return this.iInstant;
        }

        public MutableDateTime roundFloor() {
            this.iInstant.setMillis(this.getField().roundFloor(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundCeiling() {
            this.iInstant.setMillis(this.getField().roundCeiling(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundHalfFloor() {
            this.iInstant.setMillis(this.getField().roundHalfFloor(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundHalfCeiling() {
            this.iInstant.setMillis(this.getField().roundHalfCeiling(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundHalfEven() {
            this.iInstant.setMillis(this.getField().roundHalfEven(this.iInstant.getMillis()));
            return this.iInstant;
        }
    }
}

