/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.TimeOfDay;
import org.joda.time.base.BasePartial;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISODateTimeFormat;

public final class YearMonthDay
extends BasePartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 797544782896179L;
    private static final DateTimeFieldType[] FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth()};
    public static final int YEAR = 0;
    public static final int MONTH_OF_YEAR = 1;
    public static final int DAY_OF_MONTH = 2;

    public YearMonthDay() {
    }

    public YearMonthDay(Chronology chronology) {
        super(chronology);
    }

    public YearMonthDay(long instant) {
        super(instant);
    }

    public YearMonthDay(long instant, Chronology chronology) {
        super(instant, chronology);
    }

    public YearMonthDay(Object instant) {
        super(instant, null);
    }

    public YearMonthDay(Object instant, Chronology chronology) {
        super(instant, DateTimeUtils.getChronology(chronology));
    }

    public YearMonthDay(int year, int monthOfYear, int dayOfMonth) {
        this(year, monthOfYear, dayOfMonth, null);
    }

    public YearMonthDay(int year, int monthOfYear, int dayOfMonth, Chronology chronology) {
        super(new int[]{year, monthOfYear, dayOfMonth}, chronology);
    }

    YearMonthDay(YearMonthDay partial, int[] values) {
        super((BasePartial)partial, values);
    }

    YearMonthDay(YearMonthDay partial, Chronology chrono) {
        super((BasePartial)partial, chrono);
    }

    public int size() {
        return 3;
    }

    protected DateTimeField getField(int index, Chronology chrono) {
        switch (index) {
            case 0: {
                return chrono.year();
            }
            case 1: {
                return chrono.monthOfYear();
            }
            case 2: {
                return chrono.dayOfMonth();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    public DateTimeFieldType getFieldType(int index) {
        return FIELD_TYPES[index];
    }

    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public YearMonthDay withChronologyRetainFields(Chronology newChronology) {
        newChronology = DateTimeUtils.getChronology(newChronology);
        if ((newChronology = newChronology.withUTC()) == this.getChronology()) {
            return this;
        }
        return new YearMonthDay(this, newChronology);
    }

    public YearMonthDay withField(DateTimeFieldType fieldType, int value) {
        int index = this.indexOfSupported(fieldType);
        if (value == this.getValue(index)) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).set(this, index, newValues, value);
        return new YearMonthDay(this, newValues);
    }

    public YearMonthDay withFieldAdded(DurationFieldType fieldType, int amount) {
        int index = this.indexOfSupported(fieldType);
        if (amount == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).add(this, index, newValues, amount);
        return new YearMonthDay(this, newValues);
    }

    public YearMonthDay withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        int i = 0;
        while (i < period.size()) {
            DurationFieldType fieldType = period.getFieldType(i);
            int index = this.indexOf(fieldType);
            if (index >= 0) {
                newValues = this.getField(index).add(this, index, newValues, FieldUtils.safeMultiplyToInt(period.getValue(i), scalar));
            }
            ++i;
        }
        return new YearMonthDay(this, newValues);
    }

    public YearMonthDay plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public YearMonthDay minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public Property property(DateTimeFieldType type) {
        return new Property(this, this.indexOfSupported(type));
    }

    public DateTime toDateTimeAtMidnight() {
        return this.toDateTimeAtMidnight(null);
    }

    public DateTime toDateTimeAtMidnight(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), 0, 0, 0, 0, chrono);
    }

    public DateTime toDateTimeAtCurrentTime() {
        return this.toDateTimeAtCurrentTime(null);
    }

    public DateTime toDateTimeAtCurrentTime(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        long instantMillis = DateTimeUtils.currentTimeMillis();
        long resolved = chrono.set(this, instantMillis);
        return new DateTime(resolved, chrono);
    }

    public DateMidnight toDateMidnight() {
        return this.toDateMidnight(null);
    }

    public DateMidnight toDateMidnight(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        return new DateMidnight(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), chrono);
    }

    public DateTime toDateTime(TimeOfDay time) {
        return this.toDateTime(time, null);
    }

    public DateTime toDateTime(TimeOfDay time, DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        long instant = DateTimeUtils.currentTimeMillis();
        instant = chrono.set(this, instant);
        if (time != null) {
            instant = chrono.set(time, instant);
        }
        return new DateTime(instant, chrono);
    }

    public Interval toInterval() {
        return this.toInterval(null);
    }

    public Interval toInterval(DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        return this.toDateMidnight(zone).toInterval();
    }

    public int getYear() {
        return this.getValue(0);
    }

    public int getMonthOfYear() {
        return this.getValue(1);
    }

    public int getDayOfMonth() {
        return this.getValue(2);
    }

    public Property year() {
        return new Property(this, 0);
    }

    public Property monthOfYear() {
        return new Property(this, 1);
    }

    public Property dayOfMonth() {
        return new Property(this, 2);
    }

    public String toString() {
        return ISODateTimeFormat.yearMonthDay().print(this);
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5727734012190224363L;
        private final YearMonthDay iYearMonthDay;
        private final int iFieldIndex;

        Property(YearMonthDay partial, int fieldIndex) {
            this.iYearMonthDay = partial;
            this.iFieldIndex = fieldIndex;
        }

        public DateTimeField getField() {
            return this.iYearMonthDay.getField(this.iFieldIndex);
        }

        protected ReadablePartial getReadablePartial() {
            return this.iYearMonthDay;
        }

        public YearMonthDay getYearMonthDay() {
            return this.iYearMonthDay;
        }

        public int get() {
            return this.iYearMonthDay.getValue(this.iFieldIndex);
        }

        public YearMonthDay addToCopy(int valueToAdd) {
            int[] newValues = this.iYearMonthDay.getValues();
            newValues = this.getField().add(this.iYearMonthDay, this.iFieldIndex, newValues, valueToAdd);
            return new YearMonthDay(this.iYearMonthDay, newValues);
        }

        public YearMonthDay addWrapFieldToCopy(int valueToAdd) {
            int[] newValues = this.iYearMonthDay.getValues();
            newValues = this.getField().addWrapField(this.iYearMonthDay, this.iFieldIndex, newValues, valueToAdd);
            return new YearMonthDay(this.iYearMonthDay, newValues);
        }

        public YearMonthDay setCopy(int value) {
            int[] newValues = this.iYearMonthDay.getValues();
            newValues = this.getField().set(this.iYearMonthDay, this.iFieldIndex, newValues, value);
            return new YearMonthDay(this.iYearMonthDay, newValues);
        }

        public YearMonthDay setCopy(String text, Locale locale) {
            int[] newValues = this.iYearMonthDay.getValues();
            newValues = this.getField().set(this.iYearMonthDay, this.iFieldIndex, newValues, text, locale);
            return new YearMonthDay(this.iYearMonthDay, newValues);
        }

        public YearMonthDay setCopy(String text) {
            return this.setCopy(text, null);
        }
    }
}

