/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BaseGJChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class CopticDayOfMonthDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -5441610762799659434L;
    private final BaseGJChronology iChronology;

    CopticDayOfMonthDateTimeField(BaseGJChronology chronology, DurationField days) {
        super(DateTimeFieldType.dayOfMonth(), days);
        this.iChronology = chronology;
    }

    public int get(long instant) {
        return (this.iChronology.getDayOfYear(instant) - 1) % 30 + 1;
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.months();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return 30;
    }

    public int getMaximumValue(long instant) {
        if ((this.iChronology.getDayOfYear(instant) - 1) / 30 < 12) {
            return 30;
        }
        return this.iChronology.isLeapYear(this.iChronology.getYear(instant)) ? 6 : 5;
    }

    public int getMaximumValue(ReadablePartial partial) {
        if (partial.isSupported(DateTimeFieldType.monthOfYear())) {
            int month = partial.get(DateTimeFieldType.monthOfYear());
            if (month <= 12) {
                return 30;
            }
            if (partial.isSupported(DateTimeFieldType.year())) {
                int year = partial.get(DateTimeFieldType.year());
                return this.iChronology.isLeapYear(year) ? 6 : 5;
            }
            return 6;
        }
        return 30;
    }

    public int getMaximumValue(ReadablePartial partial, int[] values) {
        int size = partial.size();
        int i = 0;
        while (i < size) {
            if (partial.getFieldType(i) == DateTimeFieldType.monthOfYear()) {
                int month = values[i];
                if (month <= 12) {
                    return 30;
                }
                int j = 0;
                while (j < size) {
                    if (partial.getFieldType(j) == DateTimeFieldType.year()) {
                        int year = values[j];
                        return this.iChronology.isLeapYear(year) ? 6 : 5;
                    }
                    ++j;
                }
                return 6;
            }
            ++i;
        }
        return 30;
    }

    private Object readResolve() {
        return this.iChronology.dayOfMonth();
    }
}

