/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BaseGJChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

final class CopticYearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = 8990199361773280783L;
    private final BaseGJChronology iChronology;

    CopticYearDateTimeField(BaseGJChronology chronology) {
        super(DateTimeFieldType.year(), chronology.getAverageMillisPerYear());
        this.iChronology = chronology;
    }

    public boolean isLenient() {
        return false;
    }

    public int get(long instant) {
        return this.iChronology.getYear(instant);
    }

    public long add(long instant, int years) {
        if (years == 0) {
            return instant;
        }
        return this.set(instant, this.get(instant) + years);
    }

    public long add(long instant, long years) {
        return this.add(instant, FieldUtils.safeToInt(years));
    }

    public long addWrapField(long instant, int years) {
        if (years == 0) {
            return instant;
        }
        int thisYear = this.iChronology.getYear(instant);
        int wrappedYear = FieldUtils.getWrappedValue(thisYear, years, this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        return this.set(instant, wrappedYear);
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        if (minuendInstant < subtrahendInstant) {
            return -this.getDifference(subtrahendInstant, minuendInstant);
        }
        int minuendYear = this.get(minuendInstant);
        int subtrahendYear = this.get(subtrahendInstant);
        long minuendRem = minuendInstant - this.iChronology.getYearMillis(minuendYear);
        long subtrahendRem = subtrahendInstant - this.iChronology.getYearMillis(subtrahendYear);
        int difference = minuendYear - subtrahendYear;
        if (minuendRem < subtrahendRem) {
            --difference;
        }
        return difference;
    }

    public long set(long instant, int year) {
        FieldUtils.verifyValueBounds(this, year, this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        BaseGJChronology chrono = this.iChronology;
        int thisYear = chrono.getYear(instant);
        int dayOfYear = chrono.getDayOfYear(instant, thisYear);
        int millisOfDay = chrono.getMillisOfDay(instant);
        if (dayOfYear > 365 && !chrono.isLeapYear(year)) {
            --dayOfYear;
        }
        instant = chrono.getYearMonthDayMillis(year, 1, dayOfYear);
        return instant += (long)millisOfDay;
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public boolean isLeap(long instant) {
        return this.iChronology.isLeapYear(this.get(instant));
    }

    public int getLeapAmount(long instant) {
        if (this.iChronology.isLeapYear(this.get(instant))) {
            return 1;
        }
        return 0;
    }

    public DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    public int getMinimumValue() {
        return this.iChronology.getMinYear();
    }

    public int getMaximumValue() {
        return this.iChronology.getMaxYear();
    }

    public long roundFloor(long instant) {
        return this.iChronology.getYearMillis(this.get(instant));
    }

    public long roundCeiling(long instant) {
        int year = this.get(instant);
        long yearStartMillis = this.iChronology.getYearMillis(year);
        if (instant != yearStartMillis) {
            instant = this.iChronology.getYearMillis(year + 1);
        }
        return instant;
    }

    public long remainder(long instant) {
        return instant - this.roundFloor(instant);
    }

    private Object readResolve() {
        return this.iChronology.year();
    }
}

