/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public abstract class AbstractPartialFieldProperty {
    protected AbstractPartialFieldProperty() {
    }

    public abstract DateTimeField getField();

    public DateTimeFieldType getFieldType() {
        return this.getField().getType();
    }

    public String getName() {
        return this.getField().getName();
    }

    protected abstract ReadablePartial getReadablePartial();

    public abstract int get();

    public String getAsText(Locale locale) {
        return this.getField().getAsText(this.getReadablePartial(), this.get(), locale);
    }

    public String getAsText() {
        return this.getAsText(null);
    }

    public String getAsShortText(Locale locale) {
        return this.getField().getAsShortText(this.getReadablePartial(), this.get(), locale);
    }

    public String getAsShortText() {
        return this.getAsShortText(null);
    }

    public DurationField getDurationField() {
        return this.getField().getDurationField();
    }

    public DurationField getRangeDurationField() {
        return this.getField().getRangeDurationField();
    }

    public int getMinimumValueOverall() {
        return this.getField().getMinimumValue();
    }

    public int getMinimumValue() {
        return this.getField().getMinimumValue(this.getReadablePartial());
    }

    public int getMaximumValueOverall() {
        return this.getField().getMaximumValue();
    }

    public int getMaximumValue() {
        return this.getField().getMaximumValue(this.getReadablePartial());
    }

    public int getMaximumTextLength(Locale locale) {
        return this.getField().getMaximumTextLength(locale);
    }

    public int getMaximumShortTextLength(Locale locale) {
        return this.getField().getMaximumShortTextLength(locale);
    }

    public int compareTo(ReadableInstant instant) {
        int otherValue;
        if (instant == null) {
            throw new IllegalArgumentException("The instant must not be null");
        }
        int thisValue = this.get();
        if (thisValue < (otherValue = instant.get(this.getFieldType()))) {
            return -1;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return 0;
    }

    public int compareTo(ReadablePartial partial) {
        int otherValue;
        if (partial == null) {
            throw new IllegalArgumentException("The instant must not be null");
        }
        int thisValue = this.get();
        if (thisValue < (otherValue = partial.get(this.getFieldType()))) {
            return -1;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AbstractPartialFieldProperty) {
            AbstractPartialFieldProperty other = (AbstractPartialFieldProperty)object;
            if (this.get() == other.get() && this.getFieldType() == other.getFieldType() && this.getReadablePartial().getChronology() == other.getReadablePartial().getChronology()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Property[" + this.getName() + "]";
    }
}

