/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadWritableInstant;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.FormatUtils;

public class DateTimeFormatter {
    private final DateTimePrinter iPrinter;
    private final DateTimeParser iParser;
    private final Locale iLocale;
    private final boolean iOffsetParsed;
    private final Chronology iChrono;
    private final DateTimeZone iZone;

    public DateTimeFormatter(DateTimePrinter printer, DateTimeParser parser) {
        this.iPrinter = printer;
        this.iParser = parser;
        this.iLocale = null;
        this.iOffsetParsed = false;
        this.iChrono = null;
        this.iZone = null;
    }

    private DateTimeFormatter(DateTimePrinter printer, DateTimeParser parser, Locale locale, boolean offsetParsed, Chronology chrono, DateTimeZone zone) {
        this.iPrinter = printer;
        this.iParser = parser;
        this.iLocale = locale;
        this.iOffsetParsed = offsetParsed;
        this.iChrono = chrono;
        this.iZone = zone;
    }

    public boolean isPrinter() {
        return this.iPrinter != null;
    }

    public DateTimePrinter getPrinter() {
        return this.iPrinter;
    }

    public boolean isParser() {
        return this.iParser != null;
    }

    public DateTimeParser getParser() {
        return this.iParser;
    }

    public DateTimeFormatter withLocale(Locale locale) {
        if (locale == this.getLocale() || locale != null && locale.equals(this.getLocale())) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, locale, this.iOffsetParsed, this.iChrono, this.iZone);
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public DateTimeFormatter withOffsetParsed() {
        if (this.iOffsetParsed) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, true, this.iChrono, null);
    }

    public boolean isOffsetParsed() {
        return this.iOffsetParsed;
    }

    public DateTimeFormatter withChronology(Chronology chrono) {
        if (this.iChrono == chrono) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, chrono, this.iZone);
    }

    public Chronology getChronolgy() {
        return this.iChrono;
    }

    public DateTimeFormatter withZone(DateTimeZone zone) {
        if (this.iZone == zone) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, false, this.iChrono, zone);
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    public void printTo(StringBuffer buf, ReadableInstant instant) {
        this.checkPrinter();
        long millis = DateTimeUtils.getInstantMillis(instant);
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        this.printTo(buf, millis, chrono);
    }

    public void printTo(Writer out, ReadableInstant instant) throws IOException {
        this.checkPrinter();
        long millis = DateTimeUtils.getInstantMillis(instant);
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        this.printTo(out, millis, chrono);
    }

    public void printTo(StringBuffer buf, long instant) {
        this.checkPrinter();
        this.printTo(buf, instant, null);
    }

    public void printTo(Writer out, long instant) throws IOException {
        this.checkPrinter();
        this.printTo(out, instant, null);
    }

    public void printTo(StringBuffer buf, ReadablePartial partial) {
        this.checkPrinter();
        if (partial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        this.iPrinter.printTo(buf, partial, this.iLocale);
    }

    public void printTo(Writer out, ReadablePartial partial) throws IOException {
        this.checkPrinter();
        if (partial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        this.iPrinter.printTo(out, partial, this.iLocale);
    }

    public String print(ReadableInstant instant) {
        this.checkPrinter();
        StringBuffer buf = new StringBuffer(this.iPrinter.estimatePrintedLength());
        this.printTo(buf, instant);
        return buf.toString();
    }

    public String print(long instant) {
        this.checkPrinter();
        StringBuffer buf = new StringBuffer(this.iPrinter.estimatePrintedLength());
        this.printTo(buf, instant);
        return buf.toString();
    }

    public String print(ReadablePartial partial) {
        this.checkPrinter();
        StringBuffer buf = new StringBuffer(this.iPrinter.estimatePrintedLength());
        this.printTo(buf, partial);
        return buf.toString();
    }

    private void printTo(StringBuffer buf, long instant, Chronology chrono) {
        chrono = this.selectChronology(chrono);
        DateTimeZone zone = chrono.getZone();
        int offset = zone.getOffset(instant);
        this.iPrinter.printTo(buf, instant + (long)offset, chrono.withUTC(), offset, zone, this.iLocale);
    }

    private void printTo(Writer buf, long instant, Chronology chrono) throws IOException {
        chrono = this.selectChronology(chrono);
        DateTimeZone zone = chrono.getZone();
        int offset = zone.getOffset(instant);
        this.iPrinter.printTo(buf, instant + (long)offset, chrono.withUTC(), offset, zone, this.iLocale);
    }

    private void checkPrinter() {
        if (this.iPrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
    }

    public int parseInto(ReadWritableInstant instant, String text, int position) {
        this.checkParser();
        if (instant == null) {
            throw new IllegalArgumentException("Instant must not be null");
        }
        long instantMillis = instant.getMillis();
        Chronology chrono = instant.getChronology();
        long instantLocal = instantMillis + (long)chrono.getZone().getOffset(instantMillis);
        chrono = this.selectChronology(chrono);
        DateTimeParserBucket bucket = new DateTimeParserBucket(instantLocal, chrono, this.iLocale);
        int newPos = this.iParser.parseInto(bucket, text, position);
        instant.setMillis(bucket.computeMillis());
        if (this.iOffsetParsed && bucket.getZone() == null) {
            int parsedOffset = bucket.getOffset();
            DateTimeZone parsedZone = DateTimeZone.forOffsetMillis(parsedOffset);
            chrono = chrono.withZone(parsedZone);
        }
        instant.setChronology(chrono);
        return newPos;
    }

    public long parseMillis(String text) {
        this.checkParser();
        Chronology chrono = this.selectChronology(this.iChrono);
        DateTimeParserBucket bucket = new DateTimeParserBucket(0L, chrono, this.iLocale);
        int newPos = this.iParser.parseInto(bucket, text, 0);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                return bucket.computeMillis(true);
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }

    public DateTime parseDateTime(String text) {
        this.checkParser();
        Chronology chrono = this.selectChronology(null);
        DateTimeParserBucket bucket = new DateTimeParserBucket(0L, chrono, this.iLocale);
        int newPos = this.iParser.parseInto(bucket, text, 0);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                long millis = bucket.computeMillis(true);
                if (this.iOffsetParsed && bucket.getZone() == null) {
                    int parsedOffset = bucket.getOffset();
                    DateTimeZone parsedZone = DateTimeZone.forOffsetMillis(parsedOffset);
                    chrono = chrono.withZone(parsedZone);
                }
                return new DateTime(millis, chrono);
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }

    public MutableDateTime parseMutableDateTime(String text) {
        this.checkParser();
        Chronology chrono = this.selectChronology(null);
        DateTimeParserBucket bucket = new DateTimeParserBucket(0L, chrono, this.iLocale);
        int newPos = this.iParser.parseInto(bucket, text, 0);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                long millis = bucket.computeMillis(true);
                if (this.iOffsetParsed && bucket.getZone() == null) {
                    int parsedOffset = bucket.getOffset();
                    DateTimeZone parsedZone = DateTimeZone.forOffsetMillis(parsedOffset);
                    chrono = chrono.withZone(parsedZone);
                }
                return new MutableDateTime(millis, chrono);
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }

    private void checkParser() {
        if (this.iParser == null) {
            throw new UnsupportedOperationException("Parsing not supported");
        }
    }

    private Chronology selectChronology(Chronology chrono) {
        chrono = DateTimeUtils.getChronology(chrono);
        if (this.iChrono != null) {
            chrono = this.iChrono;
        }
        if (this.iZone != null) {
            chrono = chrono.withZone(this.iZone);
        }
        return chrono;
    }
}

