/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.transcoder.TranscoderInput;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import ru.infor.boxboard.BoxServerConnector;
import ru.infor.boxboard.CanvasModifier;
import ru.infor.boxboard.LocalModelConnector;
import ru.infor.boxboard.ModelPlacer;
import ru.infor.boxboard.ModelsConnector;
import ru.infor.boxboard.ParamTableModel;
import ru.infor.boxboard.Parameters;
import ru.infor.boxboard.SVGElementCreator;
import ru.infor.boxboard.SaveForm;
import ru.infor.boxboard.badnews.ErrorFrame;
import ru.infor.boxboard.models.DrawBoxParam;
import ru.infor.boxboard.print.PrintModel;
import ru.infor.boxboard.print.PrintTranscoder;
import ru.infor.navy.util.LengthCollector;
import ru.infor.navy.util.PanelTools;
import ru.infor.navy.util.myXML;

public class BoxBoardClient
extends JFrame {
    public static final String clGrey = "#DAD9D4";
    public static final String clRed = "#ff0000";
    JPanel topPan = new JPanel(new FlowLayout(0));
    JPanel leftPan = new JPanel();
    JPanel infoPan = new JPanel(new FlowLayout(0));
    JLabel infoLabel = new JLabel(" ");
    String lenLabelText = "\u041e\u0431\u0449\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0439: <font color=blue>";
    double modelLength = 0.0;
    JLabel lenLabel = new JLabel("<html>\u0414\u043b\u0438\u043d\u0430: <font color=blue>0.00<font color=black> \u043c\u043c.");
    JSVGCanvas canvas = new JSVGCanvas();
    SVGElementCreator svgCreator = new SVGElementCreator();
    Vector<SVGElement> gridV = new Vector();
    Vector<SVGElement> gridH = new Vector();
    Element svgLenTextElement;
    SVGElement svgLenInfo = null;
    JButton button = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
    JButton buttonP = new JButton("\u041d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c");
    JButton buttonRecalc = new JButton("\u041f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u0430\u0442\u044c");
    JSplitPane splitMain = new JSplitPane(1);
    JSplitPane split2 = new JSplitPane(0, true);
    JList dataList;
    int selectedModelNum = -1;
    boolean modelChanged = false;
    JTabbedPane tp = null;
    ModelsConnector modelsConnector;
    public ParamTableModel paramModel = new ParamTableModel();
    JTable paramTable = new JTable(this.paramModel){

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 2) {
                DrawBoxParam dbp = BoxBoardClient.this.paramModel.rows.elementAt(row);
                if (dbp.type != 2) {
                    return super.getCellEditor(row, column);
                }
                String[] items = new String[dbp.listValues.size()];
                int i = 0;
                while (i < dbp.listValues.size()) {
                    items[i] = dbp.listValues.elementAt((int)i).name;
                    ++i;
                }
                return new ParamComboBoxEditor(items);
            }
            return super.getCellEditor(row, column);
        }
    };
    public Parameters params = new Parameters("properties.xml");
    public SaveForm saveForm = null;
    public ModelPlacer modelPlacer = new ModelPlacer(this);

    private JPanel createSelectPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.setButtons();
        this.initCanvas();
        this.splitMain.setLeftComponent(this.split2);
        this.splitMain.setDividerLocation(250);
        JPanel buttons = new JPanel(new FlowLayout(0));
        buttons.setMaximumSize(new Dimension(1000, this.button.getHeight() + 120));
        buttons.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 100)));
        buttons.add(this.buttonRecalc);
        buttons.add(this.button);
        buttons.add(this.buttonP);
        JPanel cpan = PanelTools.createVerticalPanel();
        cpan.add(buttons);
        cpan.add(this.canvas);
        this.splitMain.setRightComponent(cpan);
        this.splitMain.setLeftComponent(this.split2);
        this.leftPan.setLayout(new BoxLayout(this.leftPan, 1));
        buttons.setMaximumSize(new Dimension(1000, this.button.getHeight() + 120));
        this.leftPan.add(new JScrollPane(this.dataList));
        this.split2.setTopComponent(this.leftPan);
        JPanel recalcPan = new JPanel();
        recalcPan.setLayout(new BoxLayout(recalcPan, 1));
        recalcPan.add(new JScrollPane(this.paramTable));
        this.split2.setBottomComponent(recalcPan);
        this.split2.setDividerLocation(200);
        JTableHeader header = this.paramTable.getTableHeader();
        TableColumnModel cm = header.getColumnModel();
        cm.getColumn(0).setMaxWidth(20);
        cm.getColumn(1).setMaxWidth(300);
        cm.getColumn(1).setPreferredWidth(200);
        cm.getColumn(2).setMaxWidth(70);
        p.add(this.splitMain);
        return p;
    }

    private void initCanvas() {
        new CanvasModifier();
        CanvasModifier.modify(this.canvas);
        this.canvas.setDocumentState(1);
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.canvas.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter(){

            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                BoxBoardClient.this.calcLength(BoxBoardClient.this.canvas.getSVGDocument());
                BoxBoardClient.this.reScale();
            }
        });
        this.canvas.addUpdateManagerListener(new UpdateManagerListener(){

            public void managerResumed(UpdateManagerEvent arg0) {
            }

            public void managerStarted(UpdateManagerEvent arg0) {
                BoxBoardClient.this.reScale();
                if (BoxBoardClient.this.modelChanged) {
                    BoxBoardClient.this.modelPlacer.setBlockPart(BoxBoardClient.this.canvas.getSVGDocument().getRootElement(), BoxBoardClient.this.modelLength);
                    BoxBoardClient.this.modelChanged = false;
                } else {
                    BoxBoardClient.this.modelPlacer.changeBlockPart(BoxBoardClient.this.canvas.getSVGDocument().getRootElement(), BoxBoardClient.this.modelLength);
                }
                BoxBoardClient.this.tp.setEnabledAt(1, true);
                BoxBoardClient.this.tp.setEnabledAt(2, true);
            }

            public void managerStopped(UpdateManagerEvent arg0) {
            }

            public void managerSuspended(UpdateManagerEvent arg0) {
            }

            public void updateCompleted(UpdateManagerEvent arg0) {
            }

            public void updateFailed(UpdateManagerEvent arg0) {
            }

            public void updateStarted(UpdateManagerEvent arg0) {
            }
        });
    }

    private void setButtons() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/ru/infor/boxboard/res/refresh.png"));
        this.buttonRecalc.setIcon(icon);
        String text = "<html>&nbsp;\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f&nbsp;";
        this.buttonRecalc.setToolTipText(text);
        this.buttonRecalc.setMargin(new Insets(0, 6, 0, 6));
        this.buttonRecalc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoxBoardClient.this.calculateModel();
            }
        });
        icon = new ImageIcon(this.getClass().getResource("/ru/infor/boxboard/res/floppy.png"));
        this.button.setIcon(icon);
        this.button.setMargin(new Insets(0, 6, 0, 6));
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoxBoardClient.this.saveForm.save(BoxBoardClient.this.canvas, String.valueOf(BoxBoardClient.this.generateOutFileName()) + ".svg", false, true);
            }
        });
        text = "<html>&nbsp;\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0432 \u0444\u0430\u0439\u043b&nbsp;<br>&nbsp;\u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 <b>SVG</b>&nbsp;";
        this.button.setToolTipText(text);
        icon = new ImageIcon(this.getClass().getResource("/ru/infor/boxboard/res/print.png"));
        this.buttonP.setIcon(icon);
        this.buttonP.setMargin(new Insets(0, 6, 0, 6));
        this.buttonP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoxBoardClient.this.printDoc();
            }
        });
        text = "<html>&nbsp;\u041d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0441 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u043c&nbsp;<br>&nbsp;\u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u0438\u0435\u043c \u043f\u043e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430\u043c&nbsp;";
        this.buttonP.setToolTipText(text);
    }

    public void setStatusText(String text) {
        this.infoLabel.setText(text);
    }

    private void calculateModel() {
        int pos = this.dataList.getSelectedIndex();
        Vector<DrawBoxParam> dbp = this.modelsConnector.setParameters(pos, this.paramModel.rows);
        int i = 0;
        while (i < dbp.size()) {
            DrawBoxParam dbpFrom = dbp.elementAt(i);
            DrawBoxParam dbpTo = this.paramModel.rows.elementAt(i);
            dbpTo.setValue(dbpFrom.getValue(), false);
            if (dbpTo.type == 2) {
                dbpTo.index = dbpFrom.index;
            }
            ++i;
        }
        Document doc = this.modelsConnector.getModel(pos);
        this.canvas.setDocument(doc);
        this.paramModel.fireTableDataChanged();
    }

    private void initGUI() {
        try {
            this.saveForm = new SaveForm(this);
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/ru/infor/boxboard/res/package.png"));
            this.setIconImage(icon.getImage());
            this.paramModel.bb = this;
            JPanel main = (JPanel)this.getContentPane();
            this.tp = new JTabbedPane();
            main.add((Component)this.tp, "Center");
            main.add((Component)this.infoPan, "South");
            this.infoPan.add(this.infoLabel);
            this.infoPan.setBorder(new BevelBorder(1));
            this.modelPlacer.setPageParam();
            String local = this.params.getNamingProperties().get("local");
            this.modelsConnector = (local == null ? "" : local).compareTo("1") == 0 ? new LocalModelConnector() : new BoxServerConnector(this.params.getNamingProperties().get("server"));
            this.initSketches();
            this.tp.add("<html><b>1.</b> <font color=blue>\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d", this.createSelectPanel());
            this.tp.add("<html><b>2.</b> <font color=blue>\u0421\u043a\u043e\u043c\u043f\u043e\u043d\u043e\u0432\u0430\u0442\u044c", this.modelPlacer.createGroupPanel());
            this.tp.add("<html><b>3.</b> <font color=blue>\u0420\u0430\u0437\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u043d\u0430 \u043b\u0438\u0441\u0442\u0435", this.modelPlacer.createPlacePanel());
            this.tp.setEnabledAt(1, false);
            this.tp.setEnabledAt(2, false);
            this.tp.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent evt) {
                    JTabbedPane pane = (JTabbedPane)evt.getSource();
                    int sel = pane.getSelectedIndex();
                    if (sel == 0) {
                        BoxBoardClient.this.canvas.grabFocus();
                        BoxBoardClient.this.showModelInfo();
                    }
                    if (sel == 1) {
                        BoxBoardClient.this.modelPlacer.addPageBorder(BoxBoardClient.this.modelPlacer.canvas.getSVGDocument());
                        BoxBoardClient.this.modelPlacer.canvas.grabFocus();
                        BoxBoardClient.this.showGroupInfo();
                    }
                    if (sel == 2) {
                        BoxBoardClient.this.modelPlacer.combineModel();
                        BoxBoardClient.this.modelPlacer.placeCanvas.grabFocus();
                    }
                }
            });
            this.setDefaultCloseOperation(3);
            this.pack();
            this.setPosition();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showModelInfo() {
        SVGRect rect = this.canvas.getSVGDocument().getRootElement().getBBox();
        this.setStatusText("<html>" + this.lenLabelText + String.format("<font color=blue><b>%8.2f</b>", this.modelLength) + "<font color=black> \u043c\u043c., \u0440\u0430\u0437\u043c\u0435\u0440\u044b: " + String.format("<font color=blue><b>%8.2f</b>", (double)rect.getWidth() / 2.83) + "<font color=black>  x " + String.format("<font color=blue><b>%8.2f</b>", (double)rect.getHeight() / 2.83) + "<font color=black>  \u043c\u043c.");
    }

    private void showGroupInfo() {
        this.modelPlacer.setPrePlaceInfo();
    }

    private void setPosition() {
        this.setSize(1000, 700);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void reScale() {
        double scale;
        AffineTransform transform = new AffineTransform();
        Dimension2D d = this.canvas.getSVGDocumentSize();
        Rectangle rect = this.canvas.getVisibleRect();
        double xmove = 0.0;
        double ymove = 0.0;
        double scaleX = (double)rect.width / d.getWidth();
        ymove = (double)rect.height - d.getHeight() * scaleX;
        double scaleY = (double)rect.height / d.getHeight();
        xmove = (double)rect.width - d.getWidth() * scaleY;
        if (scaleX < scaleY) {
            scale = scaleX;
            xmove = 0.0;
        } else {
            scale = scaleY;
            ymove = 0.0;
        }
        transform.scale(scale, scale);
        transform.translate(xmove, ymove);
        this.canvas.setRenderingTransform(transform);
    }

    private void initSketches() {
        this.dataList = new JList<String>(this.modelsConnector.getModelList());
        this.dataList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int pos = BoxBoardClient.this.dataList.locationToIndex(e.getPoint());
                if (pos != BoxBoardClient.this.selectedModelNum) {
                    BoxBoardClient.this.selectedModelNum = pos;
                    BoxBoardClient.this.modelChanged = true;
                    BoxBoardClient.this.paramModel.setParamData(BoxBoardClient.this.modelsConnector.getParamList(pos));
                    BoxBoardClient.this.calculateModel();
                }
            }
        });
    }

    private void addElement(myXML root, SVGElement svg) {
        try {
            myXML sub = root.addElement("path");
            NamedNodeMap nmp = svg.getAttributes();
            int i = 0;
            while (i < nmp.getLength()) {
                Node nn = nmp.item(i);
                sub.Attribute.add(nn.getNodeName(), nn.getNodeValue());
                ++i;
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (myXML.myXMLException e) {
            e.printStackTrace();
        }
    }

    public void calcLength(Document document) {
        LengthCollector lc = new LengthCollector(document);
        this.modelLength = lc.totalLength;
        this.showModelInfo();
    }

    public static void writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public void saveSVG(String fileName) {
        SVGDocument document = this.canvas.getSVGDocument();
        LengthCollector lc = new LengthCollector(document);
        this.svgLenInfo = lc.drawInfo(this.canvas, 10.0, 10.0);
        BoxBoardClient.writeXmlFile(this.canvas.getSVGDocument(), fileName);
    }

    public void reDraw() {
    }

    public String generateOutFileName() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dataList.getSelectedValue()).append("_");
        sb.append(this.paramModel.rows.elementAt(0).getValue()).append("x");
        sb.append(this.paramModel.rows.elementAt(1).getValue()).append("x");
        sb.append(this.paramModel.rows.elementAt(2).getValue());
        return sb.toString();
    }

    public void printDoc1() {
        PrintTranscoder prm = new PrintTranscoder();
        TranscoderInput ti = new TranscoderInput(this.canvas.getSVGDocument());
        Dimension2D d = this.canvas.getSVGDocumentSize();
        Rectangle rect = new Rectangle(0, 0, (int)d.getWidth(), (int)d.getHeight());
        prm.addTranscodingHint(PrintTranscoder.KEY_HEIGHT, new Float(rect.height));
        prm.addTranscodingHint(PrintTranscoder.KEY_WIDTH, new Float(rect.width));
        prm.addTranscodingHint(PrintTranscoder.KEY_AOI, rect);
        prm.transcode(ti, null);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        if (printerJob.pageDialog(pageFormat) != pageFormat) {
            if (printerJob.printDialog()) {
                printerJob.setPrintable(prm);
                try {
                    printerJob.print();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        } else {
            System.err.println("Print was cancelled");
        }
    }

    public void printDoc() {
        PageFormat pageFormat;
        PrintModel pm = new PrintModel(this.canvas);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob.pageDialog(pageFormat = printerJob.defaultPage()) != pageFormat) {
            if (printerJob.printDialog()) {
                printerJob.setPrintable(pm);
                try {
                    printerJob.print();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        } else {
            System.err.println("Print was cancelled");
        }
    }

    public void createGrid(double stepx, double stepy) {
        stepx *= 2.83;
        stepy *= 2.83;
        this.removeGrid();
        Dimension2D d = this.canvas.getSVGDocumentSize();
        double width = d.getWidth();
        double height = d.getHeight();
        SVGDocument doc = this.canvas.getSVGDocument();
        int x = 0;
        while ((double)x < width) {
            this.gridV.add((SVGElement)this.svgCreator.createLine(doc, x, 0.0, x, height, clRed, 0.5));
            x = (int)((double)x + stepx);
        }
        int y = 0;
        while ((double)y < height) {
            this.gridH.add((SVGElement)this.svgCreator.createLine(doc, 0.0, y, width, y, clRed, 0.5));
            y = (int)((double)y + stepy);
        }
        this.repaint();
    }

    public void removeGrid() {
        SVGSVGElement svgRoot = this.canvas.getSVGDocument().getRootElement();
        int i = 0;
        while (i < this.gridV.size()) {
            svgRoot.removeChild(this.gridV.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < this.gridH.size()) {
            svgRoot.removeChild(this.gridH.elementAt(i));
            ++i;
        }
        this.gridH.removeAllElements();
        this.gridV.removeAllElements();
        this.repaint();
    }

    public BoxBoardClient() {
        super("\u041a\u043e\u0440\u043e\u0431\u043e\u0447\u043a\u0438");
        this.initGUI();
    }

    public static void main(String[] args) {
        try {
            UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
            Options.setDefaultIconSize(new Dimension(18, 18));
            String lafName = LookUtils.IS_OS_WINDOWS_XP ? Options.getCrossPlatformLookAndFeelClassName() : Options.getSystemLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(lafName);
            }
            catch (Exception e) {
                System.err.println("Can't set look & feel:" + e);
            }
            BoxBoardClient inst = new BoxBoardClient();
            inst.setVisible(true);
        }
        catch (RuntimeException e) {
            System.out.println("oops!");
            new ErrorFrame(e.getMessage());
        }
    }

    public class ParamComboBoxEditor
    extends DefaultCellEditor {
        public ParamComboBoxEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }
}

