/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import ru.infor.boxboard.BoxRequest;
import ru.infor.boxboard.ModelsConnector;
import ru.infor.boxboard.models.DrawBoxParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxServerConnector
implements ModelsConnector {
    private String serverUrl = "";
    XStream xstream = null;
    String cookies = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public BoxServerConnector(String url) {
        this.serverUrl = url;
        this.xstream = new XStream();
        this.xstream.alias("BoxRequest", BoxRequest.class);
        this.xstream.alias("DrawBoxParam", DrawBoxParam.class);
        this.xstream.alias("Vector", Vector.class);
    }

    public String sendRequest(BoxRequest br) {
        StringBuffer sb = new StringBuffer();
        String xmlReq = this.xstream.toXML(br);
        System.out.println(xmlReq);
        try {
            String str;
            String data = String.valueOf(URLEncoder.encode("request", "UTF-8")) + "=" + URLEncoder.encode(xmlReq, "UTF-8");
            URL url = new URL(this.serverUrl);
            URLConnection conn = url.openConnection();
            if (this.cookies != "") {
                conn.setRequestProperty("Cookie", this.cookies);
            }
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            if (this.cookies == "") {
                int i = 0;
                while (true) {
                    String headerName = conn.getHeaderFieldKey(i);
                    String headerValue = conn.getHeaderField(i);
                    if (headerName == null && headerValue == null) break;
                    if ("Set-Cookie".equalsIgnoreCase(headerName)) {
                        this.cookies = headerValue;
                    }
                    ++i;
                }
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
            in.close();
            wr.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "\u041e\u0448\u0438\u0431\u043a\u0430");
        }
        return sb.toString();
    }

    @Override
    public Vector<String> getModelList() {
        BoxRequest br = new BoxRequest();
        br.typeRequest = 0;
        Vector listModels = (Vector)this.xstream.fromXML(this.sendRequest(br));
        return listModels;
    }

    @Override
    public Vector<DrawBoxParam> getParamList(int modelId) {
        BoxRequest br = new BoxRequest();
        br.typeRequest = 1;
        br.modelId = modelId;
        return (Vector)this.xstream.fromXML(this.sendRequest(br));
    }

    @Override
    public Vector<DrawBoxParam> setParameters(int modelId, Vector<DrawBoxParam> dbp) {
        BoxRequest br = new BoxRequest();
        br.typeRequest = 2;
        br.modelId = modelId;
        br.dbp = dbp;
        return (Vector)this.xstream.fromXML(this.sendRequest(br));
    }

    @Override
    public Document getModel(int modelId) {
        BoxRequest br = new BoxRequest();
        br.typeRequest = 3;
        br.modelId = modelId;
        return (Document)this.xstream.fromXML(this.sendRequest(br));
    }
}

