/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPathElement;
import ru.infor.boxboard.ColorPath;

public class ColorPathModel
extends AbstractTableModel {
    public Vector<ColorPath> colors;
    private String[] columnNames = new String[]{" ", "\u0414\u043b\u0438\u043d\u0430"};

    public ColorPathModel() {
        this.colors = new Vector();
    }

    public Object getValueAt(int row, int col) {
        Object Res = new Object();
        if (row < this.colors.size()) {
            switch (col) {
                case 0: {
                    Res = " ";
                    break;
                }
                case 1: {
                    Res = this.colors.get((int)row).length / 2.83;
                }
            }
        } else {
            Res = this.getTotalLength() / 2.83;
        }
        return Res;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.colors.size() + 1;
    }

    private ColorPath findByColor(String color) {
        ColorPath res = null;
        for (ColorPath cp : this.colors) {
            if (cp.color.compareTo(color) != 0) continue;
            res = cp;
            break;
        }
        return res;
    }

    public double getTotalLength() {
        double res = 0.0;
        for (ColorPath cp : this.colors) {
            res += cp.length;
        }
        return res;
    }

    public void addElement(SVGElement el) {
        this.addElement(el, false);
    }

    public void addElement(SVGElement el, boolean direct) {
        String color = el.getAttribute("stroke");
        double length = 0.0;
        try {
            length = ((SVGPathElement)el).getTotalLength();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        if (direct) {
            this.colors.addElement(new ColorPath(color, length));
        } else {
            ColorPath cp = this.findByColor(color);
            if (cp == null) {
                cp = new ColorPath(color, 0.0);
                this.colors.add(cp);
            }
            cp.length += length;
        }
    }

    public void clear() {
        this.colors.clear();
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

