/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import ru.infor.boxboard.ColorPathModel;

public class ColorRenderer
extends JLabel
implements TableCellRenderer {
    Border unselectedBorder = null;
    Border selectedBorder = null;
    Border border = null;
    boolean isBordered = true;

    public ColorRenderer(boolean isBordered) {
        this.isBordered = isBordered;
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (row < ((ColorPathModel)table.getModel()).colors.size()) {
            String col = ((ColorPathModel)table.getModel()).colors.elementAt((int)row).color;
            if (col == null) {
                Color newColor = Color.decode("#ffffff");
                this.setBackground(newColor);
            } else if (!col.equals("")) {
                Color newColor = Color.decode(col);
                this.setBackground(newColor);
            } else {
                Color newColor = Color.decode("#ffffff");
                this.setBackground(newColor);
            }
        } else {
            Color newColor = Color.decode("#ffffff");
            this.setBackground(newColor);
        }
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(6, 3, 6, 3, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(6, 3, 6, 3, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        return this;
    }
}

