/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.swing.JSVGCanvas;
import org.jdesktop.swingx.JXTreeTable;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGRect;
import ru.infor.boxboard.BoxBoardClient;
import ru.infor.boxboard.CanvasModifier;
import ru.infor.boxboard.ColorPathModel;
import ru.infor.boxboard.ColorRenderer;
import ru.infor.boxboard.VarInfoTableModel;
import ru.infor.boxboard.VarItem;
import ru.infor.boxboard.groupman.BlockPart;
import ru.infor.boxboard.groupman.GroupManager;
import ru.infor.boxboard.groupman.Rect;
import ru.infor.navy.util.PanelTools;
import ru.infor.navy.util.SVGTools;

public class ModelPlacer {
    static String clGray = "#808080";
    JComboBox angle = null;
    BoxBoardClient bbc = null;
    Element border = null;
    public JSVGCanvas canvas = new JSVGCanvas();
    TableCellRenderer colorRenderer = new ColorRenderer(true);
    public ColorPathModel colorPathModel = new ColorPathModel();
    public JTable colorPathTable = new JTable(this.colorPathModel){

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 0) {
                return ModelPlacer.this.colorRenderer;
            }
            return super.getCellRenderer(row, column);
        }
    };
    JButton delete = null;
    JTextField distXField = new JTextField(10);
    JTextField distYField = new JTextField(10);
    JToggleButton edit = null;
    GroupManager groupManager = new GroupManager(this);
    JTextField heightField = new JTextField(10);
    Element model = null;
    double modelLength = 0.0;
    Vector<Element> models = new Vector();
    public double modelX;
    public double modelY;
    public double modelWidth;
    public double modelHeight;
    public double corrX = 0.0;
    public double corrY = 0.0;
    JTextField offsetField = new JTextField(10);
    public JSVGCanvas placeCanvas = new JSVGCanvas();
    JButton savePage = null;
    JPanel toolbar = new JPanel(new FlowLayout(0));
    public VarItem variables = new VarItem("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", "", 0);
    public double width;
    public double height;
    public double offset = 50.0;
    public double inOffset = 1.0;
    public double distX = 1.0;
    public double distY = 1.0;
    JTextField widthField = new JTextField(10);

    public ModelPlacer(BoxBoardClient bbc) {
        this.bbc = bbc;
        this.border = null;
        VarItem vi = new VarItem("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043b\u0438\u0441\u0442\u0430", "", 0);
        this.variables.add(vi);
        vi.add(new VarItem("\u0428\u0438\u0440\u0438\u043d\u0430, \u043c\u043c.", "width", 2, 980.0));
        vi.add(new VarItem("\u0412\u044b\u0441\u043e\u0442\u0430, \u043c\u043c.", "height", 2, 680.0));
        vi.add(new VarItem("\u041e\u0442\u0441\u0442\u0443\u043f \u043e\u0442 \u043a\u0440\u0430\u044f, \u043c\u043c.", "inOffset", 2, 1.0));
        vi.add(new VarItem("\u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043f\u043e X, \u043c\u043c.", "offX", 2, 1.0));
        vi.add(new VarItem("\u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043f\u043e Y, \u043c\u043c.", "offY", 2, 1.0));
    }

    private void addElementPathLength(Element el) {
        NodeList nl = el.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof SVGPathElement) {
                this.colorPathModel.addElement((SVGElement)nl.item(i));
            }
            this.addElementPathLength((Element)nl.item(i));
            ++i;
        }
    }

    private void applyResize(JSVGCanvas c) {
        SVGDocument doc = c.getSVGDocument();
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", Double.toString(this.translate(this.width) + this.offset));
        svgRoot.setAttributeNS(null, "height", Double.toString(this.translate(this.height) + this.offset));
        c.setSVGDocument(doc);
    }

    private String bias(int count) {
        String res = "\u0448\u0442\u0443\u043a";
        int last = count - Math.round(count / 10) * 10;
        if (count < 10 && last == 1) {
            res = "\u0448\u0442\u0443\u043a\u0430";
        }
        if (last >= 2 && last <= 4 && count > 20) {
            res = "\u0448\u0442\u0443\u043a\u0438";
        }
        return res;
    }

    private void calcPathLength() {
        this.colorPathModel.clear();
        for (Element el : this.models) {
            this.addElementPathLength(el);
        }
        this.colorPathModel.fireTableDataChanged();
    }

    public void changeBlockPart(Element model, double length) {
        this.groupManager.changeBlockPart(this.canvas.getSVGDocument(), model, length);
        this.clearCanvas();
        this.applyResize(this.canvas);
        this.addPageBorder(this.canvas.getSVGDocument());
    }

    private void clearCanvas() {
        for (Element el : this.models) {
            SVGTools.removeElement(el);
        }
        this.models.removeAllElements();
    }

    public void combineModel() {
        Element g = this.groupManager.getCombinedModel(this.canvas.getSVGDocument());
        this.refreshCanvas();
        SVGRect sr = ((SVGLocatable)((Object)g)).getBBox();
        ((Element)g.getFirstChild()).setAttributeNS(null, "transform", "translate(" + (this.offset - (double)sr.getX()) + "," + (this.offset - (double)sr.getY()) + ")");
        this.corrX = this.offset - (double)sr.getX();
        this.corrY = this.offset - (double)sr.getY();
        Document blockDoc = this.createNewDoc(this.translate(this.width) + this.offset, this.translate(this.height) + this.offset);
        this.model = blockDoc.createElementNS("http://www.w3.org/2000/svg", "g");
        SVGTools.cloneElement(blockDoc, g, this.model);
        this.setModelParam(sr, this.groupManager.getModelLength());
        SVGTools.removeElement(g);
    }

    private int count(double w, double h) {
        double xe = this.trans(this.width);
        double ye = this.trans(this.height);
        double dxt = this.trans(this.distX);
        double dyt = this.trans(this.distY);
        double it = this.trans(this.inOffset);
        double xc = Math.floor((xe - 2.0 * it) / (w + dxt));
        double yc = Math.floor((ye - 2.0 * it) / (h + dyt));
        return (int)Math.round(xc * yc);
    }

    public JPanel createGroupPanel() {
        JPanel p = PanelTools.createVerticalPanel();
        String[] rotate = new String[]{"0", "90", "180", "270"};
        JButton addModel = new JButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/ru/infor/boxboard/res/add.png"));
        addModel.setIcon(icon);
        addModel.setToolTipText("<html>&nbsp;\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 \u043c\u043e\u0434\u0435\u043b\u0438&nbsp;");
        addModel.setMargin(new Insets(0, 6, 0, 6));
        JPanel editPanel = new JPanel(new FlowLayout(0));
        editPanel.add(addModel);
        editPanel.setMaximumSize(new Dimension(1000, addModel.getHeight() + 120));
        editPanel.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 100)));
        addModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelPlacer.this.groupManager.addEtalon(ModelPlacer.this.canvas.getSVGDocument(), 0.0, 0.0, 0.0);
                ModelPlacer.this.setPrePlaceInfo();
                ModelPlacer.this.refreshCombineCanvas();
            }
        });
        editPanel.add(new JLabel("  \u041f\u043e\u0432\u043e\u0440\u043e\u0442:"));
        this.angle = new JComboBox<String>(rotate);
        this.angle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelPlacer.this.groupManager.setSelectedAngle(Double.valueOf((String)((JComboBox)e.getSource()).getSelectedItem()));
                ModelPlacer.this.setPrePlaceInfo();
                ModelPlacer.this.refreshCombineCanvas();
            }
        });
        this.angle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        editPanel.add(this.angle);
        this.delete = new JButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
        this.delete.setToolTipText("<html>&nbsp;\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439&nbsp;<br>&nbsp;\u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 \u043c\u043e\u0434\u0435\u043b\u0438&nbsp;");
        icon = new ImageIcon(this.getClass().getResource("/ru/infor/boxboard/res/remove.png"));
        this.delete.setIcon(icon);
        this.delete.setMargin(new Insets(0, 6, 0, 6));
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelPlacer.this.groupManager.deleteSelected();
                ModelPlacer.this.setPrePlaceInfo();
                ModelPlacer.this.refreshCombineCanvas();
            }
        });
        editPanel.add(this.delete);
        editPanel.add(new JPanel());
        JButton saveGroup = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443");
        saveGroup.setToolTipText("<html>&nbsp;\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0447\u0438\u0441\u043b\u043e \u0438 \u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0435\u043b\u0435\u0439&nbsp;");
        icon = new ImageIcon(this.getClass().getResource("/ru/infor/boxboard/res/saveGroup.png"));
        saveGroup.setIcon(icon);
        saveGroup.setMargin(new Insets(0, 6, 0, 6));
        saveGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        editPanel.add(saveGroup);
        p.add(editPanel);
        p.add(this.canvas);
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                if (ModelPlacer.this.groupManager.drag == ModelPlacer.this.groupManager.DRAG_DOWN) {
                    ModelPlacer.this.groupManager.drag = ModelPlacer.this.groupManager.DRAG_UP;
                }
            }
        });
        new CanvasModifier();
        CanvasModifier.modify(this.canvas);
        this.canvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                double x = 0.0;
                double y = 0.0;
                int step = 1;
                if (e.getModifiers() == 1) {
                    step = 10;
                }
                if (e.getKeyCode() == 40) {
                    y = step;
                }
                if (e.getKeyCode() == 38) {
                    y = -step;
                }
                if (e.getKeyCode() == 39) {
                    x = step;
                }
                if (e.getKeyCode() == 37) {
                    x = -step;
                }
                ModelPlacer.this.groupManager.directMoveSelected(x, y);
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                if (!ModelPlacer.this.canvas.isFocusOwner()) {
                    ModelPlacer.this.canvas.grabFocus();
                }
                super.mouseMoved(e);
            }
        });
        this.canvas.setSVGDocument((SVGDocument)this.createNewDoc(100.0, 100.0));
        this.canvas.setDocumentState(1);
        this.canvas.addUpdateManagerListener(new UpdateManagerListener(){

            public void managerResumed(UpdateManagerEvent arg0) {
            }

            public void managerStarted(UpdateManagerEvent arg0) {
                ModelPlacer.this.reScale(ModelPlacer.this.canvas);
            }

            public void managerStopped(UpdateManagerEvent arg0) {
            }

            public void managerSuspended(UpdateManagerEvent arg0) {
            }

            public void updateCompleted(UpdateManagerEvent arg0) {
            }

            public void updateFailed(UpdateManagerEvent arg0) {
            }

            public void updateStarted(UpdateManagerEvent arg0) {
            }
        });
        this.groupManager.addMoveGroups(this.canvas.getSVGDocument());
        JPanel pApply = new JPanel();
        JButton bApply = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        icon = new ImageIcon(this.getClass().getResource("/ru/infor/boxboard/res/refresh.png"));
        bApply.setIcon(icon);
        String text = "<html>&nbsp;\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f&nbsp;";
        bApply.setToolTipText(text);
        bApply.setMargin(new Insets(0, 6, 0, 6));
        pApply.add(bApply);
        pApply.setMaximumSize(new Dimension(1000, bApply.getHeight() + 120));
        JPanel res = PanelTools.createVerticalPanel();
        res.add(p);
        return res;
    }

    public Element createLine(Document doc, double x, double y, double xe, double ye, String color) {
        Element svgRoot = doc.getDocumentElement();
        String svgNS = "http://www.w3.org/2000/svg";
        Element line = doc.createElementNS(svgNS, "path");
        line.setAttributeNS(null, "fill", "none");
        line.setAttributeNS(null, "stroke", color);
        line.setAttributeNS(null, "stroke-width", "1");
        StringBuffer sb = new StringBuffer("M");
        sb.append(this.translate(x));
        sb.append(",");
        sb.append(this.translate(y));
        sb.append("L");
        sb.append(this.translate(xe));
        sb.append(",");
        sb.append(this.translate(ye));
        line.setAttributeNS(null, "d", sb.toString());
        svgRoot.appendChild(line);
        return line;
    }

    public Document createNewDoc(double width, double height) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNS, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", "" + width);
        svgRoot.setAttributeNS(null, "height", "" + height);
        return doc;
    }

    public JPanel createPlacePanel() {
        JSplitPane splitMain = new JSplitPane(1);
        JSplitPane split2 = new JSplitPane(0, true);
        JButton buttonSP = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/ru/infor/boxboard/res/floppy.png"));
        buttonSP.setIcon(icon);
        buttonSP.setMargin(new Insets(0, 6, 0, 6));
        buttonSP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int count = Double.valueOf(ModelPlacer.this.models.size() * ModelPlacer.this.groupManager.getSize()).intValue();
                String s = ModelPlacer.this.bias(count);
                ModelPlacer.this.bbc.saveForm.save(ModelPlacer.this.placeCanvas, String.valueOf(ModelPlacer.this.bbc.generateOutFileName()) + "__" + count + "_" + s + "_\u043d\u0430_\u043b\u0438\u0441\u0442\u0435.svg");
            }
        });
        String text = "<html>&nbsp;\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0432 \u0444\u0430\u0439\u043b&nbsp;<br>&nbsp;\u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 <b>SVG</b>&nbsp;";
        buttonSP.setToolTipText(text);
        JPanel placePanel = new JPanel(new FlowLayout(0));
        placePanel.add(buttonSP);
        placePanel.setMaximumSize(new Dimension(1000, buttonSP.getHeight() + 120));
        placePanel.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 100)));
        JPanel p = PanelTools.createVerticalPanel();
        p.add(placePanel);
        p.add(this.placeCanvas);
        new CanvasModifier();
        CanvasModifier.modify(this.placeCanvas);
        this.placeCanvas.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                if (ModelPlacer.this.groupManager.drag == ModelPlacer.this.groupManager.DRAG_DOWN) {
                    ModelPlacer.this.groupManager.drag = ModelPlacer.this.groupManager.DRAG_UP;
                }
            }
        });
        this.placeCanvas.setSVGDocument((SVGDocument)this.createNewDoc(100.0, 100.0));
        this.placeCanvas.setDocumentState(1);
        this.placeCanvas.addUpdateManagerListener(new UpdateManagerListener(){

            public void managerResumed(UpdateManagerEvent arg0) {
            }

            public void managerStarted(UpdateManagerEvent arg0) {
                ModelPlacer.this.reScale(ModelPlacer.this.placeCanvas);
                ModelPlacer.this.calcPathLength();
            }

            public void managerStopped(UpdateManagerEvent arg0) {
            }

            public void managerSuspended(UpdateManagerEvent arg0) {
            }

            public void updateCompleted(UpdateManagerEvent arg0) {
            }

            public void updateFailed(UpdateManagerEvent arg0) {
            }

            public void updateStarted(UpdateManagerEvent arg0) {
            }
        });
        splitMain.setDividerLocation(250);
        splitMain.setRightComponent(p);
        splitMain.setLeftComponent(split2);
        JPanel param = PanelTools.createVerticalPanel();
        JXTreeTable parameters = new JXTreeTable();
        parameters.setTreeTableModel(new VarInfoTableModel(this.variables));
        JTableHeader header = parameters.getTableHeader();
        TableColumnModel cm = header.getColumnModel();
        cm.getColumn(0).setPreferredWidth(200);
        parameters.expandAll();
        param.add(new JScrollPane(parameters));
        JPanel pApply = new JPanel();
        JButton bApply = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        icon = new ImageIcon(this.getClass().getResource("/ru/infor/boxboard/res/refresh.png"));
        bApply.setIcon(icon);
        bApply.setToolTipText("<html>&nbsp;\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f&nbsp;");
        bApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelPlacer.this.setPageParam();
                ModelPlacer.this.clearCanvas();
                ModelPlacer.this.addPageBorder(ModelPlacer.this.placeCanvas.getSVGDocument());
                ModelPlacer.this.applyResize(ModelPlacer.this.placeCanvas);
                ModelPlacer.this.fillCanvas();
            }
        });
        bApply.setMargin(new Insets(0, 6, 0, 6));
        pApply.add(bApply);
        pApply.setMaximumSize(new Dimension(1000, bApply.getHeight() + 120));
        param.add(pApply);
        split2.setTopComponent(param);
        split2.setDividerLocation(200);
        header = this.colorPathTable.getTableHeader();
        cm = header.getColumnModel();
        cm.getColumn(0).setMaxWidth(20);
        split2.setBottomComponent(new JScrollPane(this.colorPathTable));
        JPanel res = PanelTools.createVerticalPanel();
        res.add(splitMain);
        return res;
    }

    public void addPageBorder(Document doc) {
        if (this.border != null) {
            this.border.getParentNode().removeChild(this.border);
        }
        this.border = SVGTools.createRect(doc, this.translate(0.0), this.translate(0.0), this.translate(this.width) - this.offset, this.translate(this.height) - this.offset, "none", clGray, 1.0, 255, "");
        doc.getDocumentElement().appendChild(this.border);
    }

    public void removePageBorder() {
        this.border.getParentNode().removeChild(this.border);
        this.border = null;
    }

    private void fillCanvas() {
        int c1 = this.count(this.modelWidth, this.modelHeight);
        int c2 = this.count(this.modelHeight, this.modelWidth);
        int xc = 0;
        int yc = 0;
        double xe = this.trans(this.width);
        double ye = this.trans(this.height);
        double dxt = this.trans(this.distX);
        double dyt = this.trans(this.distY);
        double it = this.trans(this.inOffset);
        if (c1 > c2) {
            xc = (int)Math.floor((xe - 2.0 * it) / (this.modelWidth + dxt));
            yc = (int)Math.floor((ye - 2.0 * it) / (this.modelHeight + dyt));
            int x = 0;
            while (x < xc) {
                int y = 0;
                while (y < yc) {
                    this.placeModel(it + (double)x * (this.modelWidth + dxt), it + (double)y * (this.modelHeight + dyt));
                    ++y;
                }
                ++x;
            }
        } else {
            xc = (int)Math.floor((xe - 2.0 * it) / (this.modelHeight + dxt));
            yc = (int)Math.floor((ye - 2.0 * it) / (this.modelWidth + dyt));
            double xcorr = it + (this.modelWidth - this.modelHeight) / 2.0;
            double ycorr = -it - (this.modelHeight - this.modelWidth) / 2.0;
            int x = 0;
            while (x < xc) {
                int y = 0;
                while (y < yc) {
                    this.placeModel((double)y * (this.modelWidth + dyt) + xcorr, (double)(-x) * (this.modelHeight + dxt) + ycorr, true, this.modelX + this.modelWidth / 2.0, this.modelY + this.modelHeight / 2.0);
                    ++y;
                }
                ++x;
            }
        }
        this.bbc.setStatusText("<html>&nbsp;\u0414\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0439 \u043e\u0434\u043d\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430: " + String.format("<font color=blue><b>%8.2f</b>", this.modelLength / (double)this.groupManager.getSize()) + "<font color=black> \u043c\u043c., " + "&nbsp;\u0432\u0441\u0435\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432: " + "<font color=blue><b>" + Double.valueOf(xc * yc * this.groupManager.getSize()).intValue() + "</b>" + ", <font color=black>" + "&nbsp;\u043e\u0431\u0449\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0439: " + String.format("<font color=blue><b>%8.2f</b>", (double)(xc * yc) * this.modelLength) + "<font color=black> \u043c\u043c.<br>");
    }

    private void placeModel(double x, double y) {
        this.placeModel(x, y, false, 0.0, 0.0);
    }

    private void placeModel(double x, double y, boolean rotate, double cx, double cy) {
        String r = "";
        if (rotate) {
            r = " rotate(90," + cx + "," + cy + ") ";
        }
        SVGDocument doc = this.placeCanvas.getSVGDocument();
        Element svgRoot = doc.getDocumentElement();
        String svgNS = "http://www.w3.org/2000/svg";
        Element g = doc.createElementNS(svgNS, "g");
        this.models.add(g);
        g.setAttributeNS(null, "transform", String.valueOf(r) + "translate(" + (x + this.corrX) + "," + (y + this.corrY) + ")");
        svgRoot.appendChild(g);
        SVGTools.cloneElement(doc, this.model, g);
    }

    public void refreshCanvas() {
        this.placeCanvas.setRenderingTransform(this.canvas.getRenderingTransform());
    }

    public void refreshCombineCanvas() {
        this.canvas.setRenderingTransform(this.canvas.getRenderingTransform());
    }

    public void reScale(JSVGCanvas c) {
        double scale;
        AffineTransform transform = new AffineTransform();
        Dimension2D d = c.getSVGDocumentSize();
        Rectangle rect = c.getVisibleRect();
        double xmove = 0.0;
        double ymove = 0.0;
        double scaleX = (double)rect.width / d.getWidth();
        ymove = (double)rect.height - d.getHeight() * scaleX;
        double scaleY = (double)rect.height / d.getHeight();
        xmove = (double)rect.width - d.getWidth() * scaleY;
        if (scaleX < scaleY) {
            scale = scaleX;
            xmove = 0.0;
        } else {
            scale = scaleY;
            ymove = 0.0;
        }
        transform.scale(scale, scale);
        transform.translate(xmove, ymove);
        c.setRenderingTransform(transform);
    }

    public void setBlockPart(Element model, double length) {
        this.groupManager.setBlockPart(model, length);
        this.clearCanvas();
        this.applyResize(this.canvas);
        this.addPageBorder(this.canvas.getSVGDocument());
        this.groupManager.addEtalon(this.canvas.getSVGDocument(), 0.0, 0.0, 0.0);
    }

    public void setBlockPartInfo(BlockPart bp) {
        if (bp != null) {
            this.angle.setSelectedIndex((int)bp.angle / 90);
        }
    }

    public void setModelParam(SVGRect r, double length) {
        this.modelLength = length;
        this.modelWidth = r.getWidth();
        this.modelHeight = r.getHeight();
        this.modelX = r.getX();
        this.modelY = r.getY();
        this.applyResize(this.placeCanvas);
        this.clearCanvas();
        this.addPageBorder(this.placeCanvas.getSVGDocument());
        this.refreshCanvas();
        this.fillCanvas();
    }

    public void setPageParam() {
        this.width = (Double)this.variables.findValueByAlias("width");
        this.height = (Double)this.variables.findValueByAlias("height");
        this.inOffset = (Double)this.variables.findValueByAlias("inOffset");
        this.distX = (Double)this.variables.findValueByAlias("offX");
        this.distY = (Double)this.variables.findValueByAlias("offY");
    }

    public void setPrePlaceInfo() {
        int c2;
        Rect r = this.groupManager.getBlockRect();
        int c1 = this.count(r.width, r.height);
        c1 = c1 > (c2 = this.count(r.height, r.width)) ? c1 : c2;
        this.bbc.setStatusText("<html>\u0412\u0441\u0435\u0433\u043e \u043d\u0430 \u043b\u0438\u0441\u0442\u0435 \u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432: <font color=blue><b>" + Double.valueOf(c1 * this.groupManager.getSize()).intValue() + "</b>" + "<font color=black>, \u0440\u0430\u0437\u043c\u0435\u0440 \u0431\u043b\u043e\u043a\u0430: " + String.format("<font color=blue><b>%8.2f</b>", r.width / 2.83) + "<font color=black>  x " + String.format("<font color=blue><b>%8.2f</b>", r.height / 2.83) + "<font color=black>  \u043c\u043c.");
    }

    public double trans(double coord) {
        return coord * 2.83;
    }

    public double translate(double coord) {
        return coord * 2.83 + this.offset;
    }

    public double getPageWidth() {
        return this.trans(this.width);
    }

    public double getPageHeight() {
        return this.trans(this.height);
    }
}

