/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import ru.infor.navy.util.myXML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    protected static Hashtable<String, String> hashtable = null;
    protected String xmlFileName;

    public Parameters(String xmlFileName) {
        this.xmlFileName = xmlFileName;
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.readProperties();
        }
    }

    public Hashtable<String, String> getNamingProperties() {
        return hashtable;
    }

    public void saveProperties() {
        try {
            myXML root = new myXML("items");
            for (Map.Entry<String, String> entry : hashtable.entrySet()) {
                myXML sub = root.addElement("item");
                sub.Attribute.add("name", entry.getKey());
                sub.Attribute.add("value", entry.getValue());
            }
            FileWriter out = new FileWriter(this.xmlFileName);
            PrintWriter pw = new PrintWriter(out);
            root.serialize(pw);
            out.flush();
            out.close();
        }
        catch (myXML.myXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readProperties() {
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.xmlFileName));
            myXML root = new myXML(in).findElement("items");
            int i = 0;
            while (i < root.size()) {
                myXML item = root.getElement(i);
                if (item.getTag().equalsIgnoreCase("item")) {
                    hashtable.put(item.Attribute.find("name"), item.Attribute.find("value"));
                }
                ++i;
            }
        }
        catch (FileNotFoundException in) {
        }
        catch (myXML.myXMLException e) {
            e.printStackTrace();
        }
        catch (myXML.myXMLEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        this.saveProperties();
    }
}

