/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.swing.JSVGCanvas;
import org.w3c.dom.Document;
import ru.infor.boxboard.BoxBoardClient;
import ru.infor.navy.util.LengthCollector;

public class SaveForm
extends JFrame {
    BoxBoardClient bb = null;
    JComboBox path = new JComboBox();
    JTextField name = new JTextField();
    JCheckBox saveBorder = new JCheckBox("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0433\u0440\u0430\u043d\u0438\u0446\u0443 \u043b\u0438\u0441\u0442\u0430");
    JCheckBox saveLengthInfo = new JCheckBox("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u0434\u043b\u0438\u043d\u0435 \u043d\u043e\u0436\u0435\u0439");
    JSVGCanvas canvas = null;

    public SaveForm(BoxBoardClient bb) throws Exception {
        super("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        this.bb = bb;
        this.InitGUI();
    }

    public static void writeXmlFile(Document doc, String filename) throws Exception {
        if (doc == null) {
            return;
        }
        try {
            DOMSource source = new DOMSource(doc);
            FileWriter fw = new FileWriter(filename, true);
            StreamResult result = new StreamResult(fw);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    public void save(JSVGCanvas canvas, String defFileName) {
        this.save(canvas, defFileName, true, true);
    }

    public void save(JSVGCanvas canvas, String defFileName, boolean showSaveBorder, boolean showSaveLengthInfo) {
        this.saveBorder.setVisible(showSaveBorder);
        this.saveLengthInfo.setVisible(showSaveLengthInfo);
        this.canvas = canvas;
        this.name.setText(defFileName);
        this.pack();
        this.setVisible(true);
    }

    public void InitGUI() throws Exception {
        this.setSize(450, 200);
        this.saveBorder.setSelected(false);
        this.saveLengthInfo.setSelected(false);
        JPanel grid = new JPanel(new GridLayout(1, 2, 5, 0));
        JButton bSave = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        bSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SaveForm.this.saveBorder.isSelected()) {
                    SaveForm.this.bb.modelPlacer.addPageBorder(SaveForm.this.canvas.getSVGDocument());
                }
                if (SaveForm.this.saveLengthInfo.isSelected()) {
                    LengthCollector lc = new LengthCollector(SaveForm.this.canvas.getSVGDocument());
                    lc.drawInfo(SaveForm.this.canvas, 10.0, 10.0);
                }
                try {
                    SaveForm.writeXmlFile(SaveForm.this.canvas.getSVGDocument(), SaveForm.this.path.getSelectedItem() + SaveForm.this.name.getText());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw new RuntimeException(e1);
                }
                SaveForm.this.bb.params.getNamingProperties().put("SavePathSelected", String.valueOf(SaveForm.this.path.getSelectedIndex()));
                SaveForm.this.bb.params.saveProperties();
                SaveForm.this.setVisible(false);
            }
        });
        JButton bCancel = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        bCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveForm.this.setVisible(false);
            }
        });
        grid.add(bSave);
        grid.add(bCancel);
        JPanel flow = new JPanel(new FlowLayout(2));
        flow.add(grid);
        Container c = this.getContentPane();
        c.add((Component)flow, "South");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel pathPan = new JPanel(new FlowLayout(2));
        pathPan.add(new JLabel("\u041f\u0443\u0442\u044c: "));
        String outPath = "";
        int i = 1;
        while ((outPath = this.bb.params.getNamingProperties().get("SavePath" + i)) != null) {
            this.path.addItem(outPath);
            ++i;
        }
        int sel = -1;
        try {
            sel = Integer.valueOf(this.bb.params.getNamingProperties().get("SavePathSelected"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sel > -1 && sel < i) {
            this.path.setSelectedIndex(sel);
        }
        Dimension d = this.path.getPreferredSize();
        d.width += 100;
        this.path.setPreferredSize(d);
        pathPan.add(this.path);
        JButton bSelDir = new JButton("...");
        bSelDir.setMargin(new Insets(0, 2, 0, 2));
        bSelDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser((String)SaveForm.this.path.getSelectedItem());
                fc.setDialogTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0430\u043b\u043e\u0433");
                fc.setFileSelectionMode(1);
                int res = fc.showOpenDialog(SaveForm.this);
                if (res == 0) {
                    String p = fc.getSelectedFile().toString();
                    if (p.charAt(p.length() - 1) != '\\') {
                        p = String.valueOf(p) + "\\";
                    }
                    SaveForm.this.path.addItem(p);
                    SaveForm.this.path.setSelectedIndex(SaveForm.this.path.getItemCount() - 1);
                    SaveForm.this.bb.params.getNamingProperties().put("SavePath" + SaveForm.this.path.getItemCount(), p);
                    SaveForm.this.bb.params.saveProperties();
                }
            }
        });
        pathPan.add(bSelDir);
        JPanel namePan = new JPanel(new FlowLayout(2));
        namePan.add(new JLabel("\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430: "));
        namePan.add(this.name);
        p.add(pathPan);
        p.add(namePan);
        p.add(this.saveBorder);
        p.add(this.saveLengthInfo);
        c.add((Component)p, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }
}

