/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class VarItem
implements TreeNode {
    static final int NODE = 0;
    static final int INT = 1;
    static final int FLOAT = 2;
    static final int LIST = 3;
    static final int STRING = 4;
    public int type = 0;
    private int selectedChild = 0;
    private int valInt = 0;
    private double valFloat = 0.0;
    private String valString = "";
    public String caption = "";
    public String alias = "";
    public VarItem parent = null;
    private Vector<VarItem> childs = new Vector();

    public VarItem(String caption, String alias, int type) {
        this.caption = caption;
        this.type = type;
        this.alias = alias;
    }

    public VarItem(String caption, String alias, int type, int val) {
        this(caption, alias, type);
        this.setValue(val);
    }

    public VarItem(String caption, String alias, int type, double val) {
        this(caption, alias, type);
        this.setValue(val);
    }

    public VarItem(String caption, String alias, int type, String val) {
        this(caption, alias, type);
        this.setValue(val);
    }

    public int add(VarItem vi) {
        this.childs.add(vi);
        vi.parent = this;
        return this.childs.size() - 1;
    }

    public Object findValueByAlias(String alias) {
        Object res = null;
        if (this.alias.compareTo(alias) == 0) {
            res = this.getValue();
        } else {
            for (VarItem vi : this.childs) {
                res = vi.findValueByAlias(alias);
                if (res != null) break;
            }
        }
        return res;
    }

    public Object getValue() {
        Object res = null;
        switch (this.type) {
            case 0: {
                res = "";
                break;
            }
            case 4: {
                res = this.valString;
                break;
            }
            case 1: {
                res = this.valInt;
                break;
            }
            case 2: {
                res = this.valFloat;
                break;
            }
            case 3: {
                res = this.childs.elementAt(this.selectedChild).getValue();
            }
        }
        return res;
    }

    public void setValue(int val) {
        if (this.type == 3) {
            this.childs.elementAt(this.selectedChild).setValue(val);
        } else {
            this.valInt = val;
        }
    }

    public void setValue(double val) {
        if (this.type == 3) {
            this.childs.elementAt(this.selectedChild).setValue(val);
        } else {
            this.valFloat = val;
        }
    }

    public void setValue(String val) {
        if (this.type == 3) {
            this.childs.elementAt(this.selectedChild).setValue(val);
        } else {
            this.valString = val;
        }
    }

    public Enumeration children() {
        return this.childs == null ? null : this.childs.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return this.childs == null ? null : this.childs.elementAt(childIndex);
    }

    public int getChildCount() {
        return this.childs == null ? 0 : this.childs.size();
    }

    public int getIndex(TreeNode node) {
        return this.childs == null ? 0 : this.childs.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.childs.size() == 0;
    }

    public String toString() {
        return this.caption;
    }
}

